/*
 * OpenI2CRADIO
 * Menu sub-routines.
 * Copyright (C) 2013-06-21 K.Ohta <whatisthis.sowhat ai gmail.com>
 * License: GPL2+LE
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2,
 *  or (at your option) any later version.
 *  This library / program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this library; see the file COPYING. If not, write to the
 *  Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 *
 *  As a special exception, if you link this(includeed from sdcc) library
 *  with other files, some of which are compiled with SDCC,
 *  to produce an executable, this library does not by itself cause
 *  the resulting executable to be covered by the GNU General Public License.
 *  This exception does not however invalidate any other reasons why
 *  the executable file might be covered by the GNU General Public License.
 */

#ifndef MENU_H
#define	MENU_H

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#if defined(__SDCC)
#include <sdcc-lib.h>
#include <pic18fregs.h> /* ONLY FOR PIC18x */
#include <delay.h>
#else
#include <xc.h>
#endif

#include "iodef.h"
#include "idle.h"
#include "i2c_io.h"
#include "akc6955.h"
#include "lcd_acm1602.h"
#include "ui.h"
#include "eeprom.h"
#include "ioports.h"
#include "helps.h"
#include "menu_ui.h"
#include "eeprom_util.h"


#ifdef	__cplusplus
extern "C" {
#endif
#define USER_BAND_NUM 3
    typedef struct {
        unsigned char mode3k; // mode3k if am
        unsigned char start;
        unsigned char stop;
        unsigned int freq;
    } _userband_t;
    
#define USER_MEMORY_NUM 28
    typedef struct {
        unsigned char band;
        unsigned char fm;
        unsigned int freq;
    } _memoryfreq_t;
    /*
     * main.c
     */
// Frequencyset of 1Sector.
// Below v1.0.
typedef struct {
    unsigned int magic;
    unsigned int version;
    unsigned int pagenum;
    _memoryfreq_t memoryfreqs[USER_MEMORY_NUM];
    unsigned int checksum;
} __freqset_t;

typedef struct {
    unsigned int amfreq;
    unsigned int fmfreq;
    unsigned int amfreq_bank[AKC6955_BAND_AMEND];
    unsigned int fmfreq_bank[AKC6955_BAND_FMEND];
    unsigned char amband;
    unsigned char fmband;
    unsigned char fm;
    unsigned char am_mode3k;
    unsigned char am_userbandnum;
    unsigned char fm_userbandnum;
    unsigned char threshold_amcnr; // Reg 0x08
    unsigned char threshold_fmcnr; // Reg 0x08
    unsigned char threshold_width; // Reg 0x08
    unsigned char threshold_fmstereo; // Reg 0x08
    _userband_t am_usrbands[USER_BAND_NUM];
    _userband_t fm_usrbands[USER_BAND_NUM];
    banddesc am_userband_freq[USER_BAND_NUM];
    banddesc fm_userband_freq[USER_BAND_NUM];
    unsigned char stereo;
    unsigned char volume;
    unsigned char prevolume;
    unsigned char fmbandwidth;
    unsigned char lowboost;
    int backlight_long;
    int backlight_level;
    unsigned int ui_idlecount;
    unsigned int memorynum;
    _memoryfreq_t memoryfreqs[USER_MEMORY_NUM];
} __radioset_t;


    extern __radioset_t setup;
    extern unsigned char scanflag;

    extern unsigned char stereoflag;
    extern unsigned char tuneflag;
    extern unsigned char cnrlevel;
    extern int diffstat;
    extern unsigned int batlevel_6955;
    extern unsigned int battlevel;

    extern int recv_signal;
    extern unsigned char backlight_level;
    extern unsigned char pollkeybuf[33];
    extern unsigned char scanflag;



    /*
     * ui_updown.c
     */
    extern void setfreq_updown(unsigned char ctlword);
    extern void setdefault(void);

    /*
     * menu_userband.c
     */
    extern void input_userband(void);
    extern void set_userband(void);
    extern void call_userband(unsigned char num);

    /*
     * menu_scan.c
     */
    extern void scan_start(void);
    /*
     * menu_volume.c
     */
    extern void set_volume(void);

    /*
     * menu_defs.c
     */
    extern void setdefault(void);
    extern void valinit(void);


    /*
     * menu.c
     */
    extern void toggle_amfm(void);
    extern void set_stereomode(void);
    extern void set_stereo(void);
    extern void setband_direct(void);
    extern void setfreq_direct(void);
    extern void menu_poweroff(void);
    extern void setup_akc6955(void);
    extern void main_menu(void);

    /*
     * menu_setup.c
     */
    extern void setup_menu(void);
    extern void menu_load(void);
    extern void menu_save(void);



#ifdef	__cplusplus
}
#endif

#endif	/* MENU_H */

