/*
 * OpenI2CRADIO
 * I/O Port Handler
 * Copyright (C) 2013-06-20 K.Ohta <whatisthis.sowhat ai gmail.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2,
 *  or (at your option) any later version.
 *  This library / program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this library; see the file COPYING. If not, write to the
 *  Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 *
 *  As a special exception, if you link this(includeed from sdcc) library
 *  with other files, some of which are compiled with SDCC,
 *  to produce an executable, this library does not by itself cause
 *  the resulting executable to be covered by the GNU General Public License.
 *  This exception does not however invalidate any other reasons why
 *  the executable file might be covered by the GNU General Public License.
 */
#include "commondef.h"
#include "ioports.h"
#include <signal.h>

unsigned char statecount;

void set_amfmlamp(unsigned char f)
{
    if(f == 0x00) {
        _AM_STATLAMP = 0;
        _FM_STATLAMP = 1;
    } else {
        _AM_STATLAMP = 1;
        _FM_STATLAMP = 0;
    }
}


void set_examp_mute(unsigned char f)
{
    if(f == 0x00) {
        _PORT_MUTE = 1; // 20130709 Not Mute
    } else {
        _PORT_MUTE = 0;
    }
    idle_time_ms(200);
}

void set_radiopower(unsigned char f)
{
    if(f == 0x00) {
        _PORT_RADIOPOW = 0; // OFF
    } else {
        _PORT_RADIOPOW = 1; // ON
    }
}

void set_powerlamp(unsigned char f)
{
    if(f == 0x00) {
        _POW_STATLAMP = 0;
    } else {
        _POW_STATLAMP = 1;
    }
}

void lcd_setbacklight(unsigned char flag, unsigned char level)
{
    __bitops_t  b;
    __bitops_t d;
#if 0
    d.byte = _LCD_BACKLIGHT_TRIS;
    d._LCD_BACKLIGHT_BIT = 0;
   _LCD_BACKLIGHT_TRIS = d.byte;

    b.byte = _LCD_BACKLIGHT;
    b._LCD_BACKLIGHT_BIT = 0;
    if(flag != 0){
       b._LCD_BACKLIGHT_BIT = 1;
    }
    _LCD_BACKLIGHT = b.byte;
#else
    if(flag == 0) {
        d.byte = _LCD_BACKLIGHT_TRIS;
        d._LCD_BACKLIGHT_BIT = 1;
        _LCD_BACKLIGHT_TRIS = d.byte;
        PSTRCONbits.STRA = 0;
        T2CONbits.TMR2ON = 0;
        TMR2 = 0x00;
        CCP2CON = 0x00;
        CCPR2L = 0;
        CCPR2H = 0;
    } else {
      unsigned char h,l;
//      lv = level;
//      lv <<= 2;
//      level = (level * 25) / 10;
//      level = 255;
      h = level >> 1;
      if(h == CCPR1L) return;
 //     l = 2 << 4; //(lv & 0x0300) >> 4;
      d.byte = _LCD_BACKLIGHT_TRIS;
      d._LCD_BACKLIGHT_BIT = 1;
      _LCD_BACKLIGHT_TRIS = d.byte;
      //PSTRCON = 0;
      CCPR2L = h;
      CCPR2H = h;
      b.b2 = 1;
      b.b3 = 1;
      CCP2CON = b.byte;
      PR2 = 50;
      PIR1bits.TMR2IF = 0;
      T2CON = 0b01111000; // Pre-scaler=1/1,Post-scaler = 1/16
      // -> Freq = 2.44KHz * 16 = 39.4KHz.
      TMR2 = 0x00;
      T2CONbits.TMR2ON = 1;
      do {
          idle_time_ms(1);
      } while(PIR1bits.TMR2IF ==0);
      d.byte = _LCD_BACKLIGHT_TRIS;
      d._LCD_BACKLIGHT_BIT = 0;
      _LCD_BACKLIGHT_TRIS = d.byte;

//      _LCD_PORT |= _LCD_BACKLIGHT;
    }
#endif
}

void TMR3_set(void)
{
    TMR3L = 1000 & 0xff;
    TMR3H = 1000 >> 8;
    T3CONbits.TMR3ON = 1;
}

void io_intcountinit(void)
{
    statecount = 0;
    T3CON = 0b10001100; // TMR3 = 16bit, CCP is not use TMR3, Prescaler=1:2(1uS)
                        // DO-not-use SYNC, Internal clock, TMR3 temporally off.
    PIR2bits.TMR3IF = 0;
    PIE2bits.TMR3IE = 1;
    IPR2bits.TMR3IP = 0; // Low priority.
    INTCONbits.PEIE = 1;
    RCONbits.IPEN = 0;
    TMR3L = 0;
    TMR3H = 0;
    TMR3_set();
}



#if defined(pic18f23k22) || defined(pic18f24k22) || defined(pic18f25k22) || defined(pic18f26k22) || \
    defined(_18F23K22)  || defined(_18F24K22)  || defined(_18F25K22)  || defined(_18F26K22)

/*
 * For 28Pin PIC(18F2xK22), I2C lcd using.
 */

void keyin_ioinit(void)
{
    /* Initialize IOPORTS*/
    PORTA = 0x00;
    LATA = 0x00;
    ANSELA = AN_A_VAL;
    TRISA = TRIS_A_VAL;

    PORTB = 0x00;
    LATB = 0x00;
    ANSELB = AN_B_VAL;
    TRISB = TRIS_B_VAL;

    PORTC = 0x00;
    LATC = 0x00;
    ANSELC = AN_C_VAL;
    TRISC = TRIS_C_VAL_O;
 //   lcd_backlightinit();
    io_intcountinit();
}
#endif

#if defined(pic18f23k20) || defined(pic18f24k20) || defined(pic18f25k20) || defined(pic18f26k20) || \
    defined(_18F23K20)  || defined(_18F24K20)  || defined(_18F25K20)  || defined(_18F26K20)

/*
 * For 28Pin PIC(18F2xK20), I2C lcd using.
 */

void keyin_ioinit(void)
{
    /* Initialize IOPORTS*/
    PORTA = 0x00;
    LATA = 0x00;
    ANSEL = 0x01; // Use RA0 AS ADC, Another is not used.
    ANSELH = 0x00; //
    TRISA = TRIS_A_VAL;

    PORTB = 0x00;
    LATB = 0x00;
    TRISB = TRIS_B_VAL;

    PORTC = 0x00;
    LATC = 0x00;
    TRISC = TRIS_C_VAL_O;
//    lcd_backlightinit();
    io_intcountinit();
}
#endif

#if defined(pic18f43k20) || defined(pic18f44k20) || defined(pic18f45k20) || defined(pic18f46k20) || \
    defined(_18F43K20)  || defined(_18F44K20)  || defined(_18F45K20)  || defined(_18F46K20)

/*
 * For 40Pin PIC(18F4xK20), paralell or I2C lcd using.
 */
void keyin_ioinit(void)
{
    /* Initialize IOPORTS*/
    PORTA = 0x00;
    LATA = 0x00;
    ANSEL = 0x80; // Use RA7 AS ADC, Another is not used.
    ANSELH = 0x00; //
    TRISA = TRIS_A_VAL;

    PORTB = 0x00;
    LATB = 0x00;
    TRISB = TRIS_B_VAL;

    PORTC = 0x00;
    LATC = 0x00;
    TRISC = TRIS_C_VAL_O;

    /*
     * You can use PORTD,RE0-RE2 extention, when using I2C lcd.
     */
    PORTD = 0x00;
    LATD = 0x00;
    TRISD = TRIS_D_VAL;

    TRISE = TRIS_E_VAL;
    PORTE = 0b00000000; // Mute OK

    // Interrupts
    INTCONbits.INT0IE = 0;
    INTCONbits.INT0IF = 0;
    INTCON3bits.INT1IF = 0;
    INTCON3bits.INT2IF = 0;
    INTCON3bits.INT1IE = 0;
    INTCON3bits.INT2IE = 0;

//    lcd_backlightinit();
    io_intcountinit();
}
#else
void keyin_ioinit(void)
{
    /* Initialize IOPORTS*/
    PORTA = 0x00;
    LATA = 0x00;
//    ANSEL = 0x01; // Use RA0 AS ADC, Another is not used.
//    ANSELH = 0x00; //
    TRISA = TRIS_A_VAL;

    PORTB = 0x00;
    LATB = 0x00;
    TRISB = TRIS_B_VAL;

    PORTC = 0x00;
    LATC = 0x00;
    TRISC = TRIS_C_VAL_O;
//    lcd_backlightinit();
    io_intcountinit();
}
#endif

/*
 * Read IOPORTS for KEY. You should modify if you modify circuit.
 */
void readkey_io(unsigned char state)
{
    char i;
    __bitops_t portvar;
 
    switch(state) {
        case 0:
            for(i = 0; i < 2; i++){
                keyin_old[1].byte[i] = keyin_old[0].byte[i];
                keyin_old[0].byte[i] = keyin_now.byte[i];
                keyin_now.byte[i] = 0x00;
            }
            _KEY_SENDPORT |= _KEY_SENDPORTMASK; // Group1 DOWN.
            break;
        case 1:
            _KEY_SEND_GRP1 = 0; // Group1 DOWN.
            break;
        case 2:
            portvar.byte = _KEY_RECVPORT;
            if(!_KEY_POS1MASK(portvar)) {
                keyin_now.BIT0A = 1;
            }
            if(!_KEY_POS2MASK(portvar)) {
                keyin_now.BIT1A = 1;
            }
            if(!_KEY_POS3MASK(portvar)) {
                keyin_now.BIT2A = 1;
            }
            if(!_KEY_POS4MASK(portvar)) {
                keyin_now.BIT3A = 1;
            }
            _KEY_SENDPORT |= _KEY_SENDPORTMASK; // Group1 DOWN.
            break;
        case 3:
            _KEY_SEND_GRP2 = 0; // Group2 DOWN.
            break;
        case 4:
            portvar.byte = _KEY_RECVPORT;
            if(!_KEY_POS1MASK(portvar)) {
                keyin_now.BIT0B = 1;
            }
            if(!_KEY_POS2MASK(portvar)) {
                keyin_now.BIT1B = 1;
            }
            if(!_KEY_POS3MASK(portvar)) {
                keyin_now.BIT2B = 1;
            }
            if(!_KEY_POS4MASK(portvar)) {
                keyin_now.BIT3B = 1;
            }
            _KEY_SENDPORT |= _KEY_SENDPORTMASK; // Group1 DOWN.
            break;
        case 5:
            _KEY_SEND_GRP3 = 0; // Group1 DOWN.
            break;
        case 6:
            portvar.byte = _KEY_RECVPORT;
            if(!_KEY_POS1MASK(portvar)) {
                keyin_now.BIT0C = 1;
            }
            if(!_KEY_POS2MASK(portvar)) {
                keyin_now.BIT1C = 1;
            }
            if(!_KEY_POS3MASK(portvar)) {
                keyin_now.BIT2C = 1;
            }
            if(!_KEY_POS4MASK(portvar)) {
                keyin_now.BIT3C = 1;
            }
            _KEY_SENDPORT |= _KEY_SENDPORTMASK; // Group1 DOWN.
            break;
        case 7:
            _KEY_SEND_GRP4 = 0; // Group4 up
            break;
        case 8:
            portvar.byte = _KEY_RECVPORT;
            if(!_KEY_POS1MASK(portvar)) {
                keyin_now.BIT0D = 1;
            }
            if(!_KEY_POS2MASK(portvar)) {
                keyin_now.BIT1D = 1;
            }
            if(!_KEY_POS3MASK(portvar)) {
                keyin_now.BIT2D = 1;
            }
            if(!_KEY_POS4MASK(portvar)) {
                keyin_now.BIT3D = 1;
            }
            _KEY_SENDPORT |= _KEY_SENDPORTMASK; // Group1 DOWN.
            break;
        default:
            break;
    }
}
