/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.dao;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import open.dolphin.container.Pair;
import open.dolphin.dao.OrcaUnitTranslater;
import open.dolphin.dao.SqlDaoBean;
import open.dolphin.infomodel.AdminEntry;
import open.dolphin.infomodel.DiseaseEntry;
import open.dolphin.infomodel.GenericAdapter;
import open.dolphin.infomodel.InteractEntry;
import open.dolphin.infomodel.MasterEntry;
import open.dolphin.infomodel.MedicineEntry;
import open.dolphin.infomodel.SsKijyoEntry;
import open.dolphin.infomodel.ToolMaterialEntry;
import open.dolphin.infomodel.TreatmentEntry;
import open.dolphin.log.LogWriter;
import open.dolphin.order.ClaimConst;
import open.dolphin.project.GlobalVariables;
import open.dolphin.utils.DateExpire;
import open.dolphin.utils.StringTool;

public final class SqlMasterDao
extends SqlDaoBean {
    private static final String YKZKBN = "4";
    private int totalCount;
    private static final String CODE_FILLER = "ZZZ";
    private static final String PREFIX_CODE1 = "ZZZ1";
    private static final String PREFIX_CODE2 = "ZZZ2";
    private static final String TYPE_CODE1 = "ZZZ3";
    private static final String TYPE_CODE2 = "ZZZ4";
    private static final String PART_CODE = "ZZZ7";
    private static final String POSTFIX_CODE = "ZZZ8";
    private static String SQL_TBL_BYOMEI = "select byomeicd, byomei, byomeikana, syusaiymd, haisiymd, icd10_1 from tbl_byomei where ";

    public SqlMasterDao() {
        if ("040500-1".equals(this.getOrcaDbVersion())) {
            SQL_TBL_BYOMEI = SQL_TBL_BYOMEI.replace("icd10_1", "icd10");
        }
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public String toLongCode(String code) {
        if (code.length() == 4) {
            return CODE_FILLER + code;
        }
        return code;
    }

    public String getSerchClass(String code) {
        String longCode = this.toLongCode(code).substring(0, 4);
        if (longCode.equals(PREFIX_CODE1) || longCode.equals(PREFIX_CODE2)) {
            return ClaimConst.SubTypeSet.PREFIX.getName();
        }
        if (longCode.equals(TYPE_CODE1) || longCode.equals(TYPE_CODE2)) {
            return ClaimConst.SubTypeSet.TYPE.getName();
        }
        if (longCode.equals(PART_CODE)) {
            return ClaimConst.SubTypeSet.PART.getName();
        }
        if (longCode.equals(POSTFIX_CODE)) {
            return ClaimConst.SubTypeSet.POSTFIX.getName();
        }
        return "";
    }

    public List getByName(String master, String name, boolean startsWith, String serchClassCode, String sortBy, String order) {
        List<MasterEntry> results = null;
        if (master.equals(ClaimConst.MasterSet.DIAGNOSIS.getName())) {
            if (serchClassCode.equals("")) {
                results = StringTool.isAllDigit(name) ? this.getDiseaseByCode(name, startsWith, sortBy, order) : this.getDiseaseByName(name, startsWith, sortBy, order);
            } else if (serchClassCode.equals(ClaimConst.SubTypeSet.NAMES.getName())) {
                results = this.getDiseaseListNames(name);
            } else if (serchClassCode.equals(ClaimConst.SubTypeSet.PREFIX.getName())) {
                results = this.getDiseasePrefixFromOrca(name, sortBy);
            } else if (serchClassCode.equals(ClaimConst.SubTypeSet.TYPE.getName())) {
                results = this.getDiseaseTypeFromOrca(name, sortBy);
            } else if (serchClassCode.equals(ClaimConst.SubTypeSet.PART.getName())) {
                results = this.getDiseasePartFromOrca(name, sortBy);
            } else if (serchClassCode.equals(ClaimConst.SubTypeSet.POSTFIX.getName())) {
                results = this.getDiseasePostfixFromOrca(name, sortBy);
            }
        } else if (master.equals(ClaimConst.MasterSet.MEDICAL_SUPPLY.getName())) {
            if (serchClassCode.equals("20")) {
                results = this.getMedicineByName(name, startsWith, sortBy, order);
            } else if (serchClassCode.equals("40")) {
                results = this.getInjectionByName(name, startsWith, sortBy, order);
            }
        } else if (master.equals(ClaimConst.MasterSet.TREATMENT.getName())) {
            results = this.getTreatmentByName(name, startsWith, serchClassCode, sortBy, order);
        } else if (master.equals(ClaimConst.MasterSet.TOOL_MATERIAL.getName())) {
            results = this.getToolMaterialByName(name, startsWith, sortBy, order);
        } else if (master.equals(ClaimConst.MasterSet.ADMINISTRATION.getName())) {
            results = this.getAdminByName(name, startsWith, sortBy, order);
        } else {
            throw new RuntimeException("Unsupported master: " + master);
        }
        return results;
    }

    private List<DiseaseEntry> getDiseaseByName(String text, boolean startsWith, String sortBy, String order) {
        ArrayList<String> result = this.UserByoumeiToCodes(text);
        List<DiseaseEntry> ret = null;
        String sql = null;
        if (!startsWith) {
            sql = this.buildDiseaseListSqlFromOrca("byomei ~ ", result, sortBy, order, true);
            ret = this.getDiseaseCollection(sql);
        }
        if (this.isNoError() && (ret == null || ret.isEmpty())) {
            sql = this.buildDiseaseListSqlFromOrca("byomei ~ ", result, sortBy, order, false);
            ret = this.getDiseaseCollection(sql);
        }
        return ret;
    }

    private List<DiseaseEntry> getDiseaseByCode(String text, boolean startsWith, String sortBy, String order) {
        ArrayList<String> result = this.UserByoumeiToCodes(text);
        List<DiseaseEntry> ret = null;
        String sql = null;
        if (!startsWith) {
            sql = this.buildDiseaseListSqlFromOrca("byomeicd ~ ", result, sortBy, order, true);
            ret = this.getDiseaseCollection(sql);
        }
        if (this.isNoError() && (ret == null || ret.isEmpty())) {
            sql = this.buildDiseaseListSqlFromOrca("byomeicd ~ ", result, sortBy, order, true);
            ret = this.getDiseaseCollection(sql);
        }
        return ret;
    }

    private List<DiseaseEntry> getDiseaseNames(String text) {
        int end_index;
        String r = this.UserByoumeiToCode(text);
        ArrayList<DiseaseEntry> result = new ArrayList<DiseaseEntry>();
        String key = r;
        ArrayList<String> keyList = new ArrayList<String>();
        int start_index = 0;
        while (key.length() != 0 && (end_index = this.matchMostLongKeywordFromOrca(key)) != 0) {
            keyList.add(key.substring(start_index, end_index));
            key = key.substring(end_index, key.length());
        }
        for (String _key : keyList) {
            List<DiseaseEntry> diseases = this.getDiseaseNameFromOrca(_key);
            result.addAll(diseases);
        }
        return result;
    }

    private List<DiseaseEntry> getDiseaseListNames(String text) {
        int i = 0;
        boolean start = true;
        ArrayList<String> r = this.UserByoumeiToCodes(text);
        ArrayList<DiseaseEntry> result = new ArrayList<DiseaseEntry>();
        ArrayList<String> keyList = new ArrayList<String>();
        for (i = 0; i < r.size(); ++i) {
            int end_index;
            String key = r.get(i);
            int start_index = 0;
            while (key.length() != 0 && (end_index = this.matchMostLongKeywordFromOrca(key)) != 0) {
                keyList.add(key.substring(start_index, end_index));
                key = key.substring(end_index, key.length());
            }
            for (String _key : keyList) {
                List<DiseaseEntry> diseases = this.getDiseaseNameFromOrca(_key);
                result.addAll(diseases);
            }
            keyList.clear();
        }
        return result;
    }

    private int matchMostLongKeywordFromOrca(String text) {
        int index;
        List<DiseaseEntry> result = null;
        for (index = 0; index < text.length(); ++index) {
            String key = text.substring(0, index + 1);
            result = this.getDiseaseCollection(SQL_TBL_BYOMEI + "byomei ~ '^" + key + "'");
            if (result.isEmpty()) break;
        }
        return index;
    }

    private List<DiseaseEntry> getDiseaseNameFromOrca(String text) {
        StringBuilder buf = new StringBuilder();
        buf.append(SQL_TBL_BYOMEI);
        buf.append("byomei = '" + text + "'");
        return this.getDiseaseCollection(buf.toString());
    }

    public List<DiseaseEntry> getDiseaseCodeFromOrca(String text) {
        StringBuilder buf = new StringBuilder();
        buf.append(SQL_TBL_BYOMEI);
        buf.append("byomeicd = '" + this.toLongCode(text) + "'");
        return this.getDiseaseCollection(buf.toString());
    }

    private List<DiseaseEntry> getDiseasePrefixFromOrca(String text, String sortBy) {
        String order = "";
        if (!StringTool.isEmptyString(sortBy)) {
            order = " order by " + sortBy;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(SQL_TBL_BYOMEI);
        if (StringTool.isEmptyString(text)) {
            buf.append("byomeicd ~ '^ZZZ1' or byomeicd ~ '^ZZZ2'" + order);
        } else {
            buf.append("(byomei ~ '" + text + "') and (byomeicd ~ '^" + PREFIX_CODE1 + "' or byomeicd ~ '^" + PREFIX_CODE2 + "')" + order);
        }
        String query = buf.toString();
        return this.getDiseaseCollection(query);
    }

    private List<DiseaseEntry> getDiseaseTypeFromOrca(String text, String sortBy) {
        String order = "";
        if (!StringTool.isEmptyString(sortBy)) {
            order = " order by " + sortBy;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(SQL_TBL_BYOMEI);
        buf.append("(byomei ~ '" + text + "') and (byomeicd ~ '^" + TYPE_CODE1 + "' or byomeicd ~ '^" + TYPE_CODE2 + "')" + order);
        return this.getDiseaseCollection(buf.toString());
    }

    private List<DiseaseEntry> getDiseasePartFromOrca(String text, String sortBy) {
        String order = "";
        if (!StringTool.isEmptyString(sortBy)) {
            order = " order by " + sortBy;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(SQL_TBL_BYOMEI);
        buf.append("(byomei ~ '" + text + "') and byomeicd ~ '^" + PART_CODE + "'" + order);
        return this.getDiseaseCollection(buf.toString());
    }

    private List<DiseaseEntry> getDiseasePostfixFromOrca(String text, String sortBy) {
        String order = "";
        if (!StringTool.isEmptyString(sortBy)) {
            order = " order by " + sortBy;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(SQL_TBL_BYOMEI);
        buf.append("(byomei ~ '" + text + "') and byomeicd ~ '^" + POSTFIX_CODE + "'" + order);
        return this.getDiseaseCollection(buf.toString());
    }

    private String buildDiseaseSqlFromOrca(String field, String text, String sortBy, String order, boolean forward) {
        String word = null;
        StringBuilder buf = new StringBuilder();
        buf.append(SQL_TBL_BYOMEI);
        word = text;
        buf.append(field);
        if (forward) {
            buf.append(this.addSingleQuote("^" + word));
        } else {
            buf.append(this.addSingleQuote(word));
        }
        String orderBy = this.getOrderBy(sortBy, order);
        if (orderBy == null) {
            orderBy = " order by byomeikana";
        }
        buf.append(orderBy);
        return buf.toString();
    }

    private String buildDiseaseListSqlFromOrca(String field, ArrayList<String> text, String sortBy, String order, boolean forward) {
        int i = 0;
        boolean start = true;
        String word = null;
        StringBuilder buf = new StringBuilder();
        buf.append(SQL_TBL_BYOMEI);
        buf.append(" ( ");
        for (i = 0; i < text.size(); ++i) {
            word = text.get(i);
            if (start) {
                start = false;
            } else {
                buf.append(" or ");
            }
            buf.append(field);
            if (forward) {
                buf.append(this.addSingleQuote("^" + word));
                continue;
            }
            buf.append(this.addSingleQuote(word));
        }
        buf.append(" ) ");
        String orderBy = this.getOrderBy(sortBy, order);
        if (orderBy == null) {
            orderBy = " order by byomeikana";
        }
        buf.append(orderBy);
        return buf.toString();
    }

    private List<DiseaseEntry> getDiseaseCollection(String sql) {
        Connection con = null;
        ArrayList<DiseaseEntry> collection = null;
        ArrayList<DiseaseEntry> outUse = null;
        Statement st = null;
        try {
            con = this.getConnection();
            st = con.createStatement();
            ResultSet rs = st.executeQuery(sql);
            DiseaseEntry de = null;
            collection = new ArrayList<DiseaseEntry>();
            outUse = new ArrayList<DiseaseEntry>();
            while (rs.next()) {
                de = new DiseaseEntry();
                de.setCode(rs.getString(1));
                de.setName(rs.getString(2));
                de.setKana(rs.getString(3));
                de.setIcdTen(rs.getString(4));
                de.setDisUseDate(rs.getString(5));
                if (de.isInUse()) {
                    collection.add(de);
                    continue;
                }
                outUse.add(de);
            }
            rs.close();
            collection.addAll(outUse);
            this.closeStatement(st);
            this.closeConnection(con);
            return collection;
        }
        catch (Exception e) {
            this.processError(e);
            this.closeConnection(con);
            this.closeStatement(st);
            return null;
        }
    }

    public List<MedicineEntry> getMedicineFromOrca(String code) {
        final ArrayList<MedicineEntry> collection = new ArrayList<MedicineEntry>();
        StringBuilder sql = new StringBuilder();
        sql.append("select srycd,name,kananame,tanicd,tensikibetu,ten,ykzkbn,yakkakjncd,yukostymd,yukoedymd from tbl_tensu where ");
        if (GlobalVariables.getOrcaVersion().startsWith(YKZKBN)) {
            int hospnum = this.getHospNum();
            sql.append("hospnum=");
            sql.append(hospnum);
            sql.append(" and ");
        }
        sql.append("srycd = ");
        sql.append(this.addSingleQuote(code));
        this.executeQuery(sql.toString(), null, new GenericAdapter<ResultSet, Object>(){

            @Override
            public boolean onResult(ResultSet records, Object result) throws Exception {
                if (!DateExpire.expire(records.getString(9), records.getString(10))) {
                    MedicineEntry me = new MedicineEntry();
                    me.setCode(records.getString(1));
                    me.setName(records.getString(2));
                    me.setKana(records.getString(3));
                    me.setUnit(OrcaUnitTranslater.toName(records.getString(4)));
                    me.setCostFlag(records.getString(5));
                    me.setCost(records.getString(6));
                    me.setYkzKbn(records.getString(7));
                    me.setJNCD(records.getString(8));
                    me.setStartDate(records.getString(9));
                    me.setEndDate(records.getString(10));
                    collection.add(me);
                }
                return true;
            }

            @Override
            public void onError(Exception ex) {
            }
        });
        return collection;
    }

    public KNSJISKBN IsAutoCulcFromOrca(String code) {
        final ArrayList collection = new ArrayList();
        StringBuilder sql = new StringBuilder();
        sql.append("select KNSJISKBN,yukostymd,yukoedymd from tbl_tensu where ");
        if (GlobalVariables.getOrcaVersion().startsWith(YKZKBN)) {
            int hospnum = this.getHospNum();
            sql.append("hospnum=");
            sql.append(hospnum);
            sql.append(" and ");
        }
        sql.append("srycd = ");
        sql.append(this.addSingleQuote(code));
        this.executeQuery(sql.toString(), null, new GenericAdapter<ResultSet, Object>(){

            @Override
            public boolean onResult(ResultSet records, Object result) throws Exception {
                if (!DateExpire.expire(records.getString(2), records.getString(3))) {
                    switch (records.getInt(1)) {
                        case 0: {
                            collection.add(KNSJISKBN.NORMAL);
                            break;
                        }
                        case 1: {
                            collection.add(KNSJISKBN.KENSA);
                            break;
                        }
                        case 2: {
                            collection.add(KNSJISKBN.AUTO);
                            break;
                        }
                    }
                } else {
                    collection.add(KNSJISKBN.EXPIRE);
                }
                return true;
            }

            @Override
            public void onError(Exception ex) {
            }
        });
        if (!collection.isEmpty()) {
            return (KNSJISKBN)((Object)collection.get(0));
        }
        return KNSJISKBN.NOCODE;
    }

    private List<MedicineEntry> getMedicineByName(String text, boolean startsWith, String sortBy, String order) {
        ArrayList<String> result = this.InputCdToCodes(text);
        String sql = this.getMedicineListSqlFromOrca(result, sortBy, order, startsWith);
        List<MedicineEntry> ret = this.getMedicineCollection(sql);
        return ret;
    }

    private String getMedicineSqlFromOrca(String text, String sortBy, String order, boolean forward) {
        String word = null;
        StringBuilder sql = new StringBuilder();
        sql.append("select srycd,name,kananame,taniname,tensikibetu,ten,ykzkbn,yakkakjncd,yukostymd,yukoedymd from tbl_tensu where ");
        if (GlobalVariables.getOrcaVersion().startsWith(YKZKBN)) {
            int hospnum = this.getHospNum();
            sql.append("hospnum=");
            sql.append(hospnum);
            sql.append(" and ");
        }
        sql.append("srycd ~ '^6' and ");
        if (StringTool.isAllDigit(text)) {
            word = text;
            sql.append("srycd ~ ");
            if (forward) {
                sql.append(this.addSingleQuote("^" + word));
            } else {
                sql.append(this.addSingleQuote(word));
            }
        } else {
            word = text;
            sql.append("(name ~ ");
            if (forward) {
                sql.append(this.addSingleQuote("^" + word));
            } else {
                sql.append(this.addSingleQuote(word));
            }
            sql.append(" or formalname ~ ");
            if (forward) {
                sql.append(this.addSingleQuote("^" + word));
            } else {
                sql.append(this.addSingleQuote(word));
            }
            sql.append(") ");
        }
        sql.append(" and ykzkbn != ");
        sql.append(this.addSingleQuote(YKZKBN));
        String orderBy = this.getOrderBy(sortBy, order);
        if (orderBy == null) {
            orderBy = " order by srycd";
        }
        sql.append(orderBy);
        return sql.toString();
    }

    private String getMedicineListSqlFromOrca(ArrayList<String> text, String sortBy, String order, boolean forward) {
        int i = 0;
        boolean start = true;
        String word = null;
        StringBuilder sql = new StringBuilder();
        sql.append("select srycd,name,kananame,taniname,tensikibetu,ten,ykzkbn,yakkakjncd,yukostymd,yukoedymd from tbl_tensu where ");
        if (GlobalVariables.getOrcaVersion().startsWith(YKZKBN)) {
            int hospnum = this.getHospNum();
            sql.append("hospnum=");
            sql.append(hospnum);
            sql.append(" and ");
        }
        sql.append("srycd ~ '^6' and ");
        sql.append(" ( ");
        for (i = 0; i < text.size(); ++i) {
            if (start) {
                start = false;
            } else {
                sql.append(" or ");
            }
            if (StringTool.isAllDigit(text.get(i))) {
                word = text.get(i);
                sql.append("srycd ~ ");
                if (forward) {
                    sql.append(this.addSingleQuote("^" + word));
                    continue;
                }
                sql.append(this.addSingleQuote(word));
                continue;
            }
            word = text.get(i);
            sql.append("(name ~ ");
            if (forward) {
                sql.append(this.addSingleQuote("^" + word));
            } else {
                sql.append(this.addSingleQuote(word));
            }
            sql.append(" or formalname ~ ");
            if (forward) {
                sql.append(this.addSingleQuote("^" + word));
            } else {
                sql.append(this.addSingleQuote(word));
            }
            sql.append(") ");
        }
        sql.append(" ) ");
        sql.append(" and ykzkbn != ");
        sql.append(this.addSingleQuote(YKZKBN));
        String orderBy = this.getOrderBy(sortBy, order);
        if (orderBy == null) {
            orderBy = " order by srycd";
        }
        sql.append(orderBy);
        return sql.toString();
    }

    private List<MedicineEntry> getMedicineCollection(String sql) {
        Connection con = null;
        ArrayList<MedicineEntry> collection = null;
        ArrayList<MedicineEntry> outUse = null;
        Statement st = null;
        try {
            con = this.getConnection();
            st = con.createStatement();
            ResultSet rs = st.executeQuery(sql);
            MedicineEntry medicine = null;
            collection = new ArrayList<MedicineEntry>();
            outUse = new ArrayList<MedicineEntry>();
            while (rs.next()) {
                medicine = new MedicineEntry();
                medicine.setCode(rs.getString(1));
                medicine.setName(rs.getString(2));
                medicine.setKana(rs.getString(3));
                medicine.setUnit(rs.getString(4));
                medicine.setCostFlag(rs.getString(5));
                medicine.setCost(rs.getString(6));
                medicine.setYkzKbn(rs.getString(7));
                medicine.setJNCD(rs.getString(8));
                medicine.setStartDate(rs.getString(9));
                medicine.setEndDate(rs.getString(10));
                if (medicine.isInUse()) {
                    collection.add(medicine);
                    continue;
                }
                outUse.add(medicine);
            }
            rs.close();
            collection.addAll(outUse);
            this.closeStatement(st);
            this.closeConnection(con);
            return collection;
        }
        catch (Exception e) {
            this.processError(e);
            this.closeStatement(st);
            this.closeConnection(con);
            return null;
        }
    }

    private List<MedicineEntry> getInjectionByName(String text, boolean startsWith, String sortBy, String order) {
        ArrayList<String> result = this.InputCdToCodes(text);
        String sql = this.getInjectionListSqlFromOrca(result, sortBy, order, startsWith);
        List<MedicineEntry> ret = this.getInjectionCollection(sql);
        return ret;
    }

    private String getInjectionSqlFromOrca(String text, String sortBy, String order, boolean forward) {
        String word = null;
        StringBuilder sql = new StringBuilder();
        sql.append("select srycd,name,kananame,taniname,tensikibetu,ten,ykzkbn,yakkakjncd,yukostymd,yukoedymd from tbl_tensu where ");
        if (GlobalVariables.getOrcaVersion().startsWith(YKZKBN)) {
            int hospnum = this.getHospNum();
            sql.append("hospnum=");
            sql.append(hospnum);
            sql.append(" and ");
        }
        sql.append("(srycd ~ ").append(this.addSingleQuote("^09930")).append(" or ");
        sql.append("(srycd ~ '^6' and ykzkbn = ");
        sql.append(this.addSingleQuote(YKZKBN));
        sql.append(")) and ");
        if (StringTool.isAllDigit(text)) {
            word = text;
            sql.append("srycd ~ ");
            if (forward) {
                sql.append(this.addSingleQuote("^" + word));
            } else {
                sql.append(this.addSingleQuote(word));
            }
        } else {
            word = text;
            sql.append("(name ~ ");
            if (forward) {
                sql.append(this.addSingleQuote("^" + word));
            } else {
                sql.append(this.addSingleQuote(word));
            }
            sql.append(" or formalname ~ ");
            if (forward) {
                sql.append(this.addSingleQuote("^" + word));
            } else {
                sql.append(this.addSingleQuote(word));
            }
            sql.append(") ");
        }
        String orderBy = this.getOrderBy(sortBy, order);
        if (orderBy == null) {
            orderBy = " order by srycd";
        }
        sql.append(orderBy);
        return sql.toString();
    }

    private String getInjectionListSqlFromOrca(ArrayList<String> text, String sortBy, String order, boolean forward) {
        int i = 0;
        boolean start = true;
        String word = null;
        StringBuilder sql = new StringBuilder();
        sql.append("select srycd,name,kananame,taniname,tensikibetu,ten,ykzkbn,yakkakjncd,yukostymd,yukoedymd from tbl_tensu where ");
        if (GlobalVariables.getOrcaVersion().startsWith(YKZKBN)) {
            int hospnum = this.getHospNum();
            sql.append("hospnum=");
            sql.append(hospnum);
            sql.append(" and ");
        }
        sql.append("(srycd ~ ").append(this.addSingleQuote("^09930")).append(" or ");
        sql.append("(srycd ~ '^6' and ykzkbn = ");
        sql.append(this.addSingleQuote(YKZKBN));
        sql.append(")) and ");
        sql.append(" ( ");
        for (i = 0; i < text.size(); ++i) {
            if (start) {
                start = false;
            } else {
                sql.append(" or ");
            }
            if (StringTool.isAllDigit(text.get(i))) {
                word = text.get(i);
                sql.append("srycd ~ ");
                if (forward) {
                    sql.append(this.addSingleQuote("^" + word));
                    continue;
                }
                sql.append(this.addSingleQuote(word));
                continue;
            }
            word = text.get(i);
            sql.append("(name ~ ");
            if (forward) {
                sql.append(this.addSingleQuote("^" + word));
            } else {
                sql.append(this.addSingleQuote(word));
            }
            sql.append(" or formalname ~ ");
            if (forward) {
                sql.append(this.addSingleQuote("^" + word));
            } else {
                sql.append(this.addSingleQuote(word));
            }
            sql.append(") ");
        }
        sql.append(" ) ");
        String orderBy = this.getOrderBy(sortBy, order);
        if (orderBy == null) {
            orderBy = " order by srycd";
        }
        sql.append(orderBy);
        return sql.toString();
    }

    private List<MedicineEntry> getInjectionCollection(String sql) {
        Connection con = null;
        ArrayList<MedicineEntry> collection = null;
        ArrayList<MedicineEntry> outUse = null;
        Statement st = null;
        try {
            con = this.getConnection();
            st = con.createStatement();
            ResultSet rs = st.executeQuery(sql);
            MedicineEntry me = null;
            collection = new ArrayList<MedicineEntry>();
            outUse = new ArrayList<MedicineEntry>();
            while (rs.next()) {
                me = new MedicineEntry();
                me.setCode(rs.getString(1));
                me.setName(rs.getString(2));
                me.setKana(rs.getString(3));
                me.setUnit(rs.getString(4));
                me.setCostFlag(rs.getString(5));
                me.setCost(rs.getString(6));
                me.setYkzKbn(rs.getString(7));
                me.setJNCD(rs.getString(8));
                me.setStartDate(rs.getString(9));
                me.setEndDate(rs.getString(10));
                if (me.isInUse()) {
                    collection.add(me);
                    continue;
                }
                outUse.add(me);
            }
            rs.close();
            collection.addAll(outUse);
            this.closeStatement(st);
            this.closeConnection(con);
            return collection;
        }
        catch (Exception e) {
            this.processError(e);
            this.closeStatement(st);
            this.closeConnection(con);
            return null;
        }
    }

    private List<TreatmentEntry> getTreatmentByName(String text, boolean startsWith, String orderClassCode, String sortBy, String order) {
        ArrayList<String> result = this.InputCdToCodes(text);
        String sql = this.getTreatmentListSqlFromOrca(result, orderClassCode, sortBy, order, startsWith);
        List<TreatmentEntry> ret = this.getTreatmentCollection(sql);
        return ret;
    }

    private String getTreatmentSqlFromOrca(String text, String orderClassCode, String sortBy, String order, boolean forward) {
        String word = null;
        StringBuilder buf = new StringBuilder();
        buf.append("select srycd,name,formalname,tensikibetu,ten,nyugaitekkbn,routekkbn,srysyukbn,hospsrykbn,yukostymd,yukoedymd ");
        buf.append(" ,sstkijuncd1,sstkijuncd2,sstkijuncd3,sstkijuncd4,sstkijuncd5,sstkijuncd6,sstkijuncd7,sstkijuncd8,sstkijuncd9,sstkijuncd10 ");
        buf.append(" from tbl_tensu where ");
        if (GlobalVariables.getOrcaVersion().startsWith(YKZKBN)) {
            int hospnum = this.getHospNum();
            buf.append("hospnum=");
            buf.append(hospnum);
            buf.append(" and ");
        }
        buf.append("( (srycd ~ '^095') or ");
        buf.append("(srycd ~ '^096') or ");
        buf.append("(srycd ~ '^0082') or ");
        buf.append("(srycd ~ '^0083') or ");
        buf.append("(srycd ~ '^0084') or ");
        buf.append("(srycd ~ '^0085') or ");
        buf.append("(srycd ~ '^810000001') or ");
        buf.append("(srycd ~ '^82') or ");
        buf.append("(srycd ~ '^83') or ");
        buf.append("(srycd ~ '^84') or ");
        buf.append("(srycd ~ '^85') or ");
        buf.append("(srycd ~ '^099') or ");
        buf.append("(srycd ~ '^1' or srycd ~ '^00' ");
        StringBuilder sbd = new StringBuilder();
        if (orderClassCode != null) {
            String[] cClass = new String[]{"", ""};
            int index = 0;
            StringTokenizer tokenizer = new StringTokenizer(orderClassCode, "-");
            while (tokenizer.hasMoreTokens()) {
                cClass[index++] = tokenizer.nextToken();
            }
            String min = cClass[0];
            String max = cClass[1];
            if (!min.equals("") && max.equals("")) {
                sbd.append(" and srysyukbn = ");
                sbd.append(this.addSingleQuote(min));
            } else if (!min.equals("") && !max.equals("")) {
                sbd.append(" and srysyukbn >= ");
                sbd.append(this.addSingleQuote(min));
                sbd.append(" and srysyukbn <= ");
                sbd.append(this.addSingleQuote(max));
            }
        }
        String sql2 = sbd.toString();
        buf.append(sql2);
        buf.append(" ) ) and ");
        if (StringTool.isAllDigit(text)) {
            word = text;
            buf.append("srycd ~ ");
            if (forward) {
                buf.append(this.addSingleQuote("^" + word));
            } else {
                buf.append(this.addSingleQuote(word));
            }
        } else {
            word = text;
            buf.append("(name ~ ");
            if (forward) {
                buf.append(this.addSingleQuote("^" + word));
            } else {
                buf.append(this.addSingleQuote(word));
            }
            buf.append(" or formalname ~ ");
            if (forward) {
                buf.append(this.addSingleQuote("^" + word));
            } else {
                buf.append(this.addSingleQuote(word));
            }
            buf.append(") ");
        }
        String orderBy = this.getOrderBy(sortBy, order);
        if (orderBy == null) {
            orderBy = " order by srycd";
        }
        buf.append(orderBy);
        String sql = buf.toString();
        return sql;
    }

    private String getTreatmentListSqlFromOrca(ArrayList<String> text, String orderClassCode, String sortBy, String order, boolean forward) {
        int i = 0;
        boolean start = true;
        String word = null;
        StringBuilder buf = new StringBuilder();
        buf.append("select srycd,name,formalname,tensikibetu,ten,nyugaitekkbn,routekkbn,srysyukbn,hospsrykbn,yukostymd,yukoedymd ");
        buf.append(" ,sstkijuncd1,sstkijuncd2,sstkijuncd3,sstkijuncd4,sstkijuncd5,sstkijuncd6,sstkijuncd7,sstkijuncd8,sstkijuncd9,sstkijuncd10 ");
        buf.append(" from tbl_tensu where ");
        if (GlobalVariables.getOrcaVersion().startsWith(YKZKBN)) {
            int hospnum = this.getHospNum();
            buf.append("hospnum=");
            buf.append(hospnum);
            buf.append(" and ");
        }
        buf.append("( (srycd ~ '^095') or ");
        buf.append("(srycd ~ '^096') or ");
        buf.append("(srycd ~ '^0082') or ");
        buf.append("(srycd ~ '^0083') or ");
        buf.append("(srycd ~ '^0084') or ");
        buf.append("(srycd ~ '^0085') or ");
        buf.append("(srycd ~ '^810000001') or ");
        buf.append("(srycd ~ '^82') or ");
        buf.append("(srycd ~ '^83') or ");
        buf.append("(srycd ~ '^84') or ");
        buf.append("(srycd ~ '^85') or ");
        buf.append("(srycd ~ '^099') or ");
        buf.append("(srycd ~ '^1' or srycd ~ '^00' ");
        StringBuilder sbd = new StringBuilder();
        if (orderClassCode != null) {
            String[] cClass = new String[]{"", ""};
            int index = 0;
            StringTokenizer tokenizer = new StringTokenizer(orderClassCode, "-");
            while (tokenizer.hasMoreTokens()) {
                cClass[index++] = tokenizer.nextToken();
            }
            String min = cClass[0];
            String max = cClass[1];
            if (!min.equals("") && max.equals("")) {
                sbd.append(" and srysyukbn = ");
                sbd.append(this.addSingleQuote(min));
            } else if (!min.equals("") && !max.equals("")) {
                sbd.append(" and srysyukbn >= ");
                sbd.append(this.addSingleQuote(min));
                sbd.append(" and srysyukbn <= ");
                sbd.append(this.addSingleQuote(max));
            }
        }
        String sql2 = sbd.toString();
        buf.append(sql2);
        buf.append(" ) ) and ");
        buf.append(" ( ");
        for (i = 0; i < text.size(); ++i) {
            if (start) {
                start = false;
            } else {
                buf.append(" or ");
            }
            if (StringTool.isAllDigit(text.get(i))) {
                word = text.get(i);
                buf.append("srycd ~ ");
                if (forward) {
                    buf.append(this.addSingleQuote("^" + word));
                    continue;
                }
                buf.append(this.addSingleQuote(word));
                continue;
            }
            word = text.get(i);
            buf.append("(name ~ ");
            if (forward) {
                buf.append(this.addSingleQuote("^" + word));
            } else {
                buf.append(this.addSingleQuote(word));
            }
            buf.append(" or formalname ~ ");
            if (forward) {
                buf.append(this.addSingleQuote("^" + word));
            } else {
                buf.append(this.addSingleQuote(word));
            }
            buf.append(") ");
        }
        buf.append(" ) ");
        String orderBy = this.getOrderBy(sortBy, order);
        if (orderBy == null) {
            orderBy = " order by srycd";
        }
        buf.append(orderBy);
        String sql = buf.toString();
        return sql;
    }

    private List<TreatmentEntry> getTreatmentCollection(String sql) {
        Connection con = null;
        ArrayList<TreatmentEntry> collection = null;
        ArrayList<TreatmentEntry> outUse = null;
        Statement st = null;
        try {
            con = this.getConnection();
            st = con.createStatement();
            ResultSet rs = st.executeQuery(sql);
            TreatmentEntry te = null;
            collection = new ArrayList<TreatmentEntry>();
            outUse = new ArrayList<TreatmentEntry>();
            while (rs.next()) {
                te = new TreatmentEntry();
                te.setCode(rs.getString(1));
                te.setName(rs.getString(2));
                te.setKana(rs.getString(3));
                te.setCostFlag(rs.getString(4));
                te.setCost(rs.getString(5));
                te.setInOutFlag(rs.getString(6));
                te.setOldFlag(rs.getString(7));
                te.setClaimClassCode(rs.getString(8));
                te.setHospitalClinicFlag(rs.getString(9));
                te.setStartDate(rs.getString(10));
                te.setEndDate(rs.getString(11));
                ArrayList<String> ary = new ArrayList<String>();
                for (int i = 0; i < 10; ++i) {
                    ary.add(rs.getString(i + 12));
                }
                te.setSstKijunCdSet(ary);
                if (te.isInUse()) {
                    collection.add(te);
                    continue;
                }
                outUse.add(te);
            }
            rs.close();
            collection.addAll(outUse);
            this.closeStatement(st);
            this.closeConnection(con);
            return collection;
        }
        catch (Exception e) {
            this.processError(e);
            this.closeStatement(st);
            this.closeConnection(con);
            return null;
        }
    }

    public List<TreatmentEntry> getByClaimClassFromOrca(String master, String claimClass, String sortBy, String order) {
        Connection con = null;
        ArrayList<TreatmentEntry> collection = null;
        ArrayList<TreatmentEntry> outUse = null;
        Statement st = null;
        String[] cClass = new String[]{"", ""};
        int index = 0;
        StringTokenizer tokenizer = new StringTokenizer(claimClass, "-");
        while (tokenizer.hasMoreTokens()) {
            cClass[index++] = tokenizer.nextToken();
        }
        String min = cClass[0];
        String max = cClass[1];
        StringBuilder buf = new StringBuilder();
        buf.append("select srycd,name,formalname,tensikibetu,ten,nyugaitekkbn,routekkbn,srysyukbn,hospsrykbn,yukostymd,yukoedymd ");
        buf.append(" ,sstkijuncd1,sstkijuncd2,sstkijuncd3,sstkijuncd4,sstkijuncd5,sstkijuncd6,sstkijuncd7,sstkijuncd8,sstkijuncd9,sstkijuncd10 ");
        buf.append(" from tbl_tensu where ");
        if (GlobalVariables.getOrcaVersion().startsWith(YKZKBN)) {
            int hospnum = this.getHospNum();
            buf.append("hospnum=");
            buf.append(hospnum);
            buf.append(" and ");
        }
        buf.append("(srycd ~ '^095') or ");
        buf.append("(srycd ~ '^096') or ");
        buf.append("(srycd ~ '^0082') or ");
        buf.append("(srycd ~ '^0083') or ");
        buf.append("(srycd ~ '^0084') or ");
        buf.append("(srycd ~ '^0085') or ");
        buf.append("(srycd ~ '^810000001') or ");
        buf.append("(srycd ~ '^82') or ");
        buf.append("(srycd ~ '^83') or ");
        buf.append("(srycd ~ '^84') or ");
        buf.append("(srycd ~ '^85') or ");
        buf.append("(srycd ~ '^09930') or ");
        buf.append("(srycd ~ '^1' ");
        if (!min.equals("") && max.equals("")) {
            buf.append(" and srysyukbn = ");
            buf.append(this.addSingleQuote(min));
        } else if (!min.equals("") && !max.equals("")) {
            buf.append(" and srysyukbn >= ");
            buf.append(this.addSingleQuote(min));
            buf.append(" and srysyukbn <= ");
            buf.append(this.addSingleQuote(max));
        }
        buf.append(" ) ");
        String orderBy = this.getOrderBy(sortBy, order);
        if (orderBy != null) {
            buf.append(orderBy);
        } else {
            buf.append(" order by srycd");
        }
        String sql = buf.toString();
        try {
            con = this.getConnection();
            st = con.createStatement();
            ResultSet rs = st.executeQuery(sql);
            TreatmentEntry te = null;
            collection = new ArrayList<TreatmentEntry>();
            outUse = new ArrayList<TreatmentEntry>();
            while (rs.next()) {
                te = new TreatmentEntry();
                te.setCode(rs.getString(1));
                te.setName(rs.getString(2));
                te.setKana(rs.getString(3));
                te.setCostFlag(rs.getString(4));
                te.setCost(rs.getString(5));
                te.setInOutFlag(rs.getString(6));
                te.setOldFlag(rs.getString(7));
                te.setClaimClassCode(rs.getString(8));
                te.setHospitalClinicFlag(rs.getString(9));
                te.setStartDate(rs.getString(10));
                te.setEndDate(rs.getString(11));
                ArrayList<String> ary = new ArrayList<String>();
                for (int i = 0; i < 10; ++i) {
                    ary.add(rs.getString(i + 12));
                }
                te.setSstKijunCdSet(ary);
                if (te.isInUse()) {
                    collection.add(te);
                    continue;
                }
                outUse.add(te);
            }
            rs.close();
            collection.addAll(outUse);
            this.closeStatement(st);
            this.closeConnection(con);
            return collection;
        }
        catch (Exception e) {
            this.processError(e);
            this.closeStatement(st);
            this.closeConnection(con);
            return null;
        }
    }

    public List<TreatmentEntry> getRadLocationFromOrca(String master, String sortBy, String order) {
        Connection con = null;
        ArrayList<TreatmentEntry> collection = null;
        ArrayList<TreatmentEntry> outUse = null;
        Statement st = null;
        StringBuilder buf = new StringBuilder();
        buf.append("select srycd,name,kananame,srysyukbn,yukostymd,yukoedymd from tbl_tensu where ");
        if (GlobalVariables.getOrcaVersion().startsWith(YKZKBN)) {
            int hospnum = this.getHospNum();
            buf.append("hospnum=");
            buf.append(hospnum);
            buf.append(" and ");
        }
        buf.append("srycd ~ '^002'");
        String orderBy = this.getOrderBy(sortBy, order);
        if (orderBy != null) {
            buf.append(orderBy);
        } else {
            buf.append(" order by srycd");
        }
        String sql = buf.toString();
        try {
            con = this.getConnection();
            st = con.createStatement();
            ResultSet rs = st.executeQuery(sql);
            TreatmentEntry te = null;
            collection = new ArrayList<TreatmentEntry>();
            outUse = new ArrayList<TreatmentEntry>();
            while (rs.next()) {
                te = new TreatmentEntry();
                te.setCode(rs.getString(1));
                te.setName(rs.getString(2));
                te.setKana(rs.getString(3));
                te.setClaimClassCode(rs.getString(4));
                te.setStartDate(rs.getString(5));
                te.setEndDate(rs.getString(6));
                if (te.isInUse()) {
                    collection.add(te);
                    continue;
                }
                outUse.add(te);
            }
            rs.close();
            collection.addAll(outUse);
            this.closeStatement(st);
            this.closeConnection(con);
            return collection;
        }
        catch (Exception e) {
            this.processError(e);
            this.closeStatement(st);
            this.closeConnection(con);
            return null;
        }
    }

    private List<ToolMaterialEntry> getToolMaterialByName(String text, boolean startsWith, String sortBy, String order) {
        ArrayList<String> result = this.InputCdToCodes(text);
        String sql = this.getToolMaterialListSqlFromOrca(result, sortBy, order, startsWith);
        List<ToolMaterialEntry> ret = this.getToolMaterialCollection(sql);
        return ret;
    }

    private String getToolMaterialSqlFromOrca(String text, String sortBy, String order, boolean forward) {
        String word = null;
        StringBuilder buf = new StringBuilder();
        buf.append("select srycd,name,kananame,taniname,tensikibetu,ten,yukostymd,yukoedymd,idokanren from tbl_tensu where ");
        if (GlobalVariables.getOrcaVersion().startsWith(YKZKBN)) {
            int hospnum = this.getHospNum();
            buf.append("hospnum=");
            buf.append(hospnum);
            buf.append(" and ");
        }
        buf.append("(srycd ~ '^7' or srycd ~ '^058' or srycd ~ '^059') and ");
        if (StringTool.isAllDigit(text)) {
            word = text;
            buf.append("srycd ~ ");
            if (forward) {
                buf.append(this.addSingleQuote("^" + word));
            } else {
                buf.append(this.addSingleQuote(word));
            }
        } else {
            word = text;
            buf.append("(name ~ ");
            if (forward) {
                buf.append(this.addSingleQuote("^" + word));
            } else {
                buf.append(this.addSingleQuote(word));
            }
            buf.append(" or formalname ~ ");
            if (forward) {
                buf.append(this.addSingleQuote("^" + word));
            } else {
                buf.append(this.addSingleQuote(word));
            }
            buf.append(") ");
        }
        String orderBy = this.getOrderBy(sortBy, order);
        if (orderBy == null) {
            orderBy = " order by srycd";
        }
        buf.append(orderBy);
        String sql = buf.toString();
        return sql;
    }

    private String getToolMaterialListSqlFromOrca(ArrayList<String> text, String sortBy, String order, boolean forward) {
        int i = 0;
        boolean start = true;
        String word = null;
        StringBuilder buf = new StringBuilder();
        buf.append("select srycd,name,kananame,taniname,tensikibetu,ten,yukostymd,yukoedymd,idokanren from tbl_tensu where ");
        if (GlobalVariables.getOrcaVersion().startsWith(YKZKBN)) {
            int hospnum = this.getHospNum();
            buf.append("hospnum=");
            buf.append(hospnum);
            buf.append(" and ");
        }
        buf.append("(srycd ~ '^7' or srycd ~ '^058' or srycd ~ '^059') and ");
        buf.append(" ( ");
        for (i = 0; i < text.size(); ++i) {
            if (start) {
                start = false;
            } else {
                buf.append(" or ");
            }
            if (StringTool.isAllDigit(text.get(i))) {
                word = text.get(i);
                buf.append("srycd ~ ");
                if (forward) {
                    buf.append(this.addSingleQuote("^" + word));
                    continue;
                }
                buf.append(this.addSingleQuote(word));
                continue;
            }
            word = text.get(i);
            buf.append("(name ~ ");
            if (forward) {
                buf.append(this.addSingleQuote("^" + word));
            } else {
                buf.append(this.addSingleQuote(word));
            }
            buf.append(" or formalname ~ ");
            if (forward) {
                buf.append(this.addSingleQuote("^" + word));
            } else {
                buf.append(this.addSingleQuote(word));
            }
            buf.append(") ");
        }
        buf.append(" ) ");
        String orderBy = this.getOrderBy(sortBy, order);
        if (orderBy == null) {
            orderBy = " order by srycd";
        }
        buf.append(orderBy);
        String sql = buf.toString();
        return sql;
    }

    private List<ToolMaterialEntry> getToolMaterialCollection(String sql) {
        Connection con = null;
        ArrayList<ToolMaterialEntry> collection = null;
        ArrayList<ToolMaterialEntry> outUse = null;
        Statement st = null;
        try {
            con = this.getConnection();
            st = con.createStatement();
            ResultSet rs = st.executeQuery(sql);
            ToolMaterialEntry te = null;
            collection = new ArrayList<ToolMaterialEntry>();
            outUse = new ArrayList<ToolMaterialEntry>();
            while (rs.next()) {
                te = new ToolMaterialEntry();
                te.setCode(rs.getString(1));
                te.setName(rs.getString(2));
                te.setKana(rs.getString(3));
                te.setUnit(rs.getString(4));
                te.setCostFlag(rs.getString(5));
                te.setCost(rs.getString(6));
                te.setStartDate(rs.getString(7));
                te.setEndDate(rs.getString(8));
                te.setRequiredMaterialCode(rs.getString(9));
                if (te.isInUse()) {
                    collection.add(te);
                    continue;
                }
                outUse.add(te);
            }
            rs.close();
            collection.addAll(outUse);
            this.closeStatement(st);
            this.closeConnection(con);
            return collection;
        }
        catch (Exception e) {
            this.processError(e);
            this.closeStatement(st);
            this.closeConnection(con);
            return null;
        }
    }

    public List<ToolMaterialEntry> getToolMaterialByCodeFromOrca(String code) {
        final ArrayList<ToolMaterialEntry> collection = new ArrayList<ToolMaterialEntry>();
        StringBuilder buf = new StringBuilder();
        buf.append("select srycd,name,kananame,tanicd,tensikibetu,ten,ykzkbn,yakkakjncd,yukostymd,yukoedymd from tbl_tensu where ");
        if (GlobalVariables.getOrcaVersion().startsWith(YKZKBN)) {
            int hospnum = this.getHospNum();
            buf.append("hospnum=");
            buf.append(hospnum);
            buf.append(" and ");
        }
        buf.append("srycd = ");
        buf.append(this.addSingleQuote(code));
        String sql = buf.toString();
        this.executeQuery(sql, null, new GenericAdapter<ResultSet, Object>(){

            @Override
            public boolean onResult(ResultSet records, Object result) throws Exception {
                if (!DateExpire.expire(records.getString(9), records.getString(10))) {
                    ToolMaterialEntry me = new ToolMaterialEntry();
                    me.setCode(records.getString(1));
                    me.setName(records.getString(2));
                    me.setKana(records.getString(3));
                    me.setUnit(OrcaUnitTranslater.toName(records.getString(4)));
                    me.setCostFlag(records.getString(5));
                    me.setCost(records.getString(6));
                    me.setStartDate(records.getString(9));
                    me.setEndDate(records.getString(10));
                    collection.add(me);
                }
                return true;
            }

            @Override
            public void onError(Exception ex) {
            }
        });
        return collection;
    }

    private List<AdminEntry> getAdminByName(String text, boolean startsWith, String sortBy, String order) {
        ArrayList<String> result = this.InputCdToCodes(text);
        String sql = this.getAdminByNameListSqlFromOrca(result, sortBy, order, startsWith);
        List<AdminEntry> ret = this.getAdminCollection(sql);
        return ret;
    }

    private String getAdminByNameSqlFromOrca(String text, String sortBy, String order, boolean forward) {
        String word = null;
        StringBuilder buf = new StringBuilder();
        buf.append("select srycd, name ");
        buf.append(" ,sstkijuncd1,sstkijuncd2,sstkijuncd3,sstkijuncd4,sstkijuncd5,sstkijuncd6,sstkijuncd7,sstkijuncd8,sstkijuncd9,sstkijuncd10 ");
        buf.append(" from tbl_tensu where ");
        if (GlobalVariables.getOrcaVersion().startsWith(YKZKBN)) {
            int hospnum = this.getHospNum();
            buf.append("hospnum=");
            buf.append(hospnum);
            buf.append(" and ");
        }
        buf.append(" ( ");
        buf.append("srycd ~ '^001' or ");
        buf.append("srycd ~ '^810000001$' or ");
        buf.append("srycd ~ '^0082' or srycd ~ '^82' or ");
        buf.append("srycd ~ '^0083' or srycd ~ '^83' or ");
        buf.append("srycd ~ '^0084' or srycd ~ '^84' or ");
        buf.append("srycd ~ '^0085' or srycd ~ '^85' ");
        buf.append(" ) and ");
        if (StringTool.isAllDigit(text)) {
            word = text;
            buf.append("srycd ~ ");
            if (forward) {
                buf.append(this.addSingleQuote("^" + word));
            } else {
                buf.append(this.addSingleQuote(word));
            }
        } else {
            word = text;
            buf.append("(name ~ ");
            if (forward) {
                buf.append(this.addSingleQuote("^" + word));
            } else {
                buf.append(this.addSingleQuote(word));
            }
            buf.append(" or formalname ~ ");
            if (forward) {
                buf.append(this.addSingleQuote("^" + word));
            } else {
                buf.append(this.addSingleQuote(word));
            }
            buf.append(") ");
        }
        String orderBy = this.getOrderBy(sortBy, order);
        if (orderBy == null) {
            orderBy = " order by srycd";
        }
        buf.append(orderBy);
        String sql = buf.toString();
        return sql;
    }

    private String getAdminByNameListSqlFromOrca(ArrayList<String> text, String sortBy, String order, boolean forward) {
        int i = 0;
        boolean start = true;
        String word = null;
        StringBuilder buf = new StringBuilder();
        buf.append("select srycd, name ");
        buf.append(" ,sstkijuncd1,sstkijuncd2,sstkijuncd3,sstkijuncd4,sstkijuncd5,sstkijuncd6,sstkijuncd7,sstkijuncd8,sstkijuncd9,sstkijuncd10 ");
        buf.append(" from tbl_tensu where ");
        if (GlobalVariables.getOrcaVersion().startsWith(YKZKBN)) {
            int hospnum = this.getHospNum();
            buf.append("hospnum=");
            buf.append(hospnum);
            buf.append(" and ");
        }
        buf.append(" ( ");
        buf.append("srycd ~ '^001' or ");
        buf.append("srycd ~ '^810000001$' or ");
        buf.append("srycd ~ '^0082' or srycd ~ '^82' or ");
        buf.append("srycd ~ '^0083' or srycd ~ '^83' or ");
        buf.append("srycd ~ '^0084' or srycd ~ '^84' or ");
        buf.append("srycd ~ '^0085' or srycd ~ '^85' ");
        buf.append(" ) and ");
        buf.append(" ( ");
        for (i = 0; i < text.size(); ++i) {
            if (start) {
                start = false;
            } else {
                buf.append(" or ");
            }
            if (StringTool.isAllDigit(text.get(i))) {
                word = text.get(i);
                buf.append("srycd ~ ");
                if (forward) {
                    buf.append(this.addSingleQuote("^" + word));
                    continue;
                }
                buf.append(this.addSingleQuote(word));
                continue;
            }
            word = text.get(i);
            buf.append("(name ~ ");
            if (forward) {
                buf.append(this.addSingleQuote("^" + word));
            } else {
                buf.append(this.addSingleQuote(word));
            }
            buf.append(" or formalname ~ ");
            if (forward) {
                buf.append(this.addSingleQuote("^" + word));
            } else {
                buf.append(this.addSingleQuote(word));
            }
            buf.append(") ");
        }
        buf.append(" ) ");
        String orderBy = this.getOrderBy(sortBy, order);
        if (orderBy == null) {
            orderBy = " order by srycd";
        }
        buf.append(orderBy);
        String sql = buf.toString();
        return sql;
    }

    private List<AdminEntry> getAdminCollection(String sql) {
        Connection con = null;
        ArrayList<AdminEntry> collection = null;
        Statement st = null;
        try {
            con = this.getConnection();
            st = con.createStatement();
            ResultSet rs = st.executeQuery(sql);
            AdminEntry te = null;
            collection = new ArrayList<AdminEntry>();
            while (rs.next()) {
                te = new AdminEntry();
                te.setCode(rs.getString(1));
                te.setName(rs.getString(2));
                ArrayList<String> ary = new ArrayList<String>();
                for (int i = 0; i < 10; ++i) {
                    ary.add(rs.getString(i + 3));
                }
                te.setSstKijunCdSet(ary);
                collection.add(te);
            }
            rs.close();
            this.closeStatement(st);
            this.closeConnection(con);
            return collection;
        }
        catch (Exception e) {
            this.processError(e);
            this.closeStatement(st);
            this.closeConnection(con);
            return null;
        }
    }

    public List<AdminEntry> getAdminByCategoryFromOrca(String category) {
        Connection con = null;
        ArrayList<AdminEntry> collection = null;
        Statement st = null;
        StringBuilder sql = new StringBuilder();
        sql.append("select srycd, name ");
        sql.append(" ,sstkijuncd1,sstkijuncd2,sstkijuncd3,sstkijuncd4,sstkijuncd5,sstkijuncd6,sstkijuncd7,sstkijuncd8,sstkijuncd9,sstkijuncd10 ");
        sql.append(" from tbl_tensu where ");
        if (GlobalVariables.getOrcaVersion().startsWith(YKZKBN)) {
            int hospnum = this.getHospNum();
            sql.append("hospnum=");
            sql.append(hospnum);
            sql.append(" and ");
        }
        sql.append(" ( srycd ~ '^");
        int index = category.indexOf(32);
        if (index > 0) {
            String s1 = category.substring(0, index);
            String s2 = category.substring(index + 1);
            sql.append(s1);
            sql.append("' or srycd ~ '^");
            sql.append(s2);
            sql.append("'");
        } else {
            sql.append(category);
            sql.append("'");
        }
        sql.append(" or ");
        sql.append("srycd ~ '^810000001$' or ");
        sql.append("srycd ~ '^0082' or srycd ~'^82' or ");
        sql.append("srycd ~ '^0083' or srycd ~'^83' or ");
        sql.append("srycd ~ '^0084' or srycd ~'^84')");
        sql.append(" order by srycd");
        try {
            con = this.getConnection();
            st = con.createStatement();
            ResultSet rs = st.executeQuery(sql.toString());
            AdminEntry te = null;
            collection = new ArrayList<AdminEntry>();
            while (rs.next()) {
                te = new AdminEntry();
                te.setCode(rs.getString(1));
                te.setName(rs.getString(2));
                collection.add(te);
            }
            rs.close();
            this.closeStatement(st);
            this.closeConnection(con);
            return collection;
        }
        catch (Exception e) {
            this.processError(e);
            this.closeStatement(st);
            this.closeConnection(con);
            return null;
        }
    }

    private String getOrderBy(String sortBy, String order) {
        StringBuilder buf = null;
        if (sortBy != null) {
            buf = new StringBuilder();
            buf.append(" order by ");
            buf.append(sortBy);
        }
        if (order != null) {
            buf.append(" ");
            buf.append(order);
        }
        return buf != null ? buf.toString() : null;
    }

    public List<Pair<String, String>> getNameByCodesFromOrca(String code) {
        final ArrayList<Pair<String, String>> collection = new ArrayList<Pair<String, String>>();
        String sql = "select srycd, name from tbl_tensu where srycd = " + this.addSingleQuote(code);
        this.executeQuery(sql, null, new GenericAdapter<ResultSet, Object>(){

            @Override
            public boolean onResult(ResultSet records, Object result) throws Exception {
                collection.add(new Pair<String, String>(records.getString(1), records.getString(2)));
                return true;
            }

            @Override
            public void onError(Exception ex) {
            }
        });
        return collection;
    }

    public String getNameByCode(String code) {
        Pair<String, String> codePair;
        List<Pair<String, String>> codes = this.getNameByCodesFromOrca(code);
        if (!codes.isEmpty() && (codePair = codes.get(0)) != null) {
            return (String)codePair.value;
        }
        return "";
    }

    private List<InteractEntry> getInteractFromOrca(String code) {
        final ArrayList<InteractEntry> collection = new ArrayList<InteractEntry>();
        String sql = "select drugcd, drugcd2, syojyoucd from tbl_interact where drugcd = " + this.addSingleQuote(code);
        this.executeQuery(sql, null, new GenericAdapter<ResultSet, Object>(){

            @Override
            public boolean onResult(ResultSet records, Object result) throws Exception {
                collection.add(new InteractEntry(records.getString(1), records.getString(2), records.getString(3)));
                return true;
            }

            @Override
            public void onError(Exception ex) {
            }
        });
        return collection;
    }

    public List<SsKijyoEntry> getSsKijyoFromOrca(String code) {
        final ArrayList<SsKijyoEntry> collection = new ArrayList<SsKijyoEntry>();
        String sql = "select syojyoucd, syojyou, sayokijyo from tbl_sskijyo where syojyoucd = " + this.addSingleQuote(code);
        this.executeQuery(sql, null, new GenericAdapter<ResultSet, Object>(){

            @Override
            public boolean onResult(ResultSet records, Object result) throws Exception {
                collection.add(new SsKijyoEntry(records.getString(1), records.getString(2), records.getString(3)));
                return true;
            }

            @Override
            public void onError(Exception ex) {
            }
        });
        return collection;
    }

    public void getSsKijyoEntry(String interact_code, List<String> onKarteCode, List<Pair<InteractEntry, SsKijyoEntry>> symptoms) {
        List<InteractEntry> interactsFrom = this.getInteractFromOrca(interact_code);
        for (InteractEntry interact : interactsFrom) {
            for (String code : onKarteCode) {
                if (!interact.getPharmaceuticalsCodeTo().equals(code)) continue;
                List<SsKijyoEntry> sskijyos = this.getSsKijyoFromOrca(interact.getSymptomsCode());
                for (SsKijyoEntry sskijyo : sskijyos) {
                    symptoms.add(new Pair<InteractEntry, SsKijyoEntry>(interact, sskijyo));
                }
            }
        }
    }

    public boolean getAlternateEntry(String code, List<MedicineEntry> collection) {
        ArrayList<String> alternateCodes;
        boolean result = false;
        if (!this.getMedicineEntry(code, collection) && this.getUpdatesFromOrca(code, alternateCodes = new ArrayList<String>())) {
            for (String alternateCode : alternateCodes) {
                if (!this.getMedicineEntry(alternateCode, collection)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public boolean getMedicineEntry(String code, final List<MedicineEntry> collection) {
        String sql = "select srycd,name,kananame,tanicd,tensikibetu,ten,ykzkbn,yakkakjncd,yukostymd,yukoedymd from tbl_tensu where srycd= " + this.addSingleQuote(code) + " order by yukoedymd desc offset 0 limit 1";
        Object result = this.executeQuery(sql, null, new GenericAdapter<ResultSet, Object>(){

            @Override
            public boolean onResult(ResultSet records, Object result) throws Exception {
                if (!DateExpire.expire(records.getString(9), records.getString(10))) {
                    MedicineEntry me = new MedicineEntry();
                    me.setCode(records.getString(1));
                    me.setName(records.getString(2));
                    me.setKana(records.getString(3));
                    me.setUnit(OrcaUnitTranslater.toName(records.getString(4)));
                    me.setCostFlag(records.getString(5));
                    me.setCost(records.getString(6));
                    me.setYkzKbn(records.getString(7));
                    me.setJNCD(records.getString(8));
                    me.setStartDate(records.getString(9));
                    me.setEndDate(records.getString(10));
                    collection.add(me);
                    return true;
                }
                return false;
            }

            @Override
            public void onError(Exception ex) {
            }
        });
        return !collection.isEmpty();
    }

    public boolean getAllMedicineEntry(String code, final List<MedicineEntry> collection) {
        String sql = "select srycd,name,kananame,tanicd,tensikibetu,ten,ykzkbn,yakkakjncd,yukostymd,yukoedymd from tbl_tensu where srycd= " + this.addSingleQuote(code) + " order by yukoedymd desc offset 0 limit 1";
        Object result = this.executeQuery(sql, null, new GenericAdapter<ResultSet, Object>(){

            @Override
            public boolean onResult(ResultSet records, Object result) throws Exception {
                MedicineEntry me = new MedicineEntry();
                me.setCode(records.getString(1));
                me.setName(records.getString(2));
                me.setKana(records.getString(3));
                me.setUnit(OrcaUnitTranslater.toName(records.getString(4)));
                me.setCostFlag(records.getString(5));
                me.setCost(records.getString(6));
                me.setYkzKbn(records.getString(7));
                me.setJNCD(records.getString(8));
                me.setStartDate(records.getString(9));
                me.setEndDate(records.getString(10));
                collection.add(me);
                return true;
            }

            @Override
            public void onError(Exception ex) {
            }
        });
        return !collection.isEmpty();
    }

    private boolean getUpdatesFromOrca(String code, final List<String> collection) {
        String sql = "select ipnsrycd, rjnsrycd from tbl_srycdchg where ipnsrycd = " + this.addSingleQuote(code);
        this.executeQuery(sql, null, new GenericAdapter<ResultSet, List<String>>(){

            @Override
            public boolean onResult(ResultSet records, List<String> result) throws Exception {
                collection.add(records.getString(2));
                return true;
            }

            @Override
            public void onError(Exception ex) {
            }
        });
        return !collection.isEmpty();
    }

    public Availability isCodeNoLongerAvailableFromOrca(String code, Date now) {
        Availability result = Availability.AVAILABLE;
        final boolean[] available = new boolean[1];
        final int[] count = new int[1];
        available[0] = false;
        count[0] = 0;
        String sql = "select yukostymd, yukoedymd from tbl_tensu where srycd= " + this.addSingleQuote(code) + " order by yukoedymd desc offset 0 limit 1";
        this.executeQuery(sql, null, new GenericAdapter<ResultSet, Object>(){

            @Override
            public boolean onResult(ResultSet records, Object d) throws Exception {
                available[0] = true;
                if (!DateExpire.expire(records.getString(1), records.getString(2))) {
                    count[0] = count[0] + 1;
                }
                return false;
            }

            @Override
            public void onError(Exception ex) {
            }
        });
        result = available[0] ? (count[0] > 0 ? Availability.AVAILABLE : Availability.NO_LONGER_AVAILABLE) : Availability.NO_CODE;
        return result;
    }

    public List<String> getPeriodDatesFromOrca(String code) {
        final ArrayList<String> result = new ArrayList<String>();
        String sql = "select srycd,name,kananame,yukostymd,yukoedymd from tbl_tensu where srycd= " + this.addSingleQuote(code) + " order by yukoedymd desc offset 0 limit 1";
        this.executeQuery(sql, null, new GenericAdapter<ResultSet, Object>(){

            @Override
            public boolean onResult(ResultSet records, Object x) throws Exception {
                result.add(records.getString(1));
                result.add(records.getString(2));
                result.add(records.getString(3));
                result.add(records.getString(4));
                result.add(records.getString(5));
                return false;
            }

            @Override
            public void onError(Exception ex) {
            }
        });
        return result;
    }

    public String getClassCodeFromOrca(String code) {
        final ArrayList collection = new ArrayList();
        StringBuilder sql = new StringBuilder();
        sql.append("select srysyukbn, yukostymd, yukoedymd from tbl_tensu where ");
        if (GlobalVariables.getOrcaVersion().startsWith(YKZKBN)) {
            int hospnum = this.getHospNum();
            sql.append("hospnum=");
            sql.append(hospnum);
            sql.append(" and ");
        }
        sql.append("srycd = ");
        sql.append(this.addSingleQuote(code));
        this.executeQuery(sql.toString(), null, new GenericAdapter<ResultSet, Object>(){

            @Override
            public boolean onResult(ResultSet records, Object result) throws Exception {
                collection.add(records.getString(1));
                return true;
            }

            @Override
            public void onError(Exception ex) {
            }
        });
        if (collection.size() > 0) {
            return (String)collection.get(0);
        }
        return "";
    }

    public String getIdokanrenFromOrca(String code) {
        final ArrayList collection = new ArrayList();
        StringBuilder sql = new StringBuilder();
        sql.append("select idokanren from tbl_tensu where ");
        if (GlobalVariables.getOrcaVersion().startsWith(YKZKBN)) {
            int hospnum = this.getHospNum();
            sql.append("hospnum=");
            sql.append(hospnum);
            sql.append(" and ");
        }
        sql.append("srycd = ");
        sql.append(this.addSingleQuote(code));
        this.executeQuery(sql.toString(), null, new GenericAdapter<ResultSet, Object>(){

            @Override
            public boolean onResult(ResultSet records, Object result) throws Exception {
                collection.add(records.getString(1));
                return true;
            }

            @Override
            public void onError(Exception ex) {
            }
        });
        if (collection.size() > 0) {
            return (String)collection.get(0);
        }
        return "";
    }

    public String[] getTblTensuFromOrca(String srycd, Connection connection, Statement statement) {
        final String[] result = new String[3];
        try {
            String sql = "select NAME,TANINAME,SRYKBN from tbl_tensu where SRYCD=" + this.addSingleQuote(srycd);
            this.executeQueryContinueas(sql, null, connection, statement, new GenericAdapter<ResultSet, Object>(){

                @Override
                public boolean onResult(ResultSet records, Object x) throws Exception {
                    result[0] = records.getString(1);
                    result[1] = records.getString(2);
                    result[2] = records.getString(3);
                    return false;
                }

                @Override
                public void onError(Exception ex) {
                }
            });
        }
        catch (Exception ex) {
            LogWriter.error(this.getClass(), ex);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object executeQuery(String sql, Object userObject, GenericAdapter adapter) {
        try {
            Connection connection = this.getConnection();
            Statement statement = connection.createStatement();
            ResultSet results = null;
            try {
                results = statement.executeQuery(sql);
                do {
                    if (!results.next()) return userObject;
                } while (adapter.onResult(results, userObject));
                Object object = userObject;
                return object;
            }
            finally {
                results.close();
                this.closeStatement(statement);
                this.closeConnection(connection);
            }
        }
        catch (Exception ex) {
            adapter.onError(ex);
        }
        return userObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object executeQueryContinueas(String sql, Object userObject, Connection connection, Statement statement, GenericAdapter adapter) {
        try {
            ResultSet results = null;
            try {
                results = statement.executeQuery(sql);
                do {
                    if (!results.next()) return userObject;
                } while (adapter.onResult(results, userObject));
                Object object = userObject;
                return object;
            }
            finally {
                results.close();
            }
        }
        catch (Exception ex) {
            adapter.onError(ex);
        }
        return userObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransactionISolationLevel(String code) {
        StringBuilder sql = new StringBuilder();
        sql.append("SET TRANSACTION ISOLATION LEVEL ");
        sql.append(code);
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.getConnection();
            statement = connection.createStatement();
            statement.execute(sql.toString());
        }
        catch (Exception ex) {
            try {
                LogWriter.error(this.getClass(), ex);
            }
            catch (Throwable throwable) {
                this.closeStatement(statement);
                this.closeConnection(connection);
                throw throwable;
            }
            this.closeStatement(statement);
            this.closeConnection(connection);
        }
        this.closeStatement(statement);
        this.closeConnection(connection);
    }

    public String InputCdToCode(String inputcd) {
        final String[] result = new String[]{inputcd};
        try {
            String sql = "select srycd from tbl_inputcd where inputcd=" + this.addSingleQuote(inputcd);
            this.executeQuery(sql, null, new GenericAdapter<ResultSet, Object>(){

                @Override
                public boolean onResult(ResultSet records, Object x) throws Exception {
                    result[0] = records.getString(1).trim();
                    return false;
                }

                @Override
                public void onError(Exception ex) {
                }
            });
        }
        catch (Exception ex) {
            LogWriter.error(this.getClass(), ex);
        }
        return result[0];
    }

    public ArrayList<String> InputCdToCodes(String inputcd) {
        boolean find = false;
        ArrayList<String> result = new ArrayList<String>();
        Connection con = null;
        Statement st = null;
        String sql = "select srycd from tbl_inputcd where inputcd ~ '^" + inputcd;
        sql = sql + "'";
        try {
            con = this.getConnection();
            st = con.createStatement();
            ResultSet rs = st.executeQuery(sql);
            while (rs.next()) {
                result.add(rs.getString(1).trim());
                find = true;
            }
            rs.close();
            if (!find) {
                result.add(StringTool.toZenkakuUpperLower(inputcd));
            }
            this.closeStatement(st);
            this.closeConnection(con);
            return result;
        }
        catch (Exception e) {
            this.processError(e);
            this.closeStatement(st);
            this.closeConnection(con);
            result.add(StringTool.toZenkakuUpperLower(inputcd));
            return result;
        }
    }

    public String UserByoumeiToCode(String inputcd) {
        final String[] result = new String[]{inputcd};
        try {
            String sql = "select byomei from tbl_userbyomei where cdsyu!='C' and byomeiinputcd=" + this.addSingleQuote(inputcd);
            this.executeQuery(sql, null, new GenericAdapter<ResultSet, Object>(){

                @Override
                public boolean onResult(ResultSet records, Object x) throws Exception {
                    result[0] = records.getString(1).trim();
                    return false;
                }

                @Override
                public void onError(Exception ex) {
                }
            });
        }
        catch (Exception ex) {
            LogWriter.error(this.getClass(), ex);
        }
        return result[0];
    }

    public ArrayList<String> UserByoumeiToCodes(String inputcd) {
        boolean find = false;
        ArrayList<String> result = new ArrayList<String>();
        Connection con = null;
        Statement st = null;
        String sql = "select byomei from tbl_userbyomei where cdsyu!='C' and byomeiinputcd ~ '^" + inputcd;
        sql = sql + "'";
        try {
            con = this.getConnection();
            st = con.createStatement();
            ResultSet rs = st.executeQuery(sql);
            while (rs.next()) {
                result.add(rs.getString(1).trim());
                find = true;
            }
            rs.close();
            if (!find) {
                result.add(StringTool.toZenkakuUpperLower(inputcd));
            }
            this.closeStatement(st);
            this.closeConnection(con);
            return result;
        }
        catch (Exception e) {
            this.processError(e);
            this.closeStatement(st);
            this.closeConnection(con);
            result.add(StringTool.toZenkakuUpperLower(inputcd));
            return result;
        }
    }

    public static enum KNSJISKBN {
        NORMAL,
        KENSA,
        AUTO,
        EXPIRE,
        NOCODE;

    }

    public static enum Availability {
        AVAILABLE,
        NO_CODE,
        NO_LONGER_AVAILABLE;

    }
}

