/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.karte;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import open.dolphin.client.IChart;
import open.dolphin.infomodel.SimpleAddressModel;
import open.dolphin.project.GlobalSettings;

public class BasicInfoPanel
extends JPanel {
    private JLabel addressLabel;
    private JLabel nameLabel;
    private Color maleColor;
    private Color femaleColor;
    private Color unknownColor;
    private IChart parent;

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.addressLabel = new JLabel();
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setPreferredSize(new Dimension(270, 40));
        this.setLayout(new BorderLayout());
        this.nameLabel.setForeground(new Color(20, 20, 140));
        this.nameLabel.setHorizontalAlignment(0);
        this.nameLabel.setName("nameLabel");
        this.nameLabel.setOpaque(true);
        this.add((Component)this.nameLabel, "North");
        this.addressLabel.setForeground(new Color(20, 20, 140));
        this.addressLabel.setHorizontalAlignment(0);
        this.addressLabel.setName("addressLabel");
        this.addressLabel.setOpaque(true);
        this.add((Component)this.addressLabel, "Center");
    }

    public BasicInfoPanel(IChart parent) {
        this.parent = parent;
        this.maleColor = GlobalSettings.getColors(GlobalSettings.Parts.MALE);
        this.femaleColor = GlobalSettings.getColors(GlobalSettings.Parts.FEMALE);
        this.unknownColor = GlobalSettings.getColors(GlobalSettings.Parts.UNKNOWN);
        this.initComponents();
        this.update();
    }

    private void update() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.parent.getPatient().getFullName());
        sb.append("  ");
        sb.append(this.parent.getPatient().getAgeBirthday());
        this.nameLabel.setText(sb.toString());
        SimpleAddressModel address = this.parent.getPatient().getAddress();
        if (address != null) {
            this.addressLabel.setText(address.getAddress());
        } else {
            this.addressLabel.setText("\u3000");
        }
        String gender = this.parent.getPatient().getGenderDesc();
        Color color = null;
        color = gender.equals("\u7537") ? this.maleColor : (gender.equals("\u5973") ? this.femaleColor : this.unknownColor);
        this.nameLabel.setBackground(color);
        this.addressLabel.setBackground(color);
        this.setBackground(color);
    }
}

