/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.editor.stamp;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreePath;
import open.dolphin.client.editor.stamp.StampTree;
import open.dolphin.client.editor.stamp.StampTreeNode;
import open.dolphin.infomodel.ModuleInfoBean;

public class StampTreePopupAdapter
extends MouseAdapter {
    @Override
    public void mousePressed(MouseEvent evt) {
        this.showPopupMenu(evt);
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        this.showPopupMenu(evt);
    }

    private void showPopupMenu(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            ModuleInfoBean info;
            int y;
            int x;
            final StampTree tree = (StampTree)evt.getSource();
            TreePath destPath = tree.getPathForLocation(x = evt.getX(), y = evt.getY());
            if (destPath == null) {
                return;
            }
            StampTreeNode node = (StampTreeNode)destPath.getLastPathComponent();
            if (node.isLeaf() && !(info = (ModuleInfoBean)node.getUserObject()).isEditable()) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            JPopupMenu popup = new JPopupMenu();
            popup.add(new JMenuItem(new AbstractAction("\u65b0\u898f\u30d5\u30a9\u30eb\u30c0"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    tree.createNewFolder();
                    tree.saveStampTree();
                }
            }));
            popup.add(new JMenuItem(new AbstractAction("\u540d\u79f0\u5909\u66f4"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    tree.renameNode();
                    tree.saveStampTree();
                }
            }));
            popup.addSeparator();
            popup.add(new JMenuItem(new AbstractAction("\u524a \u9664"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    tree.deleteNode();
                    tree.saveStampTree();
                }
            }));
            popup.addSeparator();
            popup.add(new JMenuItem(new AbstractAction("\u3072\u3068\u3064\u4e0a\u3078"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    tree.moveUp();
                    tree.saveStampTree();
                }
            }));
            popup.add(new JMenuItem(new AbstractAction("\u3072\u3068\u3064\u4e0b\u3078"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    tree.moveDown();
                    tree.saveStampTree();
                }
            }));
            popup.show(evt.getComponent(), x, y);
        }
    }
}

