/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Ellipse2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;
import open.dolphin.project.GlobalConstants;

public class ColorChooserComponent
extends JComponent
implements MouseListener,
MouseMotionListener {
    public static final String SELECTED_COLOR = "selectedColor";
    private Color[] colors;
    private Color[] colorStart;
    private Dimension size;
    private Color strokeColor = Color.DARK_GRAY;
    private int strokeWidth = 2;
    private PropertyChangeSupport boundSupport = new PropertyChangeSupport(this);
    private Color selected;
    private int index = -1;

    protected ColorChooserComponent() {
        this.colorStart = GlobalConstants.getColorArray("color.set.default.start");
        this.colors = GlobalConstants.getColorArray("color.set.default.end");
        this.size = GlobalConstants.getDimension("colorCooserComp.default.size");
        this.strokeWidth = 1;
        this.setPreferredSize(new Dimension(2 * this.size.width * this.colors.length + this.size.width, 2 * this.size.height));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setCursor(new Cursor(0));
    }

    private ColorChooserComponent(Dimension size, Color[] colors) {
        this.size = size;
        this.colors = colors;
        this.setPreferredSize(new Dimension(2 * size.width * colors.length + size.width, 2 * size.height));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setCursor(new Cursor(0));
    }

    @Override
    public void addPropertyChangeListener(String prop, PropertyChangeListener l) {
        this.boundSupport.addPropertyChangeListener(prop, l);
    }

    @Override
    public void removePropertyChangeListener(String prop, PropertyChangeListener l) {
        this.boundSupport.removePropertyChangeListener(prop, l);
    }

    private Color getSelectedColor() {
        return this.selected;
    }

    private void setSelectedColor(Color selected) {
        this.selected = selected;
        this.boundSupport.firePropertyChange(SELECTED_COLOR, null, this.selected);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int x = e.getX() / this.size.width;
        int mod = x % 2;
        if (mod != 0) {
            this.index = x / 2;
        }
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        int x = e.getX() / this.size.width;
        int mod = x % 2;
        if (mod != 0) {
            this.index = x / 2;
        }
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.index = -1;
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int x = e.getX() / this.size.width;
        int mod = x % 2;
        if (mod != 0) {
            this.index = x / 2;
        }
        if (this.index >= 0 && this.index < this.colors.length) {
            this.setSelectedColor(this.colors[this.index]);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        double dx = this.size.getWidth() * 2.0;
        double offsetX = this.size.getWidth();
        double offsetY = (this.getPreferredSize().getHeight() - this.size.getHeight()) / 2.0;
        BasicStroke stroke = new BasicStroke(this.strokeWidth);
        RenderingHints rh = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHints(rh);
        for (int i = 0; i < this.colors.length; ++i) {
            double x = offsetX + (double)i * dx;
            double y = offsetY;
            Ellipse2D.Double body = new Ellipse2D.Double(x, y, this.size.getWidth(), this.size.getHeight());
            GradientPaint lightToDark = new GradientPaint((int)x, (int)y, this.colorStart[i], (int)x + this.size.width, (int)y + this.size.height, this.colors[i]);
            g2.setPaint(lightToDark);
            g2.fill(body);
            if (i != this.index) continue;
            g2.setColor(this.strokeColor);
            g2.setStroke(stroke);
            g2.draw(body);
        }
    }
}

