/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.srom;

import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.dict.DictionaryFactory;
import org.dcm4che.dict.UIDDictionary;
import org.dcm4che.srom.Code;
import org.dcm4che.srom.Equipment;
import org.dcm4che.srom.Patient;
import org.dcm4che.srom.RefSOP;
import org.dcm4che.srom.SOPInstanceRef;
import org.dcm4che.srom.SRDocument;
import org.dcm4che.srom.Series;
import org.dcm4che.srom.Study;
import org.dcm4che.srom.Template;
import org.dcm4che.srom.Verification;
import org.dcm4cheri.srom.CodeImpl;
import org.dcm4cheri.srom.EquipmentImpl;
import org.dcm4cheri.srom.KeyObjectImpl;
import org.dcm4cheri.srom.PatientImpl;
import org.dcm4cheri.srom.SOPInstanceRefImpl;
import org.dcm4cheri.srom.SeriesImpl;
import org.dcm4cheri.srom.StudyImpl;
import org.dcm4cheri.srom.TemplateImpl;
import org.dcm4cheri.srom.VerificationImpl;

class SRDocumentImpl
extends KeyObjectImpl
implements SRDocument {
    private static UIDDictionary uidDict = DictionaryFactory.getInstance().getDefaultUIDDictionary();
    private boolean complete = false;
    private String completionFlagDescription = null;
    private boolean verified = false;
    private final List verifications = new LinkedList();
    private final List predecessorDocuments = new LinkedList();
    private final List procedureCodes = new LinkedList();
    private final List otherEvidence = new LinkedList();

    SRDocumentImpl(Patient patient, Study study, Series series, Equipment equipment, String sopClassUID, String sopInstanceUID, int instanceNumber, Date obsDateTime, Template template, Code title, boolean separate) {
        super(patient, study, series, equipment, sopClassUID, sopInstanceUID, instanceNumber, obsDateTime, template, title, separate, "SR");
    }

    static SRDocument newSRDocument(Dataset ds) throws DcmValueException {
        if (!"CONTAINER".equals(ds.getString(0x40A040))) {
            throw new IllegalArgumentException(ds.getString(0x40A040));
        }
        SRDocumentImpl sr = new SRDocumentImpl(new PatientImpl(ds), new StudyImpl(ds), new SeriesImpl(ds), new EquipmentImpl(ds), ds.getString(524310), ds.getString(524312), ds.getInt(2097171, -1), ds.getDate(4235314), TemplateImpl.newTemplate(ds.getItem(4236548)), CodeImpl.newCode(ds.getItem(4235331)), "SEPARATE".equals(ds.getString(4235344)));
        sr.init(ds);
        return sr;
    }

    protected void init(Dataset ds) throws DcmValueException {
        super.init(ds);
        this.complete = "COMPLETE".equals(ds.getString(4236433));
        this.completionFlagDescription = ds.getString(4236434);
        this.verified = "VERIFIED".equals(ds.getString(4236435));
        this.initVerifications(ds.get(4235379));
        this.initSOPInstanceRefList(this.predecessorDocuments, ds.get(4236128));
        this.setProcedureCodes(CodeImpl.newCodes(ds.get(4236146)));
        this.initSOPInstanceRefList(this.otherEvidence, ds.get(4236165));
    }

    private void initVerifications(DcmElement sq) throws DcmValueException {
        if (sq == null) {
            return;
        }
        int n = sq.countItems();
        for (int i = 0; i < n; ++i) {
            this.addVerification(new VerificationImpl(sq.getItem(i)));
        }
    }

    public String toString() {
        return uidDict.lookup(this.sopClassUID) + "[" + this.getName().getCodeMeaning() + "," + this.sopInstanceUID + ",#" + this.instanceNumber + "," + this.getContentDateTime() + (this.complete ? ",complete" : ",partial") + (this.verified ? ",verified" : ",unverified") + "]";
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public String getCompletionFlagDescription() {
        return this.completionFlagDescription;
    }

    public void setCompletionFlagDescription(String desc) {
        this.completionFlagDescription = desc;
    }

    public boolean isVerified() {
        return this.verified;
    }

    public void setVerified(boolean verified) {
        this.verified = verified;
    }

    public Verification[] getVerifications() {
        return this.verifications.toArray(VerificationImpl.EMPTY_ARRAY);
    }

    public void setVerifications(Verification[] newVerifs) {
        List list = SRDocumentImpl.checkList(newVerifs);
        this.verifications.clear();
        this.verifications.addAll(list);
    }

    public boolean addVerification(Verification verification) {
        if (verification == null) {
            throw new NullPointerException();
        }
        return this.verifications.add(verification);
    }

    public boolean removeVerification(Verification verification) {
        return this.verifications.remove(verification);
    }

    public SOPInstanceRef[] getPredecessorDocuments() {
        return this.predecessorDocuments.toArray(SOPInstanceRefImpl.EMPTY_ARRAY);
    }

    public void setPredecessorDocuments(SOPInstanceRef[] refs) {
        List list = SRDocumentImpl.checkList(refs);
        this.predecessorDocuments.clear();
        this.predecessorDocuments.addAll(list);
    }

    public boolean addPredecessorDocument(SOPInstanceRef ref) {
        if (ref == null) {
            throw new NullPointerException();
        }
        if (this.predecessorDocuments.indexOf(ref) != -1) {
            return false;
        }
        return this.predecessorDocuments.add(ref);
    }

    public boolean removePredecessorDocument(RefSOP ref) {
        return this.predecessorDocuments.remove(ref);
    }

    public Code[] getProcedureCodes() {
        return this.procedureCodes.toArray(CodeImpl.EMPTY_ARRAY);
    }

    public void setProcedureCodes(Code[] newCodes) {
        List list = SRDocumentImpl.checkList(newCodes);
        this.procedureCodes.clear();
        this.procedureCodes.addAll(list);
    }

    public boolean addProcedureCode(Code code) {
        if (code == null) {
            throw new NullPointerException();
        }
        if (this.procedureCodes.indexOf(code) != -1) {
            return false;
        }
        return this.procedureCodes.add(code);
    }

    public boolean removeProcedureCode(Code code) {
        return this.procedureCodes.remove(code);
    }

    public SOPInstanceRef[] getOtherEvidence() {
        return this.otherEvidence.toArray(SOPInstanceRefImpl.EMPTY_ARRAY);
    }

    public SOPInstanceRef findOtherEvidence(RefSOP ref) {
        return SRDocumentImpl.findSOPInstanceRef(this.otherEvidence, ref);
    }

    public void setOtherEvidence(SOPInstanceRef[] refs) {
        List list = SRDocumentImpl.checkList(refs);
        this.otherEvidence.clear();
        this.otherEvidence.addAll(list);
    }

    public boolean addOtherEvidence(SOPInstanceRef ref) {
        if (ref == null) {
            throw new NullPointerException();
        }
        if (this.otherEvidence.indexOf(ref) != -1) {
            return false;
        }
        return this.otherEvidence.add(ref);
    }

    public boolean removeOtherEvidence(RefSOP ref) {
        return this.otherEvidence.remove(ref);
    }

    public void toDataset(Dataset ds) {
        Iterator it;
        DcmElement sq;
        super.toDataset(ds);
        ds.putCS(4236433, this.complete ? "COMPLETE" : "PARTIAL");
        ds.putLO(4236434, this.completionFlagDescription);
        ds.putCS(4236435, this.verified ? "VERIFIED" : "UNVERIFIED");
        if (!this.verifications.isEmpty()) {
            sq = ds.putSQ(4235379);
            it = this.verifications.iterator();
            while (it.hasNext()) {
                ((Verification)it.next()).toDataset(sq.addNewItem());
            }
        }
        if (!this.predecessorDocuments.isEmpty()) {
            SRDocumentImpl.sopInstanceRefListToSQ(this.predecessorDocuments, ds.putSQ(4236128));
        }
        if (!this.procedureCodes.isEmpty()) {
            sq = ds.putSQ(4236146);
            it = this.procedureCodes.iterator();
            while (it.hasNext()) {
                ((Code)it.next()).toDataset(sq.addNewItem());
            }
        }
        if (!this.otherEvidence.isEmpty()) {
            SRDocumentImpl.sopInstanceRefListToSQ(this.otherEvidence, ds.putSQ(4236165));
        }
    }
}

