/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che.tools.printscu;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringWriter;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.dcm4che.client.AssociationRequestor;
import org.dcm4che.client.PrintSCU;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.data.DcmParser;
import org.dcm4che.data.DcmParserFactory;
import org.dcm4che.net.DcmServiceException;
import org.dcm4che.tools.printscu.PropertiesPanel;
import org.dcm4che.util.UIDGenerator;

public class PrintSCUFrame
extends JFrame {
    public static final String DEFAULT_PROPERTIES_FILE = "PrintSCU.properties";
    private static final int DEF_WIDTH = 600;
    private static final int DEF_HEIGHT = 500;
    private final Logger log = Logger.getLogger(PrintSCUFrame.class);
    private AssociationRequestor assocRq = new AssociationRequestor();
    private PrintSCU printSCU;
    private String curPLutUid;
    private int nextImageBoxIndex;
    private int nextAnnIndex;
    private boolean colorMode = false;
    private boolean applySeparatePresState = false;
    private Action actConnect;
    private Action actRelease;
    private Action actCreateFilmSession;
    private Action actDeleteFilmSession;
    private Action actCreateFilmBox;
    private Action actDeleteFilmBox;
    private Action actCreateImageBox;
    private Action actCreatePlut;
    private Action actCreateAnnotation;
    private Action actDeletePlut;
    private Action actPrintFilmSession;
    private Action actPrintFilmBox;
    private Action actExit;
    private File lastFile = null;
    private JFileChooser chooser = new JFileChooser();
    private DcmObjectFactory dcmFactory = DcmObjectFactory.getInstance();
    private UIDGenerator uidGen = UIDGenerator.getInstance();
    private JSplitPane panel;
    private JPanel btnPanel;
    private PropertiesPanel propPanel;
    private static final String USAGE = "Usage: java -jar printSCU.jar [OPTIONS]\n\nConnects to a DICOM Print Service Class Provider.\nOptions:\n -h --help        show this help and exit\n";

    PrintSCUFrame() {
        Container contentPane = this.getContentPane();
        this.btnPanel = new JPanel();
        this.btnPanel.setLayout(new GridLayout(2, 3));
        this.propPanel = new PropertiesPanel(this, DEFAULT_PROPERTIES_FILE);
        JScrollPane scrollingPanel = new JScrollPane(this.propPanel);
        this.panel = new JSplitPane(0, this.btnPanel, scrollingPanel);
        contentPane.add(this.panel);
        this.btnPanel.setMinimumSize(new Dimension(600, 125));
        this.propPanel.setMinimumSize(new Dimension(600, 62));
        JMenuBar mnubar = new JMenuBar();
        this.setJMenuBar(mnubar);
        JMenu mnuFile = new JMenu("File");
        mnubar.add(mnuFile);
        this.actExit = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        };
        this.actExit.putValue("Name", "Exit");
        JMenuItem mnuExit = new JMenuItem(this.actExit);
        mnuFile.add(mnuExit);
        this.setSize(new Dimension(600, 500));
        this.actConnect = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                try {
                    String aString;
                    Integer anInt = PrintSCUFrame.this.getIntegerFromProperty("MaxPduSize");
                    if (anInt != null) {
                        PrintSCUFrame.this.assocRq.setMaxPDULength(anInt);
                    }
                    if ((aString = PrintSCUFrame.this.getStringFromProperty("CallingAET")) == null) {
                        throw new PrintSCUConfigurationException();
                    }
                    PrintSCUFrame.this.assocRq.setCallingAET(aString);
                    aString = PrintSCUFrame.this.getStringFromProperty("CalledAET");
                    if (aString == null) {
                        throw new PrintSCUConfigurationException();
                    }
                    PrintSCUFrame.this.assocRq.setCalledAET(aString);
                    aString = PrintSCUFrame.this.getStringFromProperty("Host");
                    if (aString == null) {
                        throw new PrintSCUConfigurationException();
                    }
                    PrintSCUFrame.this.assocRq.setHost(aString);
                    anInt = PrintSCUFrame.this.getIntegerFromProperty("Port");
                    if (anInt == null) {
                        throw new PrintSCUConfigurationException();
                    }
                    PrintSCUFrame.this.assocRq.setPort(anInt);
                }
                catch (PrintSCUConfigurationException e1) {
                    JOptionPane.showMessageDialog(PrintSCUFrame.this, e1);
                }
                PrintSCUFrame.this.printSCU = new PrintSCU(PrintSCUFrame.this.assocRq);
                PrintSCUFrame.this.printSCU.setAutoRefPLUT(true);
                PrintSCUFrame.this.printSCU.setCreateRQwithIUID(true);
                PrintSCUFrame.this.printSCU.setNegotiatePLUT(true);
                PrintSCUFrame.this.printSCU.setNegotiateAnnotation(true);
                PrintSCUFrame.this.printSCU.setNegotiateColorPrint(PrintSCUFrame.this.colorMode);
                PrintSCUFrame.this.printSCU.setNegotiateGrayscalePrint(!PrintSCUFrame.this.colorMode);
                PrintSCUFrame.this.curPLutUid = new String();
                try {
                    PrintSCUFrame.this.assocRq.connect();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    return;
                }
                this.setEnabled(false);
                PrintSCUFrame.this.actCreateFilmSession.setEnabled(true);
                PrintSCUFrame.this.actRelease.setEnabled(true);
            }
        };
        this.actConnect.putValue("Name", "Connect");
        this.actRelease = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                try {
                    PrintSCUFrame.this.assocRq.release();
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                    return;
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    return;
                }
                PrintSCUFrame.this.printSCU = null;
                PrintSCUFrame.this.onDisconnect();
                PrintSCUFrame.this.actConnect.setEnabled(true);
            }
        };
        this.actRelease.putValue("Name", "Release");
        this.actCreateFilmSession = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                String prop;
                Dataset attr = PrintSCUFrame.this.dcmFactory.newDataset();
                Integer propInt = PrintSCUFrame.this.getIntegerFromProperty("Session.NumberOfCopies");
                if (propInt != null) {
                    attr.putIS(0x20000010, propInt);
                }
                if ((prop = PrintSCUFrame.this.getStringFromProperty("Session.PrintPriority")) != null) {
                    attr.putCS(0x20000020, prop);
                }
                if ((prop = PrintSCUFrame.this.getStringFromProperty("Session.MediumType")) != null) {
                    attr.putCS(0x20000030, prop);
                }
                if ((prop = PrintSCUFrame.this.getStringFromProperty("Session.FilmDestination")) != null) {
                    attr.putCS(0x20000040, prop);
                }
                if ((prop = PrintSCUFrame.this.getStringFromProperty("Session.FilmSessionLabel")) != null) {
                    attr.putLO(0x20000050, prop);
                }
                if ((propInt = PrintSCUFrame.this.getIntegerFromProperty("Session.MemoryAllocation")) != null) {
                    attr.putIS(0x20000060, propInt);
                }
                if ((prop = PrintSCUFrame.this.getStringFromProperty("Session.OwnerID")) != null) {
                    attr.putSH(553648480, prop);
                }
                PrintSCUFrame.this.dump(attr, "Film Session");
                try {
                    PrintSCUFrame.this.printSCU.createFilmSession(attr, PrintSCUFrame.this.colorMode);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                    return;
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    return;
                }
                catch (DcmServiceException e1) {
                    e1.printStackTrace();
                    return;
                }
                PrintSCUFrame.this.actCreateFilmBox.setEnabled(true);
                PrintSCUFrame.this.actCreatePlut.setEnabled(true);
                this.setEnabled(false);
                PrintSCUFrame.this.actDeleteFilmSession.setEnabled(true);
            }
        };
        this.actCreateFilmSession.putValue("Name", "Create FilmSession");
        this.actCreateFilmBox = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Integer propInt;
                Dataset attr = PrintSCUFrame.this.dcmFactory.newDataset();
                String prop = PrintSCUFrame.this.getStringFromProperty("FilmBox.ImageDisplayFormat");
                if (prop != null) {
                    attr.putST(0x20100010, prop);
                }
                if ((prop = PrintSCUFrame.this.getStringFromProperty("FilmBox.FilmOrientation")) != null) {
                    attr.putCS(537919552, prop);
                }
                if ((prop = PrintSCUFrame.this.getStringFromProperty("FilmBox.FilmSizeID")) != null) {
                    attr.putCS(537919568, prop);
                }
                if ((prop = PrintSCUFrame.this.getStringFromProperty("FilmBox.RequestedResolutionID")) != null) {
                    attr.putCS(0x20200050, prop);
                }
                if ((prop = PrintSCUFrame.this.getStringFromProperty("FilmBox.AnnotationDisplayFormatID")) != null) {
                    attr.putCS(537919536, prop);
                }
                if ((prop = PrintSCUFrame.this.getStringFromProperty("FilmBox.MagnificationType")) != null) {
                    attr.putCS(537919584, prop);
                }
                if ((prop = PrintSCUFrame.this.getStringFromProperty("FilmBox.SmoothingType")) != null) {
                    attr.putCS(537919616, prop);
                }
                if ((prop = PrintSCUFrame.this.getStringFromProperty("FilmBox.BorderDensity")) != null) {
                    attr.putCS(0x20100100, prop);
                }
                if ((prop = PrintSCUFrame.this.getStringFromProperty("FilmBox.EmptyImageDensity")) != null) {
                    attr.putCS(0x20100110, prop);
                }
                if ((propInt = PrintSCUFrame.this.getIntegerFromProperty("FilmBox.MinDensity")) != null) {
                    attr.putUS(0x20100120, propInt);
                }
                if ((propInt = PrintSCUFrame.this.getIntegerFromProperty("FilmBox.MaxDensity")) != null) {
                    attr.putUS(537919792, propInt);
                }
                if ((prop = PrintSCUFrame.this.getStringFromProperty("FilmBox.Trim")) != null) {
                    attr.putCS(537919808, prop);
                }
                if ((prop = PrintSCUFrame.this.getStringFromProperty("FilmBox.ConfigurationInformation")) != null) {
                    attr.putST(537919824, prop);
                }
                if ((propInt = PrintSCUFrame.this.getIntegerFromProperty("FilmBox.Illumination")) != null) {
                    attr.putUS(537919838, propInt);
                }
                if ((propInt = PrintSCUFrame.this.getIntegerFromProperty("FilmBox.ReflectedAmbientLight")) != null) {
                    attr.putUS(537919840, propInt);
                }
                PrintSCUFrame.this.dump(attr, "Film Box");
                try {
                    PrintSCUFrame.this.printSCU.createFilmBox(attr);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                    return;
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    return;
                }
                catch (DcmServiceException e1) {
                    e1.printStackTrace();
                    return;
                }
                PrintSCUFrame.this.nextImageBoxIndex = 0;
                PrintSCUFrame.this.nextAnnIndex = 0;
                PrintSCUFrame.this.actCreateImageBox.setEnabled(true);
                this.setEnabled(false);
                PrintSCUFrame.this.actDeleteFilmBox.setEnabled(true);
                PrintSCUFrame.this.actCreatePlut.setEnabled(false);
                PrintSCUFrame.this.actDeletePlut.setEnabled(false);
                PrintSCUFrame.this.actCreateAnnotation.setEnabled(true);
            }
        };
        this.actCreateFilmBox.putValue("Name", "Create FilmBox");
        this.actCreateImageBox = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                File psFile = null;
                if (PrintSCUFrame.this.chooser.showOpenDialog(PrintSCUFrame.this) == 0) {
                    Integer propInt;
                    File file = PrintSCUFrame.this.chooser.getSelectedFile();
                    Dataset attr = PrintSCUFrame.this.dcmFactory.newDataset();
                    String prop = PrintSCUFrame.this.getStringFromProperty("FilmBox.Polarity");
                    if (prop != null) {
                        attr.putCS(0x20200020, prop);
                    }
                    if ((prop = PrintSCUFrame.this.getStringFromProperty("FilmBox.MagnificationType")) != null) {
                        attr.putCS(537919584, prop);
                    }
                    if ((prop = PrintSCUFrame.this.getStringFromProperty("FilmBox.SmoothingType")) != null) {
                        attr.putCS(537919616, prop);
                    }
                    if ((propInt = PrintSCUFrame.this.getIntegerFromProperty("FilmBox.MinDensity")) != null) {
                        attr.putUS(0x20100120, propInt);
                    }
                    if ((propInt = PrintSCUFrame.this.getIntegerFromProperty("FilmBox.MaxDensity")) != null) {
                        attr.putUS(537919792, propInt);
                    }
                    if ((prop = PrintSCUFrame.this.getStringFromProperty("FilmBox.RequestedDecimateCropBehavior")) != null) {
                        attr.putCS(0x20200040, prop);
                    }
                    if ((prop = PrintSCUFrame.this.getStringFromProperty("FilmBox.RequestedImageSize")) != null) {
                        attr.putDS(0x20200030, prop);
                    }
                    String configInfo = PrintSCUFrame.this.getStringFromProperty("FilmBox.ConfigurationInformation");
                    try {
                        if (PrintSCUFrame.this.curPLutUid == null) {
                            prop = PrintSCUFrame.this.getStringFromProperty("LUT.Gamma");
                            if (prop != null) {
                                configInfo = configInfo == null ? "gamma=" + prop : configInfo + "\\gamma=" + prop;
                            } else {
                                prop = PrintSCUFrame.this.getStringFromProperty("LUT.Shape");
                                if (prop != null) {
                                    PrintSCUFrame.this.curPLutUid = PrintSCUFrame.this.printSCU.createPLUT(prop);
                                } else {
                                    throw new PrintSCUConfigurationException("You need to either create a P-LUT, set LUT.Shape, or LUT.Gamma");
                                }
                            }
                        }
                        if (configInfo != null) {
                            attr.putST(537919824, configInfo);
                        }
                        PrintSCUFrame.this.dump(attr, "Image Box");
                        Boolean burnInOverlays = PrintSCUFrame.this.getBooleanFromProperty("User.BurnInOverlays");
                        Boolean autoScale = PrintSCUFrame.this.getBooleanFromProperty("User.AutoScale");
                        if (PrintSCUFrame.this.applySeparatePresState && PrintSCUFrame.this.chooser.showOpenDialog(PrintSCUFrame.this) == 0) {
                            psFile = PrintSCUFrame.this.chooser.getSelectedFile();
                        }
                        PrintSCUFrame.this.printSCU.setImageBox(PrintSCUFrame.this.nextImageBoxIndex++, file, psFile, attr, burnInOverlays != null ? burnInOverlays : false, autoScale != null ? autoScale : true);
                    }
                    catch (PrintSCUConfigurationException e1) {
                        JOptionPane.showMessageDialog(PrintSCUFrame.this, e1);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                        return;
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                        return;
                    }
                    catch (DcmServiceException e1) {
                        e1.printStackTrace();
                        return;
                    }
                    PrintSCUFrame.this.actPrintFilmSession.setEnabled(true);
                    PrintSCUFrame.this.actPrintFilmBox.setEnabled(true);
                    if (PrintSCUFrame.this.nextImageBoxIndex >= PrintSCUFrame.this.printSCU.countImageBoxes()) {
                        this.setEnabled(false);
                    }
                }
            }
        };
        this.actCreateImageBox.putValue("Name", "Add ImageBox");
        this.actCreateAnnotation = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Dataset attr = PrintSCUFrame.this.dcmFactory.newDataset();
                String text = JOptionPane.showInputDialog(PrintSCUFrame.this, "Enter annotation text:", "Text" + (PrintSCUFrame.this.nextAnnIndex + 1));
                if (text == null) {
                    return;
                }
                try {
                    PrintSCUFrame.this.printSCU.setAnnotationBox(PrintSCUFrame.this.nextAnnIndex++, text);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                catch (DcmServiceException e1) {
                    e1.printStackTrace();
                }
                if (PrintSCUFrame.this.nextAnnIndex >= PrintSCUFrame.this.printSCU.countAnnotationBoxes()) {
                    this.setEnabled(false);
                }
            }
        };
        this.actCreateAnnotation.putValue("Name", "Add Annotation");
        this.actCreatePlut = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Dataset ds = PrintSCUFrame.this.dcmFactory.newDataset();
                if (PrintSCUFrame.this.chooser.showOpenDialog(PrintSCUFrame.this) != 0) {
                    return;
                }
                File file = PrintSCUFrame.this.chooser.getSelectedFile();
                try {
                    DcmParser parser = DcmParserFactory.getInstance().newDcmParser(new BufferedInputStream(new FileInputStream(file)));
                    parser.setDcmHandler(ds.getDcmHandler());
                    parser.parseDcmFile(null, -1);
                    if (ds.vm(542113808) == -1) {
                        throw new IOException();
                    }
                }
                catch (FileNotFoundException e1) {
                    JOptionPane.showMessageDialog(PrintSCUFrame.this, "Could not open file: " + file);
                    return;
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(PrintSCUFrame.this, "Could not read file: " + file);
                    return;
                }
                try {
                    PrintSCUFrame.this.curPLutUid = PrintSCUFrame.this.printSCU.createPLUT(ds);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                    return;
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    return;
                }
                catch (DcmServiceException e1) {
                    e1.printStackTrace();
                    return;
                }
                this.setEnabled(false);
                PrintSCUFrame.this.actDeletePlut.setEnabled(true);
            }
        };
        this.actCreatePlut.putValue("Name", "Create P-LUT");
        this.actDeleteFilmSession = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                try {
                    PrintSCUFrame.this.printSCU.deleteFilmSession();
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                catch (DcmServiceException e1) {
                    e1.printStackTrace();
                }
                this.setEnabled(false);
                PrintSCUFrame.this.actCreateFilmBox.setEnabled(false);
                PrintSCUFrame.this.actDeleteFilmBox.setEnabled(false);
                PrintSCUFrame.this.actCreateImageBox.setEnabled(false);
                PrintSCUFrame.this.actCreatePlut.setEnabled(false);
                PrintSCUFrame.this.actDeletePlut.setEnabled(false);
                PrintSCUFrame.this.actCreateAnnotation.setEnabled(false);
                PrintSCUFrame.this.actPrintFilmSession.setEnabled(false);
                PrintSCUFrame.this.actPrintFilmBox.setEnabled(false);
                PrintSCUFrame.this.actCreateFilmSession.setEnabled(true);
            }
        };
        this.actDeleteFilmSession.putValue("Name", "Delete FilmSession");
        this.actDeleteFilmBox = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                try {
                    PrintSCUFrame.this.printSCU.deleteFilmBox();
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                catch (DcmServiceException e1) {
                    e1.printStackTrace();
                }
                this.setEnabled(false);
                PrintSCUFrame.this.actCreateFilmBox.setEnabled(true);
                PrintSCUFrame.this.actCreateImageBox.setEnabled(false);
                PrintSCUFrame.this.actPrintFilmBox.setEnabled(false);
                PrintSCUFrame.this.actPrintFilmSession.setEnabled(false);
                PrintSCUFrame.this.actCreatePlut.setEnabled(true);
                PrintSCUFrame.this.actDeletePlut.setEnabled(true);
                PrintSCUFrame.this.actCreateAnnotation.setEnabled(false);
            }
        };
        this.actDeleteFilmBox.putValue("Name", "Delete FilmBox");
        this.actDeletePlut = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                try {
                    PrintSCUFrame.this.printSCU.deletePLUT(PrintSCUFrame.this.curPLutUid);
                    PrintSCUFrame.this.curPLutUid = null;
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                catch (DcmServiceException e1) {
                    e1.printStackTrace();
                }
                this.setEnabled(false);
                PrintSCUFrame.this.actCreatePlut.setEnabled(true);
            }
        };
        this.actDeletePlut.putValue("Name", "Delete P-LUT");
        this.actPrintFilmSession = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                try {
                    PrintSCUFrame.this.printSCU.printFilmSession();
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                    return;
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    return;
                }
                catch (DcmServiceException e1) {
                    e1.printStackTrace();
                    return;
                }
            }
        };
        this.actPrintFilmSession.putValue("Name", "Print FilmSession");
        this.actPrintFilmBox = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                try {
                    PrintSCUFrame.this.printSCU.printFilmBox();
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                    return;
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    return;
                }
                catch (DcmServiceException e1) {
                    e1.printStackTrace();
                    return;
                }
            }
        };
        this.actPrintFilmBox.putValue("Name", "Print FilmBox");
        this.onDisconnect();
        JPanel subBtnPanel = new JPanel();
        subBtnPanel.setLayout(new GridLayout(3, 1));
        this.btnPanel.add(subBtnPanel);
        subBtnPanel.add(new JLabel("Print Server"));
        JButton btnConnect = new JButton(this.actConnect);
        subBtnPanel.add(btnConnect);
        JButton btnRelease = new JButton(this.actRelease);
        subBtnPanel.add(btnRelease);
        subBtnPanel = new JPanel();
        subBtnPanel.setLayout(new GridLayout(3, 1));
        this.btnPanel.add(subBtnPanel);
        subBtnPanel.add(new JLabel("Film Session"));
        JButton btnCreateFilmSession = new JButton(this.actCreateFilmSession);
        subBtnPanel.add(btnCreateFilmSession);
        JButton btnDeleteFilmSession = new JButton(this.actDeleteFilmSession);
        subBtnPanel.add(btnDeleteFilmSession);
        subBtnPanel = new JPanel();
        subBtnPanel.setLayout(new GridLayout(3, 1));
        this.btnPanel.add(subBtnPanel);
        subBtnPanel.add(new JLabel("Presentation LUT"));
        JButton btnCreatePlut = new JButton(this.actCreatePlut);
        subBtnPanel.add(btnCreatePlut);
        JButton btnDeletePlut = new JButton(this.actDeletePlut);
        subBtnPanel.add(btnDeletePlut);
        subBtnPanel = new JPanel();
        subBtnPanel.setLayout(new GridLayout(3, 1));
        this.btnPanel.add(subBtnPanel);
        subBtnPanel.add(new JLabel("Film Box"));
        JButton btnCreateFilmBox = new JButton(this.actCreateFilmBox);
        subBtnPanel.add(btnCreateFilmBox);
        JButton btnDeleteFilmBox = new JButton(this.actDeleteFilmBox);
        subBtnPanel.add(btnDeleteFilmBox);
        subBtnPanel = new JPanel();
        subBtnPanel.setLayout(new GridLayout(3, 1));
        this.btnPanel.add(subBtnPanel);
        subBtnPanel.add(new JLabel("Image Box"));
        JButton btnCreateImageBox = new JButton(this.actCreateImageBox);
        subBtnPanel.add(btnCreateImageBox);
        JCheckBox chkUseSeparatePresState = new JCheckBox(new AbstractAction("Apply Presentation State"){

            public void actionPerformed(ActionEvent e) {
                PrintSCUFrame.this.applySeparatePresState = !PrintSCUFrame.this.applySeparatePresState;
            }
        });
        chkUseSeparatePresState.setSelected(this.applySeparatePresState);
        chkUseSeparatePresState.setToolTipText("Enables you to choose a separate Presentation State object to apply to the chosen DICOM image");
        subBtnPanel.add(chkUseSeparatePresState);
        subBtnPanel = new JPanel();
        subBtnPanel.setLayout(new GridLayout(3, 1));
        this.btnPanel.add(subBtnPanel);
        subBtnPanel.add(new JLabel("Annotation"));
        JButton btnCreateAnnotation = new JButton(this.actCreateAnnotation);
        subBtnPanel.add(btnCreateAnnotation);
        subBtnPanel = new JPanel();
        subBtnPanel.setLayout(new GridLayout(3, 1));
        this.btnPanel.add(subBtnPanel);
        subBtnPanel.add(new JLabel("Print"));
        JButton btnPrintFilmSession = new JButton(this.actPrintFilmSession);
        subBtnPanel.add(btnPrintFilmSession);
        JButton btnPrintFilmBox = new JButton(this.actPrintFilmBox);
        subBtnPanel.add(btnPrintFilmBox);
        this.propertyChanged(null);
    }

    public void propertyChanged(String propertyName) {
        if (propertyName == null || "Verbose".equals(propertyName)) {
            Integer verbose = this.getIntegerFromProperty("Verbose");
            if (verbose != null) {
                switch (verbose) {
                    case 0: {
                        this.log.setLevel(Level.OFF);
                        break;
                    }
                    case 1: {
                        this.log.setLevel(Level.FATAL);
                        break;
                    }
                    case 2: {
                        this.log.setLevel(Level.ERROR);
                        break;
                    }
                    case 3: {
                        this.log.setLevel(Level.WARN);
                        break;
                    }
                    case 4: {
                        this.log.setLevel(Level.INFO);
                        break;
                    }
                    case 5: {
                        this.log.setLevel(Level.DEBUG);
                        break;
                    }
                    case 6: {
                        this.log.setLevel(Level.ALL);
                    }
                }
            } else {
                this.log.setLevel(Level.WARN);
            }
        }
    }

    PrintSCUFrame(String title) {
        this();
        this.setTitle(title);
    }

    protected void dump(Dataset ds, String from) {
        StringWriter out = new StringWriter();
        try {
            ds.dumpDataset(out, null);
        }
        catch (IOException ioe) {
            this.log.warn("Could not dump attributes for " + from);
        }
        this.log.info(out.toString());
    }

    protected String getStringFromProperty(String propertyName) {
        return (String)this.getFromProperty(propertyName, String.class);
    }

    protected Integer getIntegerFromProperty(String propertyName) {
        return (Integer)this.getFromProperty(propertyName, Integer.class);
    }

    protected Boolean getBooleanFromProperty(String propertyName) {
        return (Boolean)this.getFromProperty(propertyName, Boolean.class);
    }

    private final Object getFromProperty(String propertyName, Class argType) {
        Object ret = null;
        String prop = this.propPanel.getProperty(propertyName);
        if (prop != null) {
            try {
                if (argType == String.class) {
                    ret = prop;
                } else if (argType == Integer.class) {
                    ret = Integer.valueOf(prop);
                } else if (argType == Boolean.class) {
                    ret = "true".equalsIgnoreCase(prop) || "yes".equalsIgnoreCase(prop) || "1".equals(prop);
                }
            }
            catch (NumberFormatException e) {
                this.log.warn(propertyName + " is an invalid number");
            }
        }
        if (ret != null) {
            this.log.debug("Setting property " + propertyName + " = " + ret);
        }
        return ret;
    }

    private void onDisconnect() {
        this.actRelease.setEnabled(false);
        this.actCreateFilmSession.setEnabled(false);
        this.actCreateFilmBox.setEnabled(false);
        this.actCreateImageBox.setEnabled(false);
        this.actCreatePlut.setEnabled(false);
        this.actCreateAnnotation.setEnabled(false);
        this.actPrintFilmSession.setEnabled(false);
        this.actPrintFilmBox.setEnabled(false);
        this.actDeleteFilmSession.setEnabled(false);
        this.actDeleteFilmBox.setEnabled(false);
        this.actDeletePlut.setEnabled(false);
    }

    private static void exit(String msg) {
        System.out.println(msg);
        System.out.println(USAGE);
        System.exit(1);
    }

    public static void main(String[] args) {
        BasicConfigurator.configure();
        LongOpt[] longopts = new LongOpt[]{new LongOpt("help", 0, null, 104)};
        Getopt g = new Getopt("printSCU", args, "t:a:h", longopts, true);
        try {
            int c;
            while ((c = g.getopt()) != -1) {
                switch (c) {
                    case 63: 
                    case 104: {
                        PrintSCUFrame.exit("");
                    }
                }
            }
            int optind = g.getOptind();
            int argc = args.length - optind;
            if (argc != 0) {
                PrintSCUFrame.exit("printSCU: wrong number of arguments\n");
            }
            PrintSCUFrame printSCU = new PrintSCUFrame("Print SCU Client");
            printSCU.setDefaultCloseOperation(3);
            printSCU.show();
        }
        catch (IllegalArgumentException e) {
            PrintSCUFrame.exit("printSCU: illegal argument - " + e.getMessage() + "\n");
        }
    }

    public static final class PrintSCUConfigurationException
    extends RuntimeException {
        PrintSCUConfigurationException() {
        }

        PrintSCUConfigurationException(String msg) {
            super(msg);
        }
    }
}

