<?php
final class Request {
	public $get = array();
	public $post = array();
	public $cookie = array();
	public $files = array();
	public $server = array();
	
  	public function __construct() {
		$_GET = $this->clean($_GET);
		$_POST = $this->clean($_POST);
		$_COOKIE = $this->clean($_COOKIE);
		$_FILES = $this->clean($_FILES);
		$_SERVER = $this->clean($_SERVER);
		
		$this->get = $_GET;
		$this->post = $_POST;
		$this->cookie = $_COOKIE;
		$this->files = $_FILES;
		$this->server = $_SERVER;
	}
	
  	public function clean($data) {
		if (is_array($data)) {
	  		foreach ($data as $key => $value) {
				unset($data[$key]);
				
	    		$data[$this->clean($key)] = $this->clean($value);
	  		}
		} else {
/////////////////////////////////////////////////////////////////////////////////////////////
//opencart【日本語版】  bof マルチバイトでエンコーディング
/////////////////////////////////////////////////////////////////////////////////////////////			 
			if( mb_detect_encoding($data) !== "UTF-8" ){
			
				$data = htmlentities(mb_convert_encoding($data, "UTF-8"), ENT_QUOTES, 'UTF-8');
				
			}else{
			
				$data = htmlentities($data, ENT_QUOTES, 'UTF-8');
			
			}
/////////////////////////////////////////////////////////////////////////////////////////////
//opencart【日本語版】  eof
/////////////////////////////////////////////////////////////////////////////////////////////
		}

		return $data;
	}
}
?>