/*
 * javax -- extended OnigSyntaxJava.
 */
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import onig4j.OnigOptionType;
import onig4j.OnigRegex;
import onig4j.OnigSyntaxType;

public class javax {
    public static void main(String[] args) {
        lineTerminaterJava();
        lineTerminaterJavaEmbeddedFlag();
        caseInsensitiveAsciiOnly();
        caseInsensitiveAsciiOnlyEmbeddedFlag();
    }

    private static int lineTerminaterJava() {
        final String pattern = "$";
        final String str = "one\ntwo\r\nthree\rfour\u0085five\u2028six\u2029seven";

        final OnigSyntaxType syntax = OnigSyntaxType.ONIG_SYNTAX_JAVA;
        final Collection<OnigOptionType> options
                = EnumSet.of(OnigOptionType.ONIG_OPTION_NEGATE_SINGLELINE);
        final OnigRegex reg = new OnigRegex(pattern, syntax, options);
        final List<String> list = reg.split(str, -1);
        for (final String s : reg.split(str, -1)) {
            System.out.println("[" + s + "]");
        }
        
        reg.close();
        return list.size();
    }

    private static int lineTerminaterJavaEmbeddedFlag() {
        final String pattern = "(?m-d)$";
        final String str = "one\ntwo\r\nthree\rfour\u0085five\u2028six\u2029seven";

        final OnigSyntaxType syntax = OnigSyntaxType.ONIG_SYNTAX_JAVA;
        final OnigRegex reg = new OnigRegex(pattern, syntax);
        final List<String> list = reg.split(str, -1);
        for (final String s : reg.split(str, -1)) {
            System.out.println("[" + s + "]");
        }
        
        reg.close();
        return list.size();
    }

    private static int caseInsensitiveAsciiOnly() {
        final String pattern = "\u03C0\u03C6\u03C9";    // "πφω"
        final String str = "\u03A0\u03A6\u03A9";        // "ΠΦΩ"

        final OnigSyntaxType syntax = OnigSyntaxType.ONIG_SYNTAX_JAVA;
        final Collection<OnigOptionType> options
                = EnumSet.of(OnigOptionType.ONIG_OPTION_IGNORECASE);
        final OnigRegex reg = new OnigRegex(pattern, syntax, options);
        final int r = reg.search(str);
        if (r == OnigRegex.ONIG_MISMATCH) {
            System.out.println("search fail");
        }
        
        reg.close();
        return r;
    }

    private static int caseInsensitiveAsciiOnlyEmbeddedFlag() {
        final String pattern = "(?i-u)\u03C0\u03C6\u03C9";  // "πφω"
        final String str = "\u03A0\u03A6\u03A9";            // "ΠΦΩ"

        final OnigSyntaxType syntax = OnigSyntaxType.ONIG_SYNTAX_JAVA;
        final OnigRegex reg = new OnigRegex(pattern, syntax);
        final int r = reg.search(str);
        if (r == OnigRegex.ONIG_MISMATCH) {
            System.out.println("search fail");
        }
        
        reg.close();
        return r;
    }
    
    @org.junit.Test
    public void run() {
         org.junit.Assert.assertEquals(8, javax.lineTerminaterJava());
         org.junit.Assert.assertEquals(8, javax.lineTerminaterJavaEmbeddedFlag());
         org.junit.Assert.assertEquals(OnigRegex.ONIG_MISMATCH, javax.caseInsensitiveAsciiOnly());
         org.junit.Assert.assertEquals(OnigRegex.ONIG_MISMATCH, javax.caseInsensitiveAsciiOnlyEmbeddedFlag());
    }
}
