package onig4j.java.util.regex;

import onig4j.OnigRegion;

/**
 *
 * @author calico
 */
class MatchResultImpl implements MatchResult {
    
    protected final OnigRegion region;
    protected CharSequence input;
    protected int offset;
    protected boolean hasTransparentBounds;

    MatchResultImpl(OnigRegion region, CharSequence input) {
        this.region = region;
        this.input = input;
    }

    MatchResultImpl(OnigRegion region, CharSequence input, int offset) {
        this.region = region;
        this.input = input;
        this.offset = offset;
    }

    // START implements
    public int start() {
        return start(0);
    }

    public int start(int group) {
        if (region.count() > 0) {
            if (hasTransparentBounds) {
                return region.begin(group);
            } else {
                return region.begin(group) + offset;
            }
        }
        throw new IllegalStateException("No match available");
    }

    public int end() {
        return end(0);
    }

    public int end(int group) {
        if (region.count() > 0) {
            if (hasTransparentBounds) {
                return region.end(group);
            } else {
                return region.end(group) + offset;
            }
        }
        throw new IllegalStateException("No match available");
    }

    public String group() {
        return group(0);
    }

    public String group(int group) {
        return input.subSequence(start(group), end(group)).toString();
    }

    public int groupCount() {
        return (region.count() > 0 ? region.count() - 1 : 0);
    }
    // END implements
}
