/*
 * Decompiled with CFR 0.152.
 */
package org.vmguys.vmtools.utils;

import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.JDOMFactory;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.vmguys.vmtools.utils.DomFactory;
import org.vmguys.vmtools.utils.JdomDifferenceFinder;
import org.vmguys.vmtools.utils.ProgressReporter;

public class TestJdomDifferenceFinder
implements ProgressReporter {
    private int greatestItemsProcessed;

    private void go(URL url1, URL url2) {
        try {
            boolean addComments = true;
            boolean discardWhitespace = true;
            Namespace namespace = Namespace.getNamespace((String)"http://www.vmguys.com/grw");
            SAXBuilder sb = new SAXBuilder();
            sb.setFactory((JDOMFactory)new DomFactory());
            System.out.println("parsing...");
            Document doc1 = sb.build(url1);
            Document doc2 = sb.build(url2);
            System.out.println("instantiating JdomDifferenceFinder...");
            JdomDifferenceFinder j = new JdomDifferenceFinder(namespace, discardWhitespace, addComments);
            j.setProgressReporter(this);
            this.greatestItemsProcessed = -1;
            System.out.println("generating diffs...");
            Element diffRoot = new Element("Differences", namespace);
            j.findDifferences(doc1.getRootElement(), doc2.getRootElement(), diffRoot);
            System.out.println("differences...");
            XMLOutputter xmlo = new XMLOutputter("  ", true);
            xmlo.setTextNormalize(true);
            xmlo.output(diffRoot, (OutputStream)System.out);
            System.out.println();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        if (args.length == 2) {
            try {
                URL url1 = new URL(args[0]);
                URL url2 = new URL(args[1]);
                new TestJdomDifferenceFinder().go(url1, url2);
            }
            catch (MalformedURLException mux) {
                System.err.println(mux);
            }
        } else {
            System.err.println("usage: TestXmlDifferenceFinder <OriginalURL> <ModifiedURL>");
        }
    }

    public void showProgress(int itemsProcessed, int totalItems) {
        if (itemsProcessed > this.greatestItemsProcessed) {
            System.err.print("\r" + itemsProcessed + " of " + totalItems + "   ");
            this.greatestItemsProcessed = itemsProcessed;
            if (itemsProcessed == totalItems) {
                System.err.println();
            }
        }
    }
}

