/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.dmdemo;

import com.funambol.dmdemo.GenericProcessorTools;
import com.funambol.dmdemo.RegistrationTools;
import com.funambol.dmdemo.TreeDiscoveryProcessorTools;
import com.funambol.framework.engine.dm.ManagementException;
import com.funambol.framework.engine.dm.ManagementOperation;
import com.funambol.framework.engine.dm.UserAlertManagementOperation;
import com.funambol.framework.tools.DBTools;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class DMDemoBean {
    public static final String PROCESSOR_GENERIC = "GenericProcessor";
    public static final String PROCESSOR_TREE_DISCOVERY = "TreeDiscoveryProcessor";
    public static final String PROCESSOR_GET_DEVICE_DETAILS = "GetDeviceDetails";
    private static final String JNDI_NAME = "java:comp/env/jdbc/fnbldm";
    private static final String SQL_INSERT_DM_STATE = "INSERT INTO fnbl_dm_state (id,device,mssid,state,operation) values (?,?,?,'P',?)";
    private static final String SQL_UPDATE_DM_STATE = "UPDATE fnbl_dm_state SET device=?, operation=? WHERE id =?";
    private static final String SQL_SELECT_DM_SESSIONS_LIST = "SELECT id, device, state, operation, start_ts, end_ts FROM fnbl_dm_state ";
    private static final String SQL_SELECT_DM_STATE = "SELECT id, device, state, operation, start_ts, end_ts FROM fnbl_dm_state WHERE mssid=?";
    private static final String SQL_DELETE_DM_STATE = "DELETE FROM fnbl_dm_state WHERE id=?";
    private static final String MESSAGE_DUMMY_ALERT_OPERATION = "MESSAGE_DUMMY_ALERT_OPERATION";
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle("DMDemo", new Locale("en", "EN"));
    public static final UserAlertManagementOperation DUMMY_ALERT_OPERATION = UserAlertManagementOperation.getDisplay((String)resourceBundle.getString("MESSAGE_DUMMY_ALERT_OPERATION"), (int)5, (int)15);
    private static final Logger log = Logger.getLogger((String)DMDemoBean.class.getName());
    private DataSource datasource = null;
    private String sessionId = null;
    private String state = null;
    private String deviceId = null;
    private String operation = null;
    private String password = null;
    private boolean userIsLogged = false;
    public GenericProcessorTools genericProcessorTools = null;
    public TreeDiscoveryProcessorTools treeDiscoveryProcessorTools = null;
    public RegistrationTools registrationTools = null;

    public DMDemoBean() {
        if (log.isEnabledFor((Priority)Level.TRACE)) {
            log.trace((Object)"New DMDemoBean");
        }
        this.datasource = this.lookupDataSource();
        this.genericProcessorTools = new GenericProcessorTools(this.datasource);
        this.treeDiscoveryProcessorTools = new TreeDiscoveryProcessorTools(this.datasource);
        this.registrationTools = new RegistrationTools(this.datasource);
    }

    public static boolean isDummyOperation(ManagementOperation operation) {
        if (operation == null) {
            return false;
        }
        if (!(operation instanceof UserAlertManagementOperation)) {
            return false;
        }
        UserAlertManagementOperation alertOperation = (UserAlertManagementOperation)operation;
        if (alertOperation.getAlertCode() != 1100) {
            return false;
        }
        String[] alerts = alertOperation.getAlerts();
        if (alerts == null || alerts.length != 1) {
            return false;
        }
        return alerts[0] != null && resourceBundle.getString(MESSAGE_DUMMY_ALERT_OPERATION).equals(alerts[0]);
    }

    public DataSource getDataSource() {
        if (this.datasource == null) {
            this.datasource = this.lookupDataSource();
        }
        return this.datasource;
    }

    public List<Map> getSessionsList(String deviceId) throws ManagementException {
        String whereDeviceId = "";
        if (deviceId != null && !deviceId.equals("")) {
            whereDeviceId = " WHERE device=?";
        } else {
            deviceId = "";
        }
        Connection con = null;
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        String query = "SELECT id, device, state, operation, start_ts, end_ts FROM fnbl_dm_state  " + whereDeviceId + " order by id, end_ts";
        ArrayList<Map> sessionsList = null;
        try {
            con = this.datasource.getConnection();
            pStmt = con.prepareStatement(query);
            if (!deviceId.equals("")) {
                pStmt.setObject(1, deviceId);
            }
            rs = pStmt.executeQuery();
            sessionsList = new ArrayList<Map>();
            HashMap<String, Object> row = null;
            while (rs.next()) {
                row = new HashMap<String, Object>();
                row.put("id", rs.getString("id"));
                row.put("device", rs.getString("device"));
                row.put("operation", rs.getString("operation"));
                row.put("state", rs.getString("state"));
                row.put("start_ts", rs.getTimestamp("start_ts"));
                row.put("end_ts", rs.getTimestamp("end_ts"));
                sessionsList.add(row);
            }
        }
        catch (SQLException e) {
            try {
                throw new ManagementException("Error reading the sessions list", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)con, pStmt, rs);
                throw throwable;
            }
        }
        DBTools.close((Connection)con, (Statement)pStmt, (ResultSet)rs);
        return sessionsList;
    }

    public void startNewManagementSession(String deviceId, String processor) throws ManagementException {
        String sessionId = String.valueOf(System.currentTimeMillis());
        this.setSessionId(sessionId);
        this.deviceId = deviceId;
        this.state = "P";
        if (PROCESSOR_GENERIC.equals(processor)) {
            this.operation = PROCESSOR_GENERIC;
            this.genericProcessorTools.startNewManagementSession(deviceId, sessionId, processor);
        } else if (PROCESSOR_TREE_DISCOVERY.equals(processor)) {
            this.operation = PROCESSOR_TREE_DISCOVERY;
            this.treeDiscoveryProcessorTools.startNewManagementSession(deviceId, sessionId);
        } else if (PROCESSOR_GET_DEVICE_DETAILS.equals(processor)) {
            this.operation = PROCESSOR_GET_DEVICE_DETAILS;
            this.genericProcessorTools.startNewManagementSession(deviceId, sessionId, processor);
        } else {
            throw new ManagementException("Unknow Processor");
        }
    }

    public void loadSession(String sessionId) throws ManagementException {
        ResultSet rs;
        PreparedStatement pStmt;
        Connection con;
        block8: {
            if (log.isEnabledFor((Priority)Level.TRACE)) {
                log.trace((Object)("loadSession with sessionId: " + sessionId));
            }
            con = null;
            pStmt = null;
            rs = null;
            try {
                con = this.datasource.getConnection();
                pStmt = con.prepareStatement(SQL_SELECT_DM_STATE);
                pStmt.setObject(1, sessionId);
                rs = pStmt.executeQuery();
                while (rs.next()) {
                    this.deviceId = rs.getString("device");
                    this.state = rs.getString("state");
                    this.sessionId = sessionId;
                    this.operation = rs.getString("operation");
                }
                if (PROCESSOR_GENERIC.equals(this.operation) || PROCESSOR_GET_DEVICE_DETAILS.equals(this.operation)) {
                    this.genericProcessorTools.loadGenericSession(sessionId);
                    break block8;
                }
                if (PROCESSOR_TREE_DISCOVERY.equals(this.operation)) {
                    this.treeDiscoveryProcessorTools.loadTreeSession(sessionId);
                    break block8;
                }
                throw new ManagementException("Unknow processor");
            }
            catch (SQLException e) {
                try {
                    throw new ManagementException("Error reading the session operations", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBTools.close((Connection)con, pStmt, rs);
                    throw throwable;
                }
            }
        }
        DBTools.close((Connection)con, (Statement)pStmt, (ResultSet)rs);
    }

    public void registerNewUser(String name, String company, String job, String address, String city, String zip, String state, String country, String email, String phone, String deviceId) throws ManagementException {
        this.registrationTools.registerNewUser(name, company, job, address, city, zip, state, country, email, phone, deviceId);
    }

    public boolean loginUser(String deviceId, String password) throws ManagementException {
        if (this.registrationTools.loginUser(deviceId, password)) {
            this.deviceId = deviceId;
            this.password = password;
            this.userIsLogged = true;
            return true;
        }
        this.userIsLogged = false;
        return false;
    }

    public boolean checkIfUserAlreadyExists(String deviceId) throws ManagementException {
        return this.registrationTools.checkIfUserAlreadyExists(deviceId);
    }

    public boolean isUserLogged() {
        return this.userIsLogged;
    }

    public void saveSession() throws ManagementException {
        if (this.sessionId == null) {
            return;
        }
        int numUpdated = this.updateDMState();
        if (numUpdated == 0) {
            this.insertDMState();
        }
        if (PROCESSOR_GENERIC.equals(this.operation)) {
            this.genericProcessorTools.saveSession();
        } else if (PROCESSOR_TREE_DISCOVERY.equals(this.operation)) {
            this.treeDiscoveryProcessorTools.saveSession();
        } else if (PROCESSOR_GET_DEVICE_DETAILS.equals(this.operation)) {
            this.genericProcessorTools.saveSession();
        } else {
            throw new ManagementException("Unknow processor");
        }
    }

    public void deleteSessionToProcess() throws ManagementException {
        if (log.isEnabledFor((Priority)Level.TRACE)) {
            log.trace((Object)"deleteSession in state 'P'");
        }
        Connection con = null;
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        String sessionId = null;
        String operation = null;
        try {
            con = this.datasource.getConnection();
            pStmt = con.prepareStatement("SELECT id, device, state, operation, start_ts, end_ts FROM fnbl_dm_state  WHERE state='P'");
            rs = pStmt.executeQuery();
            while (rs.next()) {
                sessionId = rs.getString("id");
                operation = rs.getString("operation");
                this.setSessionId(sessionId);
                this.setOperation(operation);
                if (log.isEnabledFor((Priority)Level.TRACE)) {
                    log.trace((Object)("Delete session with id: " + sessionId));
                }
                this.deleteSession();
                if (PROCESSOR_GENERIC.equals(operation) || PROCESSOR_GET_DEVICE_DETAILS.equals(operation)) {
                    this.genericProcessorTools.deleteSession();
                    continue;
                }
                if (PROCESSOR_TREE_DISCOVERY.equals(operation)) {
                    this.treeDiscoveryProcessorTools.deleteSession();
                    continue;
                }
                throw new ManagementException("Unknow processor");
            }
        }
        catch (SQLException e) {
            try {
                throw new ManagementException("Error deleting the session", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)con, pStmt, rs);
                throw throwable;
            }
        }
        DBTools.close((Connection)con, (Statement)pStmt, (ResultSet)rs);
    }

    public void deleteSession() throws ManagementException {
        ResultSet rs;
        PreparedStatement pStmt;
        Connection con;
        block8: {
            if (log.isEnabledFor((Priority)Level.TRACE)) {
                log.trace((Object)("deleteSession with sessionId: " + this.sessionId));
            }
            if (this.sessionId == null) {
                return;
            }
            con = null;
            pStmt = null;
            rs = null;
            try {
                con = this.datasource.getConnection();
                pStmt = con.prepareStatement(SQL_DELETE_DM_STATE);
                pStmt.setObject(1, this.sessionId);
                pStmt.executeUpdate();
                if (PROCESSOR_GENERIC.equals(this.operation) || PROCESSOR_GET_DEVICE_DETAILS.equals(this.operation)) {
                    this.genericProcessorTools.deleteSession();
                    break block8;
                }
                if (PROCESSOR_TREE_DISCOVERY.equals(this.operation)) {
                    this.treeDiscoveryProcessorTools.deleteSession();
                    break block8;
                }
                throw new ManagementException("Unknow processor");
            }
            catch (SQLException e) {
                try {
                    throw new ManagementException("Error deleting the session", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBTools.close((Connection)con, pStmt, rs);
                    throw throwable;
                }
            }
        }
        DBTools.close((Connection)con, (Statement)pStmt, rs);
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
        this.genericProcessorTools.setSessionId(sessionId);
        this.treeDiscoveryProcessorTools.setSessionId(sessionId);
    }

    public String getSessionState() {
        return this.state;
    }

    public String getStateDescription() {
        if (this.state == null || this.state.equals("")) {
            return "Unknow";
        }
        if (this.state.equalsIgnoreCase("P")) {
            return "To process";
        }
        if (this.state.equalsIgnoreCase("C")) {
            return "Completed";
        }
        return "Unknow";
    }

    public String toString() {
        ToStringBuilder sb = new ToStringBuilder((Object)this);
        sb.append("sessionId", (Object)this.sessionId);
        sb.append("deviceId", (Object)this.deviceId);
        sb.append("state", (Object)this.state);
        sb.append("operation", (Object)this.operation);
        sb.append("genericProcessorTools", (Object)this.genericProcessorTools);
        sb.append("treeDiscoveryProcessorTools", (Object)this.treeDiscoveryProcessorTools);
        return sb.toString();
    }

    private DataSource lookupDataSource() {
        DataSource ds;
        block4: {
            if (log.isEnabledFor((Priority)Level.TRACE)) {
                log.trace((Object)"getDataSource: java:comp/env/jdbc/fnbldm");
            }
            ds = null;
            try {
                DataSource obj;
                InitialContext namingContext = new InitialContext();
                ds = obj = (DataSource)namingContext.lookup(JNDI_NAME);
                if (log.isEnabledFor((Priority)Level.TRACE)) {
                    log.trace((Object)("datasource: " + ds));
                }
            }
            catch (Exception e) {
                log.debug((Object)"lookupDataSource", (Throwable)e);
                if (!log.isEnabledFor((Priority)Level.FATAL)) break block4;
                log.fatal((Object)("Error getting the datasource: " + e.getMessage()));
            }
        }
        return ds;
    }

    private int updateDMState() throws ManagementException {
        if (log.isEnabledFor((Priority)Level.TRACE)) {
            log.trace((Object)("updateDMState with sessionId: " + this.sessionId));
        }
        Connection con = null;
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        int numUpdated = 0;
        try {
            con = this.datasource.getConnection();
            pStmt = con.prepareStatement(SQL_UPDATE_DM_STATE);
            pStmt.setObject(1, this.deviceId);
            pStmt.setObject(2, this.operation);
            pStmt.setObject(3, this.sessionId);
            numUpdated = pStmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new ManagementException("Error updating the session", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)con, pStmt, rs);
                throw throwable;
            }
        }
        DBTools.close((Connection)con, (Statement)pStmt, rs);
        return numUpdated;
    }

    private void insertDMState() throws ManagementException {
        if (log.isEnabledFor((Priority)Level.TRACE)) {
            log.trace((Object)("insertDMState with sessionId: " + this.sessionId));
        }
        if (this.sessionId == null) {
            return;
        }
        Connection con = null;
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        try {
            con = this.datasource.getConnection();
            pStmt = con.prepareStatement(SQL_INSERT_DM_STATE);
            pStmt.setObject(1, this.sessionId);
            pStmt.setObject(2, this.deviceId);
            pStmt.setObject(3, this.sessionId);
            pStmt.setObject(4, this.operation);
            pStmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new ManagementException("Error inserting the session", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)con, pStmt, rs);
                throw throwable;
            }
        }
        DBTools.close((Connection)con, (Statement)pStmt, rs);
    }
}

