/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.test.tools.ant;

import com.funambol.framework.tools.DBTools;
import com.funambol.framework.tools.IOTools;
import com.funambol.test.TestFailedException;
import com.funambol.test.tools.PostWBXMLSyncML;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PatternSet;

public class TestSyncMLWBXMLTask
extends Task {
    private AntClassLoader loader;
    protected String url = null;
    protected String test = null;
    protected String driver = null;
    protected String dburl = null;
    protected String userid = null;
    protected String password = null;
    protected String classpath = null;
    protected ArrayList<PatternSet> xpathPatterns = new ArrayList();

    public void setUrl(String url) {
        this.url = url;
    }

    public void setTest(String test) {
        this.test = test;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public void setDburl(String dburl) {
        this.dburl = dburl;
    }

    public void setUserid(String userid) {
        this.userid = userid;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setClasspath(String classpath) {
        this.classpath = classpath;
    }

    public void addPatternset(PatternSet set) {
        this.xpathPatterns.add(set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        Project p = this.getProject();
        this.validateAttributes();
        Connection conn = null;
        try {
            this.log("Getting db connection", 3);
            conn = this.getConnection();
        }
        catch (SQLException ex) {
            throw new BuildException("Error connecting to db", (Throwable)ex, this.getLocation());
        }
        ArrayList<String> allExcludeXPaths = new ArrayList<String>();
        PatternSet ps = null;
        String[] xpaths = null;
        for (int i = 0; i < this.xpathPatterns.size(); ++i) {
            ps = this.xpathPatterns.get(i);
            xpaths = ps.getExcludePatterns(p);
            for (int j = 0; j < xpaths.length; ++j) {
                allExcludeXPaths.add(xpaths[j]);
            }
        }
        this.log("Initial URL: " + this.url);
        this.log("Test: " + this.test);
        this.log("Ignored XPaths: " + allExcludeXPaths);
        xpaths = allExcludeXPaths.toArray(new String[0]);
        FilenameFilter filter = IOTools.getFileTypeFilter((String)"wbxml");
        String[] msgFiles = TestSyncMLWBXMLTask.ordersAndFilterFiles(new File(this.test).list(filter));
        try {
            new PostWBXMLSyncML(this.url, new File(p.getBaseDir(), this.test), msgFiles, xpaths, conn).syncAndTest();
            this.log("Test " + this.test + " passed!");
        }
        catch (IOException e) {
            this.log(e.getMessage(), 0);
            throw new BuildException("Error executing PostSyncMLTask", (Throwable)e);
        }
        catch (TestFailedException e) {
            this.log("Test " + this.test + " failed: " + e.getMessage(), 2);
        }
        finally {
            this.log("Closing db connection", 3);
            DBTools.close((Connection)conn, null, null);
        }
    }

    protected void validateAttributes() throws BuildException {
        try {
            new URL(this.url);
        }
        catch (Exception e) {
            new BuildException("Malformed url exception: " + this.url);
        }
    }

    protected Driver getDriver() throws BuildException {
        if (this.driver == null) {
            throw new BuildException("Driver attribute must be set", this.getLocation());
        }
        Driver driverInstance = null;
        try {
            Class dc;
            if (this.classpath != null) {
                if (this.loader == null) {
                    this.loader = new AntClassLoader(this.getProject(), new Path(this.getProject(), this.classpath));
                }
                dc = this.loader.loadClass(this.driver);
            } else {
                dc = Class.forName(this.driver);
            }
            driverInstance = (Driver)dc.newInstance();
        }
        catch (Exception e) {
            throw new BuildException("Error loading JDBC driver", (Throwable)e, this.getLocation());
        }
        return driverInstance;
    }

    protected static String[] ordersAndFilterFiles(String[] files) {
        int numFiles = files.length;
        TreeMap<Integer, String> map = new TreeMap<Integer, String>();
        String fileName = null;
        int index = -1;
        int numValidFiles = 0;
        for (int i = 0; i < numFiles; ++i) {
            fileName = files[i];
            index = TestSyncMLWBXMLTask.getIndexOfFile(fileName);
            if (index == -1) continue;
            ++numValidFiles;
            map.put(index, fileName);
        }
        String[] newFilesList = new String[numValidFiles];
        Iterator it = map.keySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            newFilesList[i++] = (String)map.get(it.next());
        }
        return newFilesList;
    }

    protected static int getIndexOfFile(String fileName) {
        int indexMsg = fileName.indexOf("msg");
        if (indexMsg == -1) {
            return -1;
        }
        int indexExtension = fileName.lastIndexOf(46);
        if (indexExtension == -1) {
            return -1;
        }
        int indexOfFile = -1;
        try {
            indexOfFile = Integer.parseInt(fileName.substring(3, indexExtension));
        }
        catch (NumberFormatException ex) {
            return -1;
        }
        return indexOfFile;
    }

    private Connection getConnection() throws SQLException {
        Connection conn = null;
        Driver driver = this.getDriver();
        Properties prop = new Properties();
        prop.setProperty("user", this.userid);
        prop.setProperty("password", this.password);
        conn = driver.connect(this.dburl, prop);
        return conn;
    }
}

