/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.test.tools;

import com.funambol.framework.core.RepresentationException;
import com.funambol.framework.core.Sync4jException;
import com.funambol.framework.core.SyncML;
import com.funambol.framework.tools.CommandIdGenerator;
import com.funambol.framework.tools.IOTools;
import com.funambol.framework.tools.WBXMLTools;
import com.funambol.test.TestFailedException;
import com.funambol.test.tools.HttpClientConnection;
import com.funambol.test.tools.PostSyncML;
import com.funambol.test.tools.SQLTools;
import com.funambol.test.tools.WBXMLConverter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.JDOMFactory;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.vmguys.vmtools.ota.OtaUpdate;
import org.vmguys.vmtools.ota.UniqueId;
import org.vmguys.vmtools.utils.DomFactory;

public class PostWBXMLSyncML {
    public static String LOG_NAME = "funambol.test.tools.PostSyncML";
    public static String FILE_ERROR = "error";
    public static String FILE_RESPONSE = "response";
    public static String FILE_REFERENCE = "reference";
    private CommandIdGenerator idGenerator = new CommandIdGenerator();
    private String nextURL = null;
    private byte[][] msgs = null;
    private String[] msgFiles = null;
    private String[] ignoreXPaths = null;
    private File baseDir = null;
    private File responseDir = null;
    private File referenceDir = null;
    private File errorDir = null;
    private Connection conn = null;
    private static final Logger log = Logger.getLogger((String)PostWBXMLSyncML.class.getName());

    public PostWBXMLSyncML(String initialURL, File baseDir, String[] msgFiles, String[] ignoreXPaths, Connection conn) throws IOException {
        if (msgFiles == null || msgFiles.length == 0) {
            this.msgs = new byte[0][];
        }
        this.msgs = new byte[msgFiles.length][];
        this.baseDir = baseDir;
        this.responseDir = new File(baseDir, FILE_RESPONSE);
        this.referenceDir = new File(baseDir, FILE_REFERENCE);
        this.errorDir = new File(baseDir, FILE_ERROR);
        this.msgFiles = msgFiles;
        for (int i = 0; i < msgFiles.length; ++i) {
            this.msgs[i] = IOTools.readFileBytes((File)new File(baseDir, msgFiles[i]));
        }
        this.ignoreXPaths = ignoreXPaths;
        this.nextURL = initialURL;
        this.conn = conn;
    }

    public void syncAndTest() throws IOException, TestFailedException {
        this.clean();
        SyncML response = null;
        String respURI = null;
        String referenceXML = null;
        File responseFile = null;
        String sqlScriptFileName = null;
        for (int i = 0; i < this.msgs.length; ++i) {
            if (this.conn != null) {
                sqlScriptFileName = this.checkForSQLScriptFile(this.msgFiles[i]);
                log.info((Object)("Executing file: " + sqlScriptFileName));
                if (sqlScriptFileName != null) {
                    try {
                        SQLTools.executeScript(this.conn, new File(this.baseDir, sqlScriptFileName));
                    }
                    catch (Exception ex) {
                        throw new TestFailedException("Error executing sql script file '" + sqlScriptFileName + "'", ex);
                    }
                }
            }
            log.info((Object)("Sending " + this.msgFiles[i]));
            try {
                response = this.postRequest(this.msgs[i]);
            }
            catch (Exception e) {
                IOTools.writeFile((String)e.getMessage(), (File)new File(this.errorDir, this.msgFiles[i]));
                throw new TestFailedException("XML syntax error: " + e.getMessage(), e);
            }
            responseFile = new File(this.responseDir, this.msgFiles[i]);
            log.info((Object)("Writing the response into " + responseFile));
            try {
                IOTools.writeFile((byte[])WBXMLTools.toWBXML((SyncML)response), (File)responseFile);
                referenceXML = WBXMLTools.wbxmlToXml((byte[])IOTools.readFileBytes((File)new File(this.referenceDir, this.msgFiles[i])));
                this.compare(this.msgFiles[i]);
            }
            catch (Sync4jException e) {
                IOTools.writeFile((String)e.getMessage(), (File)new File(this.errorDir, this.msgFiles[i]));
                throw new TestFailedException("WBXML error: " + e.getMessage(), e);
            }
            respURI = response.getSyncHdr().getRespURI();
            if (respURI == null) continue;
            this.nextURL = respURI;
        }
    }

    private SyncML postRequest(byte[] request) throws IOException, Sync4jException, RepresentationException {
        HttpClientConnection syncMLConnection = new HttpClientConnection(this.nextURL);
        return syncMLConnection.sendWBXMLMessage(request);
    }

    private void compare(String msgFile) throws IOException, Sync4jException, TestFailedException {
        File responseFile = new File(this.responseDir, msgFile);
        File referenceFile = new File(this.referenceDir, msgFile);
        String responseXml = WBXMLConverter.readWbxmlAsXml(responseFile);
        String referenceXml = WBXMLConverter.readWbxmlAsXml(referenceFile);
        StringReader responseReader = new StringReader(responseXml);
        StringReader referenceReader = new StringReader(referenceXml);
        SAXBuilder sb = new SAXBuilder();
        sb.setFactory((JDOMFactory)new DomFactory());
        try {
            Document response = sb.build((Reader)responseReader);
            Document reference = sb.build((Reader)referenceReader);
            OtaUpdate update = new OtaUpdate(false);
            UniqueId id = new UniqueId("SyncMLTest", msgFile);
            Element diffs = update.generateDiffs(response.getRootElement(), reference.getRootElement(), id);
            if (log.isEnabledFor((Priority)Level.TRACE)) {
                this.saveDiffs(diffs, new File(this.errorDir, msgFile + ".dbg"));
            }
            if (this.checkDiffs(diffs)) {
                this.saveDiffs(diffs, new File(this.errorDir, msgFile));
                throw new TestFailedException("Test failed on " + msgFile + ". Diff file saved in " + new File(this.errorDir, msgFile));
            }
        }
        catch (JDOMException e) {
            IOTools.writeFile((String)e.getMessage(), (File)new File(this.errorDir, msgFile));
            throw new TestFailedException("Test failed on " + msgFile + ": " + e.getMessage() + ". Error message saved in " + new File(this.errorDir, msgFile));
        }
    }

    private boolean checkDiffs(Element diffs) {
        List positions = diffs.getChildren("Position", diffs.getNamespace());
        Element position2 = null;
        for (Element position2 : positions) {
            if (this.ignore(position2.getAttributeValue("XPath"))) continue;
            return true;
        }
        return false;
    }

    private void clean() {
        int i;
        FilenameFilter filter = IOTools.getFileTypeFilter((String)"wbxml");
        String[] files = this.responseDir.list(filter);
        for (i = 0; files != null && i < files.length; ++i) {
            new File(files[i]).delete();
        }
        files = this.errorDir.list(filter);
        for (i = 0; files != null && i < files.length; ++i) {
            new File(files[i]).delete();
        }
    }

    private boolean ignore(String xPath) {
        for (int i = 0; xPath != null && this.ignoreXPaths != null && i < this.ignoreXPaths.length; ++i) {
            if (!xPath.equals(this.ignoreXPaths[i])) continue;
            return true;
        }
        return false;
    }

    private void saveDiffs(Element diffs, File file) throws IOException {
        XMLOutputter xmlo = new XMLOutputter("  ", true);
        xmlo.setTextNormalize(true);
        FileOutputStream fos = new FileOutputStream(file);
        xmlo.output(diffs, (OutputStream)fos);
        fos.close();
    }

    private static void syntax() {
        System.out.println("Syntax: " + PostSyncML.class + "<initial URL> <msg1> ... <msgN>");
    }

    private String checkForSQLScriptFile(String msg) {
        String sqlScriptFileName = null;
        int index = msg.lastIndexOf(46);
        sqlScriptFileName = index == -1 ? msg + ".sql" : msg.substring(0, index) + ".sql";
        File sqlFile = new File(this.baseDir, sqlScriptFileName);
        if (sqlFile.isFile()) {
            return sqlScriptFileName;
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            PostWBXMLSyncML.syntax();
        }
        String[] msgFiles = new String[args.length - 1];
        System.arraycopy(args, 1, msgFiles, 0, msgFiles.length);
        PostWBXMLSyncML postsyncml = new PostWBXMLSyncML(args[0], new File("."), msgFiles, new String[0], null);
        postsyncml.syncAndTest();
    }
}

