/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.framework.config;

import com.funambol.framework.config.ConfigurationException;
import com.funambol.framework.tools.beans.BeanFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class Configuration
implements Serializable {
    private final Map internalMap = Collections.synchronizedMap(new HashMap());
    private static Configuration singleton;
    private transient ClassLoader classLoader = null;

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    protected Configuration() {
    }

    public static synchronized Configuration getConfiguration() {
        if (singleton == null) {
            singleton = new Configuration();
        }
        return singleton;
    }

    public String getStringValue(String name, String def) throws ConfigurationException {
        String value = (String)this.internalMap.get(name);
        return value == null ? def : value;
    }

    public String getStringValue(String name) throws ConfigurationException {
        String value = (String)this.internalMap.get(name);
        if (value == null) {
            throw new ConfigurationException("No " + name + " property defined");
        }
        return value;
    }

    public String[] getStringArray(String name, char separator) throws ConfigurationException {
        String value = (String)this.internalMap.get(name);
        if (value == null) {
            throw new ConfigurationException("No " + name + " property defined");
        }
        return StringUtils.split((String)value, (String)String.valueOf(separator));
    }

    public int getIntValue(String name, int def) throws ConfigurationException {
        Integer value = (Integer)this.internalMap.get(name);
        return value == null ? def : value;
    }

    public int getIntValue(String name) throws ConfigurationException {
        Integer value = (Integer)this.internalMap.get(name);
        if (value == null) {
            throw new ConfigurationException("No " + name + " property defined");
        }
        return value;
    }

    public boolean getBoolValue(String name, boolean def) throws ConfigurationException {
        Boolean value = (Boolean)this.internalMap.get(name);
        return value == null ? def : value;
    }

    public boolean getBoolValue(String name) throws ConfigurationException {
        Boolean value = (Boolean)this.internalMap.get(name);
        if (value == null) {
            throw new ConfigurationException("No " + name + " property defined");
        }
        return value;
    }

    public Object getValue(String name, Object def) throws ConfigurationException {
        Object value = this.internalMap.get(name);
        return value == null ? def : value;
    }

    public Object getValue(String name) throws ConfigurationException {
        Object value = this.internalMap.get(name);
        if (value == null) {
            throw new ConfigurationException("No " + name + " property defined");
        }
        return value;
    }

    public Object getClassInstance(String name) throws ConfigurationException {
        String value = (String)this.internalMap.get(name);
        if (value == null) {
            throw new ConfigurationException("No " + name + " property defined");
        }
        try {
            return Class.forName(value).newInstance();
        }
        catch (Exception e) {
            throw new ConfigurationException("Error in creating an instance of " + value, e);
        }
    }

    public Object getBeanInstance(String name) throws ConfigurationException {
        String value = (String)this.internalMap.get(name);
        if (value == null) {
            throw new ConfigurationException("No " + name + " property defined");
        }
        try {
            return BeanFactory.getBeanInstance(this.classLoader, value);
        }
        catch (Exception e) {
            throw new ConfigurationException("Error in creating an instance of " + value, e);
        }
    }

    public Object[] getBeanArray(String name, char separator) throws ConfigurationException {
        int i;
        String[] values = this.getStringArray(name, separator);
        Object[] ret = new Object[values.length];
        try {
            for (i = 0; i < ret.length; ++i) {
                ret[i] = BeanFactory.getBeanInstance(this.classLoader, values[i]);
            }
        }
        catch (Exception e) {
            throw new ConfigurationException("Error in creating the bean " + values[i], e);
        }
        return ret;
    }

    public Object getBeanInstanceByName(String beanName) {
        try {
            return BeanFactory.getBeanInstance(this.classLoader, beanName);
        }
        catch (Exception e) {
            throw new ConfigurationException("Error in creating an instance of " + beanName, e);
        }
    }

    public synchronized void load(InputStream is) throws IOException {
        Properties properties = new Properties();
        properties.load(is);
        this.internalMap.putAll(properties);
    }

    public synchronized void load(String uri) throws IOException {
        this.load(new URL(uri).openStream());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName()).append(" - ");
        sb.append(this.internalMap.toString()).append(" - ");
        sb.append("classLoader: " + this.classLoader);
        return sb.toString();
    }
}

