/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.server.engine;

import com.funambol.framework.config.Configuration;
import com.funambol.framework.config.ConfigurationConstants;
import com.funambol.framework.core.Anchor;
import com.funambol.framework.core.CTCap;
import com.funambol.framework.core.ContentTypeInfo;
import com.funambol.framework.core.DSMem;
import com.funambol.framework.core.DataStore;
import com.funambol.framework.core.DevInf;
import com.funambol.framework.core.Ext;
import com.funambol.framework.core.ItemizedCommand;
import com.funambol.framework.core.ModificationCommand;
import com.funambol.framework.core.SourceRef;
import com.funambol.framework.core.Status;
import com.funambol.framework.core.Sync4jException;
import com.funambol.framework.core.SyncCap;
import com.funambol.framework.core.SyncType;
import com.funambol.framework.core.VerDTD;
import com.funambol.framework.database.Database;
import com.funambol.framework.engine.SyncEngine;
import com.funambol.framework.engine.SyncException;
import com.funambol.framework.engine.SyncItem;
import com.funambol.framework.engine.SyncOperation;
import com.funambol.framework.engine.SyncOperationStatus;
import com.funambol.framework.engine.SyncStrategy;
import com.funambol.framework.engine.source.SyncSource;
import com.funambol.framework.security.Sync4jPrincipal;
import com.funambol.framework.server.ClientMapping;
import com.funambol.framework.server.LastTimestamp;
import com.funambol.framework.server.SyncTimestamp;
import com.funambol.framework.server.store.NotFoundException;
import com.funambol.framework.server.store.PersistentStoreException;
import com.funambol.framework.tools.beans.BeanFactory;
import com.funambol.server.engine.EngineHelper;
import com.funambol.server.engine.Sync4jEngine;
import com.funambol.server.engine.Sync4jSource;
import java.io.Serializable;
import java.security.Principal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;

public class Sync4jSyncEngine
extends Sync4jEngine
implements Serializable,
SyncEngine,
ConfigurationConstants {
    private ArrayList<Object> serverSources = new ArrayList();
    private ArrayList<SyncSource> clientSources = new ArrayList();
    private Map operations = null;
    private SyncOperationStatus[] operationStatus = null;
    private SyncStrategy strategy = null;
    private Map<String, Database> dbs = new HashMap<String, Database>();
    private Map<String, ClientMapping> clientMappings = new HashMap<String, ClientMapping>();

    protected Sync4jSyncEngine() {
    }

    public Sync4jSyncEngine(Configuration configuration) {
        super(configuration);
        Sync4jSource[] sources = null;
        try {
            sources = (Sync4jSource[])this.store.read(Sync4jSource.class);
        }
        catch (PersistentStoreException e) {
            if (log.isEnabledFor((Priority)Level.FATAL)) {
                log.fatal((Object)("Error reading registered sources: " + e.getMessage()));
            }
            log.debug((Object)"<init>", (Throwable)e);
        }
        for (int i = 0; sources != null && i < sources.length; ++i) {
            if (log.isEnabledFor((Priority)Level.TRACE)) {
                log.trace((Object)("sources[" + i + "]: " + sources[i]));
            }
            try {
                this.serverSources.add(BeanFactory.getBeanInstance((ClassLoader)configuration.getClassLoader(), (String)sources[i].getConfig()));
                continue;
            }
            catch (Exception e) {
                String msg = "Unable to create sync source " + sources[i] + ": " + e.getMessage();
                if (log.isEnabledFor((Priority)Level.FATAL)) {
                    log.fatal((Object)msg);
                }
                log.debug((Object)"<init>", (Throwable)e);
            }
        }
        SyncStrategy strategy = (SyncStrategy)configuration.getClassInstance("engine.strategy");
        this.setStrategy(strategy);
        if (log.isEnabledFor((Priority)Level.INFO)) {
            log.info((Object)"Engine configuration:");
            log.info((Object)("store: " + this.store));
            log.info((Object)("officer: " + this.officer));
            log.info((Object)("strategy: " + strategy));
        }
    }

    public SyncStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(SyncStrategy strategy) {
        this.strategy = strategy;
    }

    public void setDbs(Map<String, Database> dbs) {
        if (this.dbs != null) {
            this.dbs.clear();
        } else {
            this.dbs = new HashMap<String, Database>(dbs.size());
        }
        this.dbs.putAll(dbs);
    }

    public void setDbs(Database[] dbs) {
        if (this.dbs == null) {
            this.dbs = new HashMap<String, Database>(dbs.length);
        }
        for (int i = 0; dbs != null && i < dbs.length; ++i) {
            this.dbs.put(dbs[i].getName(), dbs[i]);
        }
    }

    public Database[] getDbs() {
        if (this.dbs == null) {
            return new Database[0];
        }
        Iterator<Database> i = this.dbs.values().iterator();
        Database[] ret = new Database[this.dbs.size()];
        int j = 0;
        while (i.hasNext()) {
            ret[j++] = i.next();
        }
        return ret;
    }

    public void setClientMappings(Map<String, ClientMapping> clientMappings) {
        this.clientMappings = clientMappings;
    }

    public void sync(Sync4jPrincipal principal) throws Sync4jException {
        log.info((Object)"Starting synchronization ...");
        SyncStrategy syncStrategy = this.getStrategy();
        SyncSource clientSource22 = null;
        Object var4_4 = null;
        Database db = null;
        ArrayList<SyncOperationStatus> status = new ArrayList<SyncOperationStatus>();
        HashMap<String, SyncSource> sourceMap = new HashMap<String, SyncSource>(this.serverSources.size());
        for (SyncSource syncSource : this.serverSources) {
            sourceMap.put(syncSource.getSourceURI(), syncSource);
        }
        this.operations = new HashMap();
        String uri = null;
        for (SyncSource clientSource22 : this.clientSources) {
            uri = clientSource22.getSourceURI();
            SyncSource syncSource = (SyncSource)sourceMap.get(uri);
            db = this.dbs.get(clientSource22.getSourceURI());
            SyncSource[] sources = new SyncSource[]{syncSource, clientSource22};
            try {
                Sync4jPrincipal p = (Sync4jPrincipal)db.getPrincipal();
                p.setId(principal.getId());
                syncSource.beginSync((Principal)p, db.getMethod());
                if (db.getMethod() == 201 || db.getMethod() == 205 || db.getStatusCode() == 508) {
                    this.operations.put(uri, syncStrategy.prepareSlowSync(sources, (Principal)p));
                } else {
                    LastTimestamp last = new LastTimestamp(p.getId(), db.getName());
                    try {
                        this.store.read((Object)last);
                    }
                    catch (PersistentStoreException e) {
                        throw new SyncException("Error reading last timestamp", (Throwable)e);
                    }
                    Timestamp since = new Timestamp(last.start);
                    this.operations.put(uri, syncStrategy.prepareFastSync(sources, (Principal)p, since));
                }
                if (db.getStatusCode() == 508) {
                    db.setStatusCode(200);
                }
                status.addAll(Arrays.asList(syncStrategy.sync((SyncOperation[])this.operations.get(uri))));
                this.operationStatus = status.toArray(new SyncOperationStatus[0]);
                syncSource.endSync((Principal)p);
                log.info((Object)"Ending synchronization ...");
                syncStrategy.endSync();
            }
            catch (SyncException e) {
                log.debug((Object)"sync", (Throwable)e);
                throw new Sync4jException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public SyncOperation[] getSyncOperations(String uri) {
        return (SyncOperation[])this.operations.get(uri);
    }

    public Status[] getModificationsStatusCommands(String msgId) {
        if (this.operationStatus == null || this.operationStatus.length == 0) {
            return new Status[0];
        }
        return EngineHelper.generateStatusCommands(this.operationStatus, msgId, this.cmdIdGenerator);
    }

    public void addClientSource(SyncSource source) {
        if (log.isEnabledFor((Priority)Level.TRACE)) {
            log.trace((Object)("adding " + source));
        }
        this.clientSources.add(source);
    }

    public List<SyncSource> getClientSources() {
        return this.clientSources;
    }

    public SyncSource getClientSource(String name) {
        Iterator<SyncSource> i = this.clientSources.iterator();
        SyncSource s = null;
        while (i.hasNext()) {
            s = i.next();
            if (!s.getSourceURI().equals(name)) continue;
            return s;
        }
        return null;
    }

    public SyncSource getServerSource(String name) {
        Iterator<Object> i = this.serverSources.iterator();
        SyncSource s = null;
        while (i.hasNext()) {
            s = (SyncSource)i.next();
            if (!s.getSourceURI().equals(name)) continue;
            return s;
        }
        return null;
    }

    public DataStore databaseToDataStore(Database db) {
        ContentTypeInfo contentTypeInfo = new ContentTypeInfo(db.getType(), "-");
        return new DataStore(new SourceRef(db.getSource()), null, -1L, contentTypeInfo, new ContentTypeInfo[]{contentTypeInfo}, contentTypeInfo, new ContentTypeInfo[]{contentTypeInfo}, new DSMem(false, -1L, -1L), new SyncCap(new SyncType[]{SyncType.SLOW}));
    }

    public CTCap[] getContentTypeCapabilities() {
        return new CTCap[0];
    }

    public Ext[] getExtensions() {
        return new Ext[0];
    }

    public DataStore[] getDatastores() {
        DataStore[] ds = null;
        ArrayList<DataStore> al = new ArrayList<DataStore>();
        Database db2 = null;
        String uri = null;
        for (Database db2 : this.dbs.values()) {
            uri = db2.getName();
            SyncSource ss = this.getServerSource(uri);
            if (ss == null) continue;
            al.add(EngineHelper.toDataStore(uri, ss.getInfo()));
        }
        int size = al.size();
        ds = size == 0 ? new DataStore[]{} : al.toArray(new DataStore[size]);
        return ds;
    }

    public DevInf getServerCapabilities(VerDTD verDTD) {
        DevInf devInf = new DevInf(verDTD, this.configuration.getStringValue("engine.manifacturer", "Funambol"), this.configuration.getStringValue("engine.modelname", "Funambol"), this.configuration.getStringValue("engine.oem", null), this.configuration.getStringValue("engine.firmwareversion", null), this.configuration.getStringValue("engine.softwareversion", null), this.configuration.getStringValue("engine.hardwareversion", null), this.configuration.getStringValue("engine.deviceid", "Funambol"), this.configuration.getStringValue("engine.devicetype", "Server"), this.getDatastores(), this.getContentTypeCapabilities(), this.getExtensions(), false, false, false);
        return devInf;
    }

    public void prepareDatabases(Sync4jPrincipal principal, Database[] dbs, SyncTimestamp next) {
        for (int i = 0; dbs != null && i < dbs.length; ++i) {
            int statusCode = 200;
            if (!this.checkServerDatabase(dbs[i])) {
                statusCode = 404;
            } else if (!this.checkDatabasePermissions(dbs[i])) {
                statusCode = 403;
            }
            dbs[i].setStatusCode(statusCode);
            if (statusCode != 200) continue;
            LastTimestamp last = new LastTimestamp(principal.getId(), dbs[i].getName());
            try {
                this.store.read((Object)last);
                dbs[i].setServerAnchor(new Anchor(last.tagClient, next.tagClient));
            }
            catch (NotFoundException e) {
                last.tagServer = next.tagClient;
                dbs[i].setServerAnchor(new Anchor(last.tagServer, next.tagClient));
            }
            catch (PersistentStoreException e) {
                if (log.isEnabledFor((Priority)Level.FATAL)) {
                    log.fatal((Object)"Unable to retrieve timestamp from store");
                }
                log.debug((Object)"prepareDatabases", (Throwable)e);
            }
            if (last.tagServer.equals(dbs[i].getAnchor().getLast()) || dbs[i].getMethod() == 205) continue;
            if (log.isEnabledFor((Priority)Level.TRACE)) {
                log.trace((Object)("Forcing slow sync for database " + dbs[i].getName()));
                log.trace((Object)("Server last: " + last.tagServer + "; client last: " + dbs[i].getAnchor().getLast()));
            }
            dbs[i].setMethod(201);
        }
    }

    public ItemizedCommand[] operationsToCommands(ClientMapping clientMapping, SyncOperation[] operations, String sourceName) {
        return EngineHelper.operationsToCommands(clientMapping, operations, sourceName, this.cmdIdGenerator);
    }

    public void updateClientMappings(Map<String, ClientMapping> clientMappings, SyncOperation[] operations, boolean slowSync) {
        try {
            EngineHelper.updateClientMappings(clientMappings, operations, slowSync);
        }
        catch (Exception e) {
            log.debug((Object)"updateClientMappings", (Throwable)e);
        }
    }

    public void updateServerMappings(Map<String, ClientMapping> clientMappings, boolean slowSync) {
        try {
            EngineHelper.updateServerMappings(clientMappings, this.operationStatus, slowSync);
        }
        catch (Exception e) {
            log.debug((Object)"updateServerMappings", (Throwable)e);
        }
    }

    public static SyncItem[] itemsToSyncItems(ClientMapping clientMapping, SyncSource syncSource, ModificationCommand cmd, char state, long timestamp) {
        return EngineHelper.itemsToSyncItems(clientMapping, syncSource, cmd, state, timestamp);
    }

    private boolean checkServerDatabase(Database db) {
        if (log.isEnabledFor((Priority)Level.TRACE)) {
            log.trace((Object)("Checking if the database " + db + " is in the server database list " + this.serverSources));
        }
        Object var2_2 = null;
        for (SyncSource syncSource : this.serverSources) {
            if (!db.getName().equals(syncSource.getSourceURI())) continue;
            if (log.isEnabledFor((Priority)Level.TRACE)) {
                log.trace((Object)"Yes sir!");
            }
            return true;
        }
        if (log.isEnabledFor((Priority)Level.TRACE)) {
            log.trace((Object)"Not found sir");
        }
        return false;
    }

    private boolean checkDatabasePermissions(Database db) {
        return this.authorize(db.getPrincipal(), db.getName());
    }
}

