/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.server.engine;

import com.funambol.framework.core.Add;
import com.funambol.framework.core.ModificationCommand;
import com.funambol.framework.engine.SyncConflict;
import com.funambol.framework.engine.SyncException;
import com.funambol.framework.engine.SyncItem;
import com.funambol.framework.engine.SyncItemImpl;
import com.funambol.framework.engine.SyncItemMapping;
import com.funambol.framework.engine.SyncOperation;
import com.funambol.framework.engine.SyncOperationImpl;
import com.funambol.framework.engine.SyncOperationStatus;
import com.funambol.framework.engine.SyncStrategy;
import com.funambol.framework.engine.Util;
import com.funambol.framework.engine.source.SyncSource;
import com.funambol.framework.engine.source.SyncSourceException;
import com.funambol.server.engine.EngineHelper;
import com.funambol.server.engine.Sync4jOperationStatusConflict;
import com.funambol.server.engine.Sync4jOperationStatusError;
import com.funambol.server.engine.Sync4jOperationStatusOK;
import com.funambol.server.engine.SyncItemHelper;
import java.io.Serializable;
import java.security.Principal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections15.ListUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Sync4jStrategy
implements SyncStrategy,
Serializable {
    public static String LOG_NAME = "funambol.framework.engine";
    private static final transient Logger log = Logger.getLogger((String)Sync4jStrategy.class.getName());
    private transient SyncSource[] sources = null;
    private String name;

    public SyncSource[] getSources() {
        return this.sources;
    }

    public void setSources(SyncSource[] sources) {
        this.sources = sources;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Sync4jStrategy() {
    }

    public Sync4jStrategy(SyncSource[] syncSources) {
        this.sources = syncSources;
    }

    public SyncOperation[] prepareSlowSync(SyncSource[] sources, Principal principal) throws SyncException {
        SyncItem[] allA = null;
        SyncItem[] allB = null;
        if (sources != null) {
            this.sources = sources;
        }
        ArrayList<Object> syncOperations = null;
        ArrayList<Object> Am = new ArrayList<Object>();
        ArrayList<Object> Bm = new ArrayList<Object>();
        List<Object> AmBm = null;
        if (log.isEnabledFor((Priority)Level.INFO)) {
            log.info((Object)("Preparing slow synchronization for " + principal + " ..."));
        }
        allA = sources[1].getAllSyncItems(principal);
        allB = sources[0].getAllSyncItems(principal);
        EngineHelper.resetState(Arrays.asList(allA));
        EngineHelper.resetState(Arrays.asList(allB));
        ArrayList<SyncItemMapping> newlyMappedItems = new ArrayList<SyncItemMapping>();
        this.fixMappedItems(newlyMappedItems, allA, sources[0], principal, true);
        Am.addAll(Arrays.asList(allA));
        Bm.addAll(Arrays.asList(allB));
        AmBm = EngineHelper.intersect(Am, Bm);
        if (log.isEnabledFor((Priority)Level.TRACE)) {
            log.trace((Object)("Am: " + Am));
            log.trace((Object)("Bm: " + Bm));
            log.trace((Object)("AmBm: " + AmBm));
        }
        syncOperations = this.checkSyncOperations(principal, Am, Bm, AmBm, new ArrayList<Object>(), new ArrayList<Object>());
        Object var10_10 = null;
        ArrayList<SyncOperation> ret = new ArrayList<SyncOperation>();
        for (SyncOperation syncOperation : syncOperations) {
            if (syncOperation.getOperation() == 'D') continue;
            ret.add(syncOperation);
        }
        if (log.isEnabledFor((Priority)Level.TRACE)) {
            log.trace((Object)("operations: " + ret));
        }
        log.info((Object)"Preparation completed.");
        return (SyncOperation[])ret.toArray(new SyncOperationImpl[0]);
    }

    public SyncOperation[] prepareFastSync(SyncSource[] sources, Principal principal, Timestamp since) throws SyncException {
        if (sources != null) {
            this.sources = sources;
        }
        ArrayList<Object> syncOperations = null;
        Object[] newA = null;
        Object[] newB = null;
        Object[] updatedA = null;
        Object[] updatedB = null;
        Object[] deletedA = null;
        Object[] deletedB = null;
        if (log.isEnabledFor((Priority)Level.INFO)) {
            log.info((Object)("Preparing fast synchronization for " + principal + " since " + since));
        }
        newA = sources[1].getNewSyncItems(principal, since);
        updatedA = sources[1].getUpdatedSyncItems(principal, since);
        deletedA = sources[1].getDeletedSyncItems(principal, since);
        newB = sources[0].getNewSyncItems(principal, since);
        updatedB = sources[0].getUpdatedSyncItems(principal, since);
        deletedB = sources[0].getDeletedSyncItems(principal, since);
        if (log.isEnabledFor((Priority)Level.TRACE)) {
            log.trace((Object)("newA: " + Util.arrayToString((Object[])newA)));
            log.trace((Object)("newB: " + Util.arrayToString((Object[])newB)));
            log.trace((Object)("updatedA: " + Util.arrayToString((Object[])updatedA)));
            log.trace((Object)("updatedB: " + Util.arrayToString((Object[])updatedB)));
            log.trace((Object)("deletedA: " + Util.arrayToString((Object[])deletedA)));
            log.trace((Object)("deletedB: " + Util.arrayToString((Object[])deletedB)));
        }
        ArrayList<SyncItemMapping> newlyMappedItems = new ArrayList<SyncItemMapping>();
        this.fixMappedItems(newlyMappedItems, (SyncItem[])newA, sources[0], principal, false);
        this.fixMappedItems(newlyMappedItems, (SyncItem[])updatedA, sources[0], principal, false);
        this.fixMappedItems(newlyMappedItems, (SyncItem[])deletedA, sources[0], principal, false);
        if (log.isEnabledFor((Priority)Level.TRACE)) {
            log.trace((Object)("Newly mapped items: " + newlyMappedItems));
        }
        ArrayList<Object> Am = new ArrayList<Object>();
        ArrayList<Object> Bm = new ArrayList<Object>();
        Am.addAll(Arrays.asList(newA));
        Am.addAll(Arrays.asList(updatedA));
        Am.addAll(Arrays.asList(deletedA));
        Bm.addAll(Arrays.asList(newB));
        Bm.addAll(Arrays.asList(updatedB));
        Bm.addAll(Arrays.asList(deletedB));
        if (log.isEnabledFor((Priority)Level.TRACE)) {
            log.trace((Object)("Am: " + Am));
            log.trace((Object)("Bm: " + Bm));
            log.trace((Object)("Am-Bm: " + ListUtils.subtract(Am, Bm)));
            log.trace((Object)("Bm-Am: " + ListUtils.subtract(Bm, Am)));
        }
        List<Object> AmBm = EngineHelper.intersect(Am, Bm);
        List<Object> AmBBm = EngineHelper.buildAmBBm(ListUtils.subtract(Am, Bm), sources[0], principal);
        List<Object> AAmBm = EngineHelper.buildAAmBm(ListUtils.subtract(Bm, Am), sources[1], principal);
        if (log.isEnabledFor((Priority)Level.TRACE)) {
            log.trace((Object)("AmBm:  " + AmBm));
            log.trace((Object)("AmBBm: " + AmBBm));
            log.trace((Object)("AAmBm: " + AAmBm));
        }
        syncOperations = this.checkSyncOperations(principal, Am, Bm, AmBm, AmBBm, AAmBm);
        if (log.isEnabledFor((Priority)Level.TRACE)) {
            log.trace((Object)("operations: " + syncOperations));
        }
        log.info((Object)"Preparation completed.");
        return (SyncOperation[])syncOperations.toArray(new SyncOperationImpl[0]);
    }

    public SyncOperationStatus[] sync(SyncOperation[] syncOperations) {
        log.info((Object)"Synchronizing...");
        if (syncOperations == null || syncOperations.length == 0) {
            return new SyncOperationStatus[0];
        }
        ArrayList<SyncOperationStatus> status = new ArrayList<SyncOperationStatus>();
        SyncOperationStatus[] operationStatus = null;
        for (int i = 0; i < syncOperations.length; ++i) {
            if (log.isEnabledFor((Priority)Level.TRACE)) {
                log.trace((Object)("Executing " + syncOperations[i]));
            }
            operationStatus = this.execSyncOperation((SyncOperationImpl)syncOperations[i]);
            for (int j = 0; j < operationStatus.length; ++j) {
                status.add(operationStatus[j]);
            }
        }
        log.info((Object)"Synchronization completed.");
        if (log.isEnabledFor((Priority)Level.TRACE)) {
            log.trace((Object)("status: " + status));
        }
        return status.toArray(new SyncOperationStatus[0]);
    }

    public void endSync() throws SyncException {
        log.info((Object)"Ending synchronization...");
        log.info((Object)"Synchronization ended.");
    }

    protected ArrayList<Object> checkSyncOperations(Principal principal, List<Object> Am, List<Object> Bm, List<Object> AmBm, List<Object> AmBBm, List<Object> AAmBm) {
        Object var7_7 = null;
        Object var8_10 = null;
        Object var9_15 = null;
        ArrayList<Object> all = new ArrayList<Object>();
        ArrayList<Object> operations = new ArrayList<Object>();
        all.addAll(AmBm);
        all.addAll(AmBBm);
        all.addAll(AAmBm);
        for (SyncItemMapping syncItemMapping : all) {
            SyncItem syncItem = syncItemMapping.getSyncItemA();
            SyncItem syncItem2 = syncItemMapping.getSyncItemB();
            operations.add(this.checkSyncOperation(principal, syncItem, syncItem2));
            Am.remove(syncItem);
            Bm.remove(syncItem2);
        }
        for (SyncItem syncItem : Am) {
            operations.add(this.checkSyncOperation(principal, syncItem, null));
        }
        for (SyncItem syncItem : Bm) {
            operations.add(this.checkSyncOperation(principal, null, syncItem));
        }
        return operations;
    }

    protected SyncOperation checkSyncOperation(Principal principal, SyncItem syncItemA, SyncItem syncItemB) {
        if (log.isEnabledFor((Priority)Level.TRACE)) {
            log.trace((Object)("check: syncItemA: " + syncItemA + " syncItemB: " + syncItemB));
        }
        if (syncItemA == null) {
            syncItemA = SyncItemImpl.getNotExistingSyncItem(null);
        }
        if (syncItemB == null) {
            syncItemB = SyncItemImpl.getNotExistingSyncItem(null);
        }
        switch (syncItemA.getState()) {
            case 'N': {
                switch (syncItemB.getState()) {
                    case 'N': {
                        return new SyncConflict(syncItemA, syncItemB, String.valueOf('N') + String.valueOf('N'));
                    }
                    case 'U': {
                        return new SyncConflict(syncItemA, syncItemB, String.valueOf('N') + String.valueOf('U'));
                    }
                    case 'D': {
                        return new SyncConflict(syncItemA, syncItemB, String.valueOf('N') + String.valueOf('D'));
                    }
                    case 'S': {
                        return new SyncConflict(syncItemA, syncItemB, String.valueOf('N') + String.valueOf('S'));
                    }
                    case 'X': {
                        return new SyncOperationImpl(principal, syncItemA, syncItemB, 'N', false, true);
                    }
                }
            }
            case 'D': {
                switch (syncItemB.getState()) {
                    case 'N': {
                        return new SyncConflict(syncItemA, syncItemB, String.valueOf('D') + String.valueOf('N'));
                    }
                    case 'U': {
                        return new SyncConflict(syncItemA, syncItemB, String.valueOf('D') + String.valueOf('U'));
                    }
                    case 'S': {
                        return new SyncOperationImpl(principal, syncItemA, syncItemB, 'D', false, true);
                    }
                    case 'D': 
                    case 'X': {
                        return new SyncOperationImpl(principal, syncItemB, syncItemA, '-', false, false);
                    }
                }
            }
            case 'U': {
                switch (syncItemB.getState()) {
                    case 'N': {
                        return new SyncConflict(syncItemA, syncItemB, String.valueOf('U') + String.valueOf('N'));
                    }
                    case 'U': {
                        return new SyncConflict(syncItemA, syncItemB, String.valueOf('U') + String.valueOf('U'));
                    }
                    case 'D': {
                        return new SyncConflict(syncItemA, syncItemB, String.valueOf('U') + String.valueOf('D'));
                    }
                    case 'S': {
                        return new SyncOperationImpl(principal, syncItemA, syncItemB, 'U', false, true);
                    }
                    case 'X': {
                        return new SyncOperationImpl(principal, syncItemA, syncItemB, 'N', false, true);
                    }
                }
            }
            case 'S': {
                switch (syncItemB.getState()) {
                    case 'N': {
                        return new SyncConflict(syncItemA, syncItemB, String.valueOf('S') + String.valueOf('N'));
                    }
                    case 'U': {
                        return new SyncOperationImpl(principal, syncItemA, syncItemB, 'U', true, false);
                    }
                    case 'D': {
                        return new SyncOperationImpl(principal, syncItemA, syncItemB, 'D', true, false);
                    }
                    case 'S': {
                        return new SyncOperationImpl(principal, syncItemA, syncItemB, '-', false, false);
                    }
                    case 'X': {
                        return new SyncOperationImpl(principal, syncItemA, syncItemB, 'N', false, true);
                    }
                }
            }
            case 'X': {
                switch (syncItemB.getState()) {
                    case 'N': 
                    case 'U': {
                        return new SyncOperationImpl(principal, syncItemA, syncItemB, 'N', true, false);
                    }
                    case 'S': {
                        return new SyncOperationImpl(principal, syncItemA, syncItemB, 'N', true, false);
                    }
                    case 'D': 
                    case 'X': {
                        return new SyncOperationImpl(principal, syncItemA, syncItemB, '-', false, false);
                    }
                }
            }
            case 'C': {
                return new SyncConflict(syncItemA, syncItemB, "CX");
            }
        }
        return new SyncOperationImpl(principal, syncItemA, syncItemB, '-', false, false);
    }

    protected SyncOperationStatus[] execSyncOperation(SyncOperationImpl operation) {
        SyncItem syncItemA = operation.getSyncItemA();
        SyncItem syncItemB = operation.getSyncItemB();
        Principal owner = operation.getOwner();
        SyncOperationStatus[] status = null;
        ModificationCommand cmd = null;
        int size = 0;
        int s = 0;
        switch (operation.getOperation()) {
            case 'N': {
                status = new SyncOperationStatus[1];
                if (operation.isAOperation()) {
                    cmd = (ModificationCommand)syncItemA.getPropertyValue("SYNCML_COMMAND");
                    try {
                        syncItemA = this.sources[1].setSyncItem(owner, syncItemB);
                        operation.setSyncItemA(syncItemA);
                        status[0] = new Sync4jOperationStatusOK((SyncOperation)operation, this.sources[1], cmd, 201);
                    }
                    catch (SyncException e) {
                        if (log.isEnabledFor((Priority)Level.FATAL)) {
                            log.fatal((Object)("Error executing sync operation: " + e.getMessage()));
                        }
                        log.debug((Object)"execSyncOperation", (Throwable)e);
                        status[0] = new Sync4jOperationStatusError((SyncOperation)operation, this.sources[1], cmd, e);
                    }
                    break;
                }
                if (!operation.isBOperation()) break;
                cmd = (ModificationCommand)syncItemA.getPropertyValue("SYNCML_COMMAND");
                syncItemB.setProperty(syncItemA.getProperty("TIMESTAMP"));
                try {
                    syncItemB = this.sources[0].setSyncItem(owner, syncItemA);
                    operation.setSyncItemB(syncItemB);
                    status[0] = new Sync4jOperationStatusOK((SyncOperation)operation, this.sources[1], cmd, 201);
                }
                catch (SyncException e) {
                    if (log.isEnabledFor((Priority)Level.FATAL)) {
                        log.fatal((Object)("Error executing sync operation: " + e.getMessage()));
                    }
                    log.debug((Object)"execSyncOperation", (Throwable)e);
                    status[0] = new Sync4jOperationStatusError((SyncOperation)operation, this.sources[0], cmd, e);
                }
                break;
            }
            case 'U': {
                status = new SyncOperationStatus[1];
                if (operation.isAOperation()) {
                    cmd = (ModificationCommand)syncItemA.getPropertyValue("SYNCML_COMMAND");
                    try {
                        syncItemA = this.sources[1].setSyncItem(owner, syncItemB);
                        operation.setSyncItemA(syncItemA);
                        status[0] = new Sync4jOperationStatusOK((SyncOperation)operation, this.sources[1], cmd);
                    }
                    catch (SyncException e) {
                        if (log.isEnabledFor((Priority)Level.FATAL)) {
                            log.fatal((Object)("Error executing sync operation: " + e.getMessage()));
                        }
                        log.debug((Object)"execSyncOperation", (Throwable)e);
                        status[0] = new Sync4jOperationStatusError((SyncOperation)operation, this.sources[1], cmd, e);
                    }
                    break;
                }
                if (!operation.isBOperation()) break;
                cmd = (ModificationCommand)syncItemA.getPropertyValue("SYNCML_COMMAND");
                syncItemB.setProperty(syncItemA.getProperty("TIMESTAMP"));
                try {
                    syncItemB = this.sources[0].setSyncItem(owner, syncItemA);
                    operation.setSyncItemB(syncItemB);
                    status[0] = new Sync4jOperationStatusOK((SyncOperation)operation, this.sources[0], cmd);
                }
                catch (SyncException e) {
                    if (log.isEnabledFor((Priority)Level.FATAL)) {
                        log.fatal((Object)("Error executing sync operation: " + e.getMessage()));
                    }
                    log.debug((Object)"execSyncOperation", (Throwable)e);
                    status[0] = new Sync4jOperationStatusError((SyncOperation)operation, this.sources[0], cmd, e);
                }
                break;
            }
            case 'D': {
                size = 1;
                if (operation.isAOperation() && operation.isBOperation()) {
                    size = 2;
                }
                status = new SyncOperationStatus[size];
                s = 0;
                if (operation.isBOperation()) {
                    cmd = (ModificationCommand)syncItemA.getPropertyValue("SYNCML_COMMAND");
                    syncItemB.setProperty(syncItemA.getProperty("TIMESTAMP"));
                    try {
                        this.sources[0].removeSyncItem(owner, syncItemB);
                        status[s++] = new Sync4jOperationStatusOK((SyncOperation)operation, this.sources[0], cmd);
                    }
                    catch (SyncException e) {
                        if (log.isEnabledFor((Priority)Level.FATAL)) {
                            log.fatal((Object)("Error executing sync operation: " + e.getMessage()));
                        }
                        log.debug((Object)"execSyncOperation", (Throwable)e);
                        status[s++] = new Sync4jOperationStatusError((SyncOperation)operation, this.sources[0], cmd, e);
                    }
                }
                if (!operation.isAOperation()) break;
                cmd = (ModificationCommand)syncItemA.getPropertyValue("SYNCML_COMMAND");
                try {
                    this.sources[1].removeSyncItem(owner, syncItemA);
                    status[s++] = new Sync4jOperationStatusOK((SyncOperation)operation, this.sources[1], cmd);
                }
                catch (SyncException e) {
                    if (log.isEnabledFor((Priority)Level.FATAL)) {
                        log.fatal((Object)("Error executing sync operation: " + e.getMessage()));
                    }
                    log.debug((Object)"execSyncOperation", (Throwable)e);
                    status[s++] = new Sync4jOperationStatusError((SyncOperation)operation, this.sources[1], cmd, e);
                }
                break;
            }
            case '-': {
                s = 0;
                if (operation.isAOperation()) {
                    ++s;
                }
                if (operation.isBOperation()) {
                    ++s;
                }
                status = new SyncOperationStatus[size];
                if (operation.isBOperation()) {
                    cmd = (ModificationCommand)syncItemA.getPropertyValue("SYNCML_COMMAND");
                    status[s++] = new Sync4jOperationStatusOK((SyncOperation)operation, this.sources[0], cmd);
                }
                if (operation.isAOperation()) {
                    cmd = (ModificationCommand)syncItemA.getPropertyValue("SYNCML_COMMAND");
                    status[s++] = new Sync4jOperationStatusOK((SyncOperation)operation, this.sources[1], cmd);
                }
                if (operation.isAOperation() || operation.isBOperation()) break;
                char stateItemA = syncItemA.getState();
                char stateItemB = syncItemB.getState();
                switch (stateItemA) {
                    case 'S': {
                        if (stateItemB == 'S') {
                            status = new SyncOperationStatus[1];
                            cmd = (ModificationCommand)syncItemA.getPropertyValue("SYNCML_COMMAND");
                            if (cmd instanceof Add) {
                                status[0] = new Sync4jOperationStatusOK((SyncOperation)operation, this.sources[1], cmd, 201);
                                break;
                            }
                            status[0] = new Sync4jOperationStatusOK((SyncOperation)operation, this.sources[1], cmd);
                            break;
                        }
                    }
                    case 'X': {
                        if (stateItemB == 'D') {
                            try {
                                cmd = (ModificationCommand)syncItemB.getPropertyValue("SYNCML_COMMAND");
                                syncItemA = this.sources[1].setSyncItem(owner, syncItemB);
                                operation.setSyncItemA(syncItemA);
                                status = new SyncOperationStatus[]{new Sync4jOperationStatusOK((SyncOperation)operation, this.sources[1], cmd, 211)};
                            }
                            catch (SyncException e) {
                                if (log.isEnabledFor((Priority)Level.FATAL)) {
                                    log.fatal((Object)("Error executing sync operation: " + e.getMessage()));
                                }
                                log.debug((Object)"execSyncOperation", (Throwable)e);
                                status[0] = new Sync4jOperationStatusError((SyncOperation)operation, this.sources[1], cmd, e);
                            }
                            break;
                        }
                    }
                    case 'D': {
                        if (stateItemB != 'D') break;
                        status = new SyncOperationStatus[1];
                        cmd = (ModificationCommand)syncItemA.getPropertyValue("SYNCML_COMMAND");
                        status[0] = new Sync4jOperationStatusOK((SyncOperation)operation, this.sources[1], cmd);
                    }
                }
                break;
            }
            case 'O': {
                try {
                    SyncConflict sc = (SyncConflict)operation;
                    cmd = (ModificationCommand)syncItemA.getPropertyValue("SYNCML_COMMAND");
                    if (sc.getType().equals("CX")) {
                        this.sources[1].removeSyncItem(owner, syncItemA);
                    } else {
                        syncItemA = this.sources[1].setSyncItem(owner, syncItemB);
                        operation.setSyncItemA(syncItemA);
                    }
                    operation.setAOperation(true);
                    status = new SyncOperationStatus[]{new Sync4jOperationStatusConflict((SyncOperation)operation, this.sources[1], cmd, 419)};
                    break;
                }
                catch (SyncException e) {
                    if (log.isEnabledFor((Priority)Level.FATAL)) {
                        log.fatal((Object)("Error executing sync operation: " + e.getMessage()));
                    }
                    log.debug((Object)"execSyncOperation", (Throwable)e);
                    status[0] = new Sync4jOperationStatusError((SyncOperation)operation, this.sources[1], cmd, e);
                }
            }
        }
        return status;
    }

    private void fixMappedItems(Collection<SyncItemMapping> newlyMappedItems, SyncItem[] syncItems, SyncSource source, Principal principal, boolean isSlowSync) {
        SyncItem itemB = null;
        for (int i = 0; syncItems != null && i < syncItems.length; ++i) {
            SyncItemMapping mapping;
            itemB = null;
            if (syncItems[i].isMapped()) continue;
            try {
                itemB = source.getSyncItemFromTwin(principal, syncItems[i]);
            }
            catch (SyncSourceException e) {
                String msg = "Error retrieving the twin item of " + syncItems[i].getKey() + " from source " + source + ": " + e.getMessage();
                if (log.isEnabledFor((Priority)Level.FATAL)) {
                    log.fatal((Object)msg);
                }
                log.debug((Object)"fixSyncMapping", (Throwable)e);
            }
            if (itemB == null) continue;
            if (isSlowSync) {
                if (!this.isContained(newlyMappedItems, itemB)) {
                    mapping = new SyncItemMapping((Object)itemB.getKey());
                    mapping.setMapping(syncItems[i], itemB);
                    newlyMappedItems.add(mapping);
                    syncItems[i] = SyncItemHelper.newMappedSyncItem(itemB.getKey(), syncItems[i]);
                    continue;
                }
                itemB = syncItems[i];
                itemB.setState('C');
                mapping = new SyncItemMapping((Object)itemB.getKey());
                mapping.setMapping(syncItems[i], itemB);
                newlyMappedItems.add(mapping);
                syncItems[i] = SyncItemHelper.newMappedSyncItem(itemB.getKey(), syncItems[i]);
                continue;
            }
            mapping = new SyncItemMapping((Object)itemB.getKey());
            mapping.setMapping(syncItems[i], itemB);
            newlyMappedItems.add(mapping);
            syncItems[i] = SyncItemHelper.newMappedSyncItem(itemB.getKey(), syncItems[i]);
        }
    }

    private boolean isContained(Collection<SyncItemMapping> newlyMappedItems, SyncItem itemTwin) {
        for (SyncItemMapping map : newlyMappedItems) {
            SyncItem itemB = map.getSyncItemB();
            if (!itemB.equals(itemTwin)) continue;
            return true;
        }
        return false;
    }
}

