/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.server.engine;

import com.funambol.framework.config.Configuration;
import com.funambol.framework.config.ConfigurationConstants;
import com.funambol.framework.core.Authentication;
import com.funambol.framework.core.Chal;
import com.funambol.framework.core.Cred;
import com.funambol.framework.core.Meta;
import com.funambol.framework.security.Officer;
import com.funambol.framework.security.Sync4jPrincipal;
import com.funambol.framework.server.Sync4jDevice;
import com.funambol.framework.server.store.ConfigPersistentStoreException;
import com.funambol.framework.server.store.PersistentStore;
import com.funambol.framework.server.store.PersistentStoreException;
import com.funambol.framework.tools.Base64;
import com.funambol.framework.tools.CommandIdGenerator;
import com.funambol.framework.tools.MD5;
import java.io.Serializable;
import java.security.Principal;
import java.util.HashMap;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Sync4jEngine
implements Serializable,
ConfigurationConstants {
    public static final String LOG_NAME = "engine";
    protected Configuration configuration = null;
    protected Officer officer = null;
    protected PersistentStore store = null;
    protected static final transient Logger log = Logger.getLogger((String)Sync4jEngine.class.getName());
    private String syncMLVerProto = null;
    protected CommandIdGenerator cmdIdGenerator = null;

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Officer getOfficer() {
        return this.officer;
    }

    public PersistentStore getStore() {
        return this.store;
    }

    public void setStore(PersistentStore store) {
        this.store = store;
    }

    public void setSyncMLVerProto(String syncMLVerProto) {
        this.syncMLVerProto = syncMLVerProto;
    }

    protected Sync4jEngine() {
    }

    public Sync4jEngine(Configuration configuration) {
        this.configuration = configuration;
        HashMap<String, ClassLoader> psConfig = new HashMap<String, ClassLoader>(1);
        psConfig.put("class-loader", configuration.getClassLoader());
        this.store = (PersistentStore)configuration.getBeanInstance("engine.store");
        try {
            this.store.configure(psConfig);
        }
        catch (ConfigPersistentStoreException e) {
            if (log.isEnabledFor((Priority)Level.FATAL)) {
                log.fatal((Object)("Error configuring the persistent store: " + (Object)((Object)e)));
            }
            log.debug((Object)"<init>", (Throwable)e);
        }
        this.officer = (Officer)configuration.getBeanInstance("security.officer");
        this.cmdIdGenerator = new CommandIdGenerator();
    }

    public void setCommandIdGenerator(CommandIdGenerator cmdIdGenerator) {
        this.cmdIdGenerator = cmdIdGenerator;
    }

    public CommandIdGenerator getCommandIdGenerator() {
        return this.cmdIdGenerator;
    }

    public boolean login(Cred credential) {
        return this.officer.authenticate(credential);
    }

    public boolean isGuestEnabled() {
        return this.officer.isGuestEnabled();
    }

    public void logout(Cred credential) {
        this.officer.unAuthenticate(credential);
    }

    public boolean authorize(Principal principal, String resource) {
        return this.officer.authorize(principal, resource);
    }

    public boolean isDebug() {
        return this.configuration.getBoolValue("server.debug", false);
    }

    public Cred getServerCredentials(Chal chal, Sync4jDevice device) {
        String login = this.configuration.getStringValue("server.id");
        if (login == null || login.equals("")) {
            return null;
        }
        if (chal == null) {
            return null;
        }
        String pwd = device.getServerPassword();
        String type = chal.getType();
        String data = login + ':' + pwd;
        if ("syncml:auth-basic".equals(type)) {
            data = new String(Base64.encode((byte[])data.getBytes()));
        } else if ("syncml:auth-clear".equals(type)) {
            data = login + ':' + pwd;
        } else if ("syncml:auth-md5".equals(type)) {
            byte[] serverNonce;
            if (this.syncMLVerProto.indexOf("1.0") != -1) {
                serverNonce = chal.getNextNonce().getValue();
                String serverNonceDecode = null;
                serverNonceDecode = serverNonce == null || serverNonce.length == 0 ? "" : ("b64".equals(chal.getFormat()) ? new String(Base64.decode((byte[])serverNonce)) : new String(serverNonce));
                String withNonce = new String(data.getBytes()) + ':' + serverNonceDecode;
                byte[] digestNonce = MD5.digest((byte[])withNonce.getBytes());
                data = new String(Base64.encode((byte[])digestNonce));
            } else {
                serverNonce = chal.getNextNonce().getValue();
                byte[] serverNonceDecode = null;
                serverNonceDecode = serverNonce == null || serverNonce.length == 0 ? new byte[]{} : ("b64".equals(chal.getFormat()) ? Base64.decode((byte[])serverNonce) : serverNonce);
                byte[] digest = MD5.digest((byte[])data.getBytes());
                byte[] b64 = Base64.encode((byte[])digest);
                byte[] buf = new byte[b64.length + 1 + serverNonceDecode.length];
                System.arraycopy(b64, 0, buf, 0, b64.length);
                buf[b64.length] = 58;
                System.arraycopy(serverNonceDecode, 0, buf, b64.length + 1, serverNonceDecode.length);
                data = new String(Base64.encode((byte[])MD5.digest((byte[])buf)));
            }
        } else if ("syncml:auth-MAC".equals(type)) {
            // empty if block
        }
        Meta m = new Meta();
        m.setType(type);
        m.setNextNonce(null);
        return new Cred(new Authentication(m, data));
    }

    public void readPrincipal(Sync4jPrincipal principal) throws PersistentStoreException {
        assert (principal != null);
        assert (principal.getUsername() != null);
        assert (principal.getDeviceId() != null);
        this.getStore().read((Object)principal);
    }

    public void readDevice(Sync4jDevice device) throws PersistentStoreException {
        assert (device != null);
        assert (device.getDeviceId() != null);
        this.getStore().read((Object)device);
    }

    public void storeDevice(Sync4jDevice device) {
        try {
            this.getStore().store((Object)device);
        }
        catch (PersistentStoreException e) {
            if (log.isEnabledFor((Priority)Level.FATAL)) {
                log.fatal((Object)("Error storing the device: " + e.getMessage()));
            }
            log.debug((Object)"storeDevice", (Throwable)e);
        }
    }
}

