/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.server;

import com.funambol.framework.tools.XMLTools;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class SyncMLCanonizer
implements Serializable {
    private static final Logger log = Logger.getLogger((String)SyncMLCanonizer.class.getName());

    public String canonizeOutputMessage(String message) {
        if (log.isEnabledFor((Priority)Level.TRACE)) {
            log.trace((Object)"Starting process of canonization on output message");
        }
        String response = this.metInfNamespaceHandler(message).replaceAll("<MoreData></MoreData>", "<MoreData/>");
        return this.mgmtTreeNamespaceHandler(response);
    }

    public String canonizeInputMessage(String message) {
        if (log.isEnabledFor((Priority)Level.TRACE)) {
            log.trace((Object)"Starting process of canonization on input message");
        }
        message = this.replaceEntity(message);
        return message;
    }

    private String replaceEntity(String msg) {
        int s = 0;
        int e = 0;
        StringBuffer response = new StringBuffer();
        while ((e = msg.indexOf("<Data>", s)) >= 0) {
            response = response.append(msg.substring(s, e + 6));
            int a = msg.indexOf("</Data>", e);
            String data = msg.substring(e + 6, a);
            if (!data.startsWith("<![CDATA[") && !data.trim().startsWith("<SyncML xmlns=\"syncml:dmddf1.2\">")) {
                data = XMLTools.replaceAmp((String)data);
                data = StringUtils.replace((String)data, (String)"<", (String)"&lt;");
                data = StringUtils.replace((String)data, (String)">", (String)"&gt;");
                data = StringUtils.replace((String)data, (String)"\"", (String)"&quot;");
            }
            s = a + 7;
            response.append(data).append("</Data>");
        }
        response.append(msg.substring(s, msg.length()));
        return response.toString();
    }

    private String metInfNamespaceHandler(String msg) {
        int s = 0;
        int e = 0;
        StringBuffer response = new StringBuffer();
        while ((e = msg.indexOf("<Meta", s)) >= 0) {
            response = response.append(msg.substring(s, e));
            int a = msg.indexOf("</Meta>", e);
            String meta = msg.substring(e, a);
            meta = meta.replaceAll("<Type>", "<Type xmlns='syncml:metinf'>");
            meta = meta.replaceAll("<Format>", "<Format xmlns='syncml:metinf'>");
            meta = meta.replaceAll("<Mark>", "<Mark xmlns='syncml:metinf'>");
            meta = meta.replaceAll("<Size>", "<Size xmlns='syncml:metinf'>");
            meta = meta.replaceAll("<Anchor>", "<Anchor xmlns='syncml:metinf'>");
            meta = meta.replaceAll("<Version>", "<Version xmlns='syncml:metinf'>");
            meta = meta.replaceAll("<NextNonce>", "<NextNonce xmlns='syncml:metinf'>");
            meta = meta.replaceAll("<MaxMsgSize>", "<MaxMsgSize xmlns='syncml:metinf'>");
            meta = meta.replaceAll("<MaxObjSize>", "<MaxObjSize xmlns='syncml:metinf'>");
            meta = meta.replaceAll("<EMI>", "<EMI xmlns='syncml:metinf'>");
            meta = meta.replaceAll("<Mem>", "<Mem xmlns='syncml:metinf'>");
            s = a + 7;
            response.append(meta).append("</Meta>");
        }
        String sResponse = response.append(msg.substring(s, msg.length())).toString();
        return sResponse;
    }

    private String mgmtTreeNamespaceHandler(String msg) {
        int s = 0;
        int e = 0;
        int cont = 0;
        StringBuffer response = new StringBuffer();
        while ((e = msg.indexOf("<SyncML>", s)) >= 0) {
            response = response.append(msg.substring(s, e));
            int a = msg.indexOf("</SyncML>", e);
            String mgtmTree = msg.substring(e + 8, a);
            if (cont > 0) {
                if (mgtmTree.trim().startsWith("<MgmtTree>")) {
                    response.append("<SyncML xmlns='syncml:dmddf1.2'>");
                }
                response.append(mgtmTree);
                response.append("</SyncML>");
                s = a + 9;
            } else {
                response.append("<SyncML>");
                s = e + 8;
            }
            ++cont;
        }
        String sResponse = response.append(msg.substring(s, msg.length())).toString();
        return sResponse;
    }
}

