#ifndef __SPEED_TEST_CLASS_H__
#define __SPEED_TEST_CLASS_H__

#include "errorClass.h"
#include <iostream>
#include <vector>

#ifdef _WIN32
#include <windows.h>
typedef LARGE_INTEGER SPD;
#else
#include <sys/time.h>
typedef union _SPD{
        long long QuadPart;                     //!< 128rbg
        struct{
            long          sec;         //!< 64rbg
            long          usec;        //!< 64rbg
        };
	   struct timeval tv;
        _SPD():QuadPart(0){};              //!< Xgŏ
    }SPD;
#endif //_WIN32


//! vO̎sxvNX.
/*!  */
class speedTestClass
{
//ϐƂ
private:
    unsigned long                           max_length;
    SPD                                     cpu_freq;               //!< v̐x
    SPD                                     t_start;                //!< vI̎Ԃ
    SPD                                     t_end;                  //!< vJn̎Ԃ
    std::vector<long long>                  wlonglist;              //!< long^̑oXg
    std::vector<long long>::iterator        wlonglistit;            //!< long^̑oXg
    std::vector<std::string>                stringlist;             //!< std::string^̑oXg ṽvZXƂi[
    std::vector<std::string>::iterator      stringlistit;           //!< std::string^̑oXg ṽvZXƂi[
    void                                    (speedTestClass::*Switch)(std::string);                //!< e[upϐ
protected:
public:
//֐Ƃ
private:
    void                start(std::string memo);
    void                stop(std::string memo);
    void                forceStop(void);                        // 蒆showTimeȂǂ̊֐Ă񂾎ɋIɑ~߂
    void                checkTimeIndex(unsigned int &index);    // QƂ̃`FbN
    unsigned long       checkTimeIndex(std::string &name);      // QƂ̃`FbN
protected:
public:
    speedTestClass();                                           // ϐ̏Ȃ
    ~speedTestClass();                                          // ƂɂȂ
    void                st();                                   // ĂԂтɌv̊JnƏI
    void                st(std::string);                        // ĂԂтɌv̊JnƏI

    long double         getTime(unsigned int index);            // bv^C̎擾
    long double         getTime(std::string name);              // bv^C̎擾
    void                showTime(unsigned int index);           // bv^C̕\
    void                showTime(std::string name);             // bv^C̕\
    void                showTimeAll(void);                      // ׂẴ^C̎擾
    void                clearTime(unsigned int index);          // L^폜
    void                clearTime(std::string name);            // L^폜
    void                clearTimeAll(void);                     // L^폜
};

#endif //__SPEED_TEST_CLASS_H__
