#include "speedTestClass.h"

//--------------------------------------------------------
//----------          speedTestClass          ------------
//--------------------------------------------------------
// -------------------------------------------------------

// -------------------------------------------------------
//! \brief  e[upϐ.
//! \param  std::string vƂ̖O.
//! \return Ȃ.
void speedTestClass::st(std::string s)
{
    (this->*Switch)(s);             //!< ֐Ăяo
}

// -------------------------------------------------------
//! \brief  e[upϐ.
//! \param  Ȃ.
//! \return Ȃ.
void speedTestClass::st()
{
    (this->*Switch)("");
}

// -------------------------------------------------------
//! \brief  JE^X^[g.
//! \param  Ȃ.
//! \return Ȃ.
void speedTestClass::start(std::string memo)
{
    stringlist.push_back(memo);
    Switch = &speedTestClass::stop;        //!< stSwitch
#ifdef _WIN32
    QueryPerformanceCounter(&t_start);
#else
    gettimeofday(&t_start.tv,NULL);
//    __asm__ volatile ("rdtsc" : "=a" (t_start.LowPart), "=d" (t_start.HighPart));
#endif //_WIN32
}

// -------------------------------------------------------
//! \brief  JE^Xgbv.
//! \param  Ȃ.
//! \return Ȃ.
void speedTestClass::stop(std::string memo)
{
#ifdef _WIN32
    QueryPerformanceCounter(&t_end);    //!< ptH[}XJE^Ăяo
	wlonglist.push_back(t_end.QuadPart - t_start.QuadPart);
#else
    gettimeofday(&t_end.tv,NULL);
    wlonglist.push_back((t_end.tv.tv_sec - t_start.tv.tv_sec)*1000000 + (t_end.tv.tv_usec - t_start.tv.tv_usec));
//    __asm__ volatile ("rdtsc" : "=a" (t_end.LowPart), "=d" (t_end.HighPart));
#endif //_WIN32
    Switch = &speedTestClass::start;
	std::cout << memo << " finish." << std::endl;
}

// -------------------------------------------------------
//! \brief  蒆showTimeȂǂ̊֐Ă񂾎ɋIɑ~߂.
/*! */
//! \param  Ȃ.
//! \return Ȃ.
inline void speedTestClass::forceStop(void)
{
    if(Switch == &speedTestClass::stop){    //!< ԌvĂ鎞
        stop("");
        std::cout << "speed test stop." << std::endl;
    }
}

// -------------------------------------------------------
//! \brief  QƂ̒l`FbN.
/*! Ȃꍇ͗OX[ */
//! \param  index  `FbNQƔԍ.
//! \return Ȃ.
inline void speedTestClass::checkTimeIndex(unsigned int &index)
{
    if(index >= wlonglist.size()){
		index = 0;
		std::cerr << __FUNCTION__ << std::endl << "Invalid value index. set index = 0." << std::endl;
    }
}

// -------------------------------------------------------
//! \brief  QƂ̒l`FbN.
/*! Ȃꍇ͗OX[ */
//! \param  index  `FbN閼O.
//! \return Ȃ.
inline unsigned long speedTestClass::checkTimeIndex(std::string &name)
{
    unsigned long index;
    for(index=0; index<stringlist.size(); ++index){
        if(stringlist[index] == name){
            goto LOOP_SUCCESS;
        }
    }
	index = 0;
	std::cerr << __FUNCTION__ << std::endl << "Invalid value index. set index = 0." << std::endl;
LOOP_SUCCESS:
    return index;
}





// -------------------------------------------------------
//! \brief  vCx[gȍl.
//! \param  Ȃ.
//! \return Ȃ.
speedTestClass::speedTestClass():
    Switch(&speedTestClass::start),
    max_length(0)
{
    __CONSTRUCTOR;
#ifdef _WIN32
    //ϐ̏
    QueryPerformanceFrequency(&cpu_freq);            // !< Windowsł̌vZ̐x
#else
    cpu_freq.QuadPart = 1000*1000;
#endif //_WIN32
    if( cpu_freq.QuadPart > 0xffffffff )cpu_freq.QuadPart = 0xffffffff;   //!< G[
}

// -------------------------------------------------------
//! \brief  ɉȂ.
//! \param  Ȃ.
//! \return Ȃ.
speedTestClass::~speedTestClass(void)
{
    __DESTRUCTOR;
}

// -------------------------------------------------------
//! \brief  w肵bṽ^C擾.
//! \param  index ڂ̌v.
//! \return bv^Cԋp.
long double speedTestClass::getTime(unsigned int index)
{
    forceStop();
    checkTimeIndex(index);														// bv̎QƂ`FbN
	return (long double)wlonglist[index]/(long double)cpu_freq.QuadPart;        // indexԖڂ̃bv^Cԋp
}

// -------------------------------------------------------
//! \brief  w肵bṽ^C擾.
//! \param  name ۑ̖O.
//! \return bv^Cԋp.
long double speedTestClass::getTime(std::string name)
{
    forceStop();
    return (long double)wlonglist[checkTimeIndex(name)]/(long double)cpu_freq.QuadPart;        // indexԖڂ̃bv^Cԋp
}

// -------------------------------------------------------
//! \brief  w肵bṽ^C\.
//! \param  index ڂ̌v.
//! \return Ȃ.
void speedTestClass::showTime(std::string name)
{
    forceStop();
    showTime(checkTimeIndex(name));
}

// -------------------------------------------------------
//! \brief  w肵bṽ^C\.
//! \param  index ڂ̌v.
//! \return Ȃ.
inline void speedTestClass::showTime(unsigned int index)
{
    forceStop();
    checkTimeIndex(index);                      // bv̎QƂ`FbN
    std::cout.setf(std::ios::fixed);            // ɏ_\悤ɃZbg
    if(stringlist[index] == ""){
        std::cout << "process(" << index << ") ";
        for(unsigned int i=1;i<max_length;++i){
            std::cout << " ";
        }
    }else{
        std::cout << "process(" << stringlist[index] << ") ";
        for(unsigned int i=(unsigned int)stringlist[index].length();i<max_length;++i){
            std::cout << " ";
        }
    }
    std::cout << "elapsed time: "<< (long double)wlonglist[index]/(long double)cpu_freq.QuadPart << " (sec)" << std::endl;
}

// -------------------------------------------------------
//! \brief  ׂẴbṽ^C\.
//! \param  Ȃ.
//! \return Ȃ.
void speedTestClass::showTimeAll(void)
{
    forceStop();

    max_length = 0;
    for(unsigned int i=0; i<stringlist.size(); ++i){
        if(stringlist[i].length()>max_length){
            max_length=(unsigned int)stringlist[i].length();
        };
    }

    for(unsigned int i=0; i<wlonglist.size(); ++i){
        showTime(i);
    }
    max_length=0;
}

// -------------------------------------------------------
//! \brief  ۑĂ邷ׂẴ^C폜.
//! \param  Ȃ.
//! \return Ȃ.
inline void speedTestClass::clearTime(unsigned int index)
{
    forceStop();
    checkTimeIndex(index);          // bv̎QƂ`FbN
    stringlistit = stringlist.begin();
    wlonglistit  = wlonglist.begin();
    for(unsigned int i=0; i< index; ++i){
        ++stringlistit;
        ++wlonglistit;
    }
    stringlistit = stringlist.erase(stringlistit);
    wlonglistit  = wlonglist.erase(wlonglistit);
}

// -------------------------------------------------------
//! \brief  ۑĂ邷ׂẴ^C폜.
//! \param  Ȃ.
//! \return Ȃ.
inline void speedTestClass::clearTime(std::string name)
{
    forceStop();
    clearTime(checkTimeIndex(name));
}

// -------------------------------------------------------
//! \brief  ۑĂ邷ׂẴ^C폜.
//! \param  Ȃ.
//! \return Ȃ.
void speedTestClass::clearTimeAll(void)
{
    forceStop();
    wlonglist.clear();              // ^Cׂď
    stringlist.clear();                // Oׂď
}
