#include "OpenCLWrapperClass.h"


OpenCLWrapperClass::OpenCLWrapperClass():
    use_device(0),
    openCL_device_num(0)
{
    this->getOpenCLDeviceNum();
}


OpenCLWrapperClass::~OpenCLWrapperClass()
{
    delete [] ocl;
}


void OpenCLWrapperClass::getOpenCLDeviceNum()
{try{
    cl_int status;
    // vbgtH[̐擾
    cl_uint num_platforms;
    status = clGetPlatformIDs(0,
                              NULL,
                              &num_platforms);
    if(status != CL_SUCCESS)throw clErrorClass(status, "get num of platforms failed.", __FUNCTION__);
    if(num_platforms){
        std::cout << num_platforms << " platforms found." << std::endl;
    }else{
        throw clErrorClass(-1, "cl_platforms not found.", __FUNCTION__);
    }

    // vbgtH[ID擾
    cl_platform_id *platform_id = new cl_platform_id[num_platforms];
    status = clGetPlatformIDs(num_platforms,
                              platform_id,
                              NULL);
    if(status != CL_SUCCESS)throw clErrorClass(status, "clGetPlatformIds faild", __FUNCTION__);

    // foCX̑擾
    cl_uint num_devices;
    cl_uint num_devices_all=0;
    cl_uint *count_devices = new cl_uint[num_platforms];
    for(unsigned int i=0; i<num_platforms; ++i){
        status = clGetDeviceIDs(platform_id[i],
                                CL_DEVICE_TYPE_ALL,
                                0,
                                NULL,
                                &num_devices);
        if(status != CL_SUCCESS)throw clErrorClass(status, "get num of devices failed.", __FUNCTION__);
        count_devices[i] = num_devices;
        num_devices_all += num_devices;
    }
    if(count_devices){
        std::cout << num_devices_all << " devices found." << std::endl;
    }else{
        delete [] platform_id;
        delete [] count_devices;
        throw clErrorClass(-1, "cl_device not found.", __FUNCTION__);
    }

    // foCXIDׂĎ擾
    cl_device_id *device_id = new cl_device_id[num_devices_all];
    unsigned int index=0;
    for(unsigned int i=0; i<num_platforms; ++i){
        // ̃vbgtH[ɑ݂foCX̐̈m
        cl_device_id *tmp_d = new cl_device_id[count_devices[i]];
        status = clGetDeviceIDs(platform_id[i],
                                CL_DEVICE_TYPE_ALL,
                                count_devices[i],
                                tmp_d,
                                NULL);
        if(status != CL_SUCCESS){
            delete [] device_id;
            delete [] platform_id;
            delete [] count_devices;
            throw clErrorClass(status, "get deviceIDs failed.", __FUNCTION__);
        }
        for(unsigned int j=0; j<count_devices[i]; ++j){
            device_id[index++] = tmp_d[j];
        }
        delete [] tmp_d;
    }
    for(unsigned int i=0; i<num_devices_all; ++i){
        std::cout << "device " << i << ", ID = " << device_id[i] << std::endl;
    }

    // ܂OpenCLfoCX̐NXϐɊi[
    this->openCL_device_num = num_devices_all;

    // OpenCL̃foCXIDƂɃNXZbg
    ocl = new clClass[this->openCL_device_num];
    for(unsigned int i=0; i< this->openCL_device_num; ++i){
        ocl[i].set(device_id[i]);
    }

    delete [] device_id;
    delete [] count_devices;
    delete [] platform_id;
}
catch(clErrorClass &err){err.showErrMsg();}catch(...){std::cerr << "unknown error." << std::endl;}}


unsigned int OpenCLWrapperClass::getUsableOpenCLDeviceNum() const
{
    return this->openCL_device_num;
}

void OpenCLWrapperClass::setUseDevice(unsigned int num)
{
    if(num >= this->openCL_device_num){
        std::cerr << "OpenCL device not so many." << std::endl;
        return;
    }
    this->use_device = num;
}

const
unsigned int OpenCLWrapperClass::getUseDevice() const
{
    return this->use_device;
}













// vbgtH[
const 
char *OpenCLWrapperClass::getPlatformInfo(cl_platform_info platform_info) const
{
    return this->ocl[this->use_device].getPlatformInfo(platform_info);
}

// -------------------------------------------------------
//! \brief  vbgtH[̏ڍ׏\.
//! \param  platform_info  m肽.
//! \return Ȃ.
void OpenCLWrapperClass::showPlatformInfo(cl_platform_info platform_info) const
{
    this->ocl[this->use_device].showPlatformInfo(platform_info);
}

// -------------------------------------------------------
//! \brief  vbgtH[̏ڍ׏ׂĕ\.
//! \param  platform_index vbgtH[̎QƔԍ.
//! \return Ȃ.
void OpenCLWrapperClass::showPlatformInfoAll() const
{
    this->ocl[this->use_device].showPlatformInfoAll();
}





// foCX

// -------------------------------------------------------
//! \brief  foCX̏ڍ׏擾.
//! \param  platform_info  m肽.
//! \return foCX̏ڍ׏ԋp.
const
cl_device_id OpenCLWrapperClass::getDeviceID() const
{
    return this->ocl[this->use_device].getDeviceId();
}

// -------------------------------------------------------
//! \brief  foCX̏ڍ׏擾.
//! \param  platform_info  m肽.
//! \return foCX̏ڍ׏ԋp.
const 
char* OpenCLWrapperClass::getDeviceInfo(cl_device_info device_info) const
{
    return this->ocl[this->use_device].getDeviceInfo(device_info);
}


// -------------------------------------------------------
//! \brief  foCX̏ڍ׏擾.
//! \param  platform_info  m肽.
//! \return foCX̏ڍ׏ԋp.
void OpenCLWrapperClass::showDeviceInfo(cl_device_info device_info) const
{
    this->ocl[this->use_device].showDeviceInfo(device_info);
}

// -------------------------------------------------------
//! \brief  foCX̏ڍ׏\.
//! \param  Ȃ.
//! \return Ȃ.
void OpenCLWrapperClass::showDeviceInfoAll() const
{
    this->ocl[this->use_device].showDeviceInfoAll();
}


// ReLXg
// -------------------------------------------------------
//! \brief  ReLXg擾.
//! \param  Ȃ.
//! \return ReLXgԋp.
const 
cl_context OpenCLWrapperClass::getContext() const
{
    return this->ocl[this->use_device].getContext();
}



// vOIuWFNg
void OpenCLWrapperClass::createProgramObject(const char *filename)
{
    for(unsigned int i=0; i < this->openCL_device_num; ++i){
        this->ocl[i].createProgramObject(filename);
    }
}




// J[l
void OpenCLWrapperClass::createKernel(const char *file_name ,const char *kernel_name)
{
    for(unsigned int i=0; i < this->openCL_device_num; ++i){
        this->ocl[i].createKernel(file_name, kernel_name);
    }
}

//! \brief  J[lԋp.
//! \param  Ȃ.
//! \return J[lԋp.
const
cl_kernel OpenCLWrapperClass::getKernel(std::string kernel_name) const
{
    return this->ocl[this->use_device].getKernel(kernel_name);
}






// R}hL[
//! \brief  R}hL[擾.
//! \param  Ȃ.
//! \return R}hL[ԋp.
const 
cl_command_queue OpenCLWrapperClass::getCommandQueue() const
{
    return this->ocl[this->use_device].getCommandQueue();
}





// [
void OpenCLWrapperClass::createMemory(cl_mem_flags flag, size_t memory_size, void *mem_pointer,std::string mem_name)
{
    this->ocl[this->use_device].createMemory(flag,
                                             memory_size,
                                             mem_pointer,
                                             mem_name);
}
const
cl_mem *OpenCLWrapperClass::getMemory(std::string name)
{
    return this->ocl[this->use_device].getMemory(name);
}





// J[l̎s
void OpenCLWrapperClass::runKernel(std::string       kernel_name, 
                                   cl_uint           num_dimension, 
                                   const size_t      *offset,
                                   size_t            *global_work_size, 
                                   size_t            *local_work_size,
                                   cl_uint           num_event,
                                   const cl_event    *event_list,
                                   cl_event          *event_ ) const
{
    this->ocl[this->use_device].runKernel(kernel_name,
                                          num_dimension,
                                          offset,
                                          global_work_size,
                                          local_work_size,
                                          num_event,
                                          event_list,
                                          event_ );
}


void OpenCLWrapperClass::runKernel(std::string       kernel_name, 
                                   cl_uint           num_dimension, 
                                   size_t            *global_work_size, 
                                   size_t            *local_work_size,
                                   cl_uint           num_event,
                                   const cl_event    *event_list,
                                   cl_event          *event_ ) const
{
    this->ocl[this->use_device].runKernel(kernel_name,
                                          num_dimension,
                                          global_work_size,
                                          local_work_size,
                                          num_event,
                                          event_list,
                                          event_ );
}


void OpenCLWrapperClass::runKernel(std::string       kernel_name, 
                                   cl_uint           num_dimension, 
                                   const size_t      *offset,
                                   size_t            *global_work_size, 
                                   size_t            *local_work_size) const
{
    this->ocl[this->use_device].runKernel(kernel_name,
                                          num_dimension,
                                          offset,
                                          global_work_size,
                                          local_work_size);
}


void OpenCLWrapperClass::runKernel(std::string        kernel_name, 
                                   cl_uint            num_dimension, 
                                   size_t            *global_work_size, 
                                   size_t            *local_work_size) const
{
    this->ocl[this->use_device].runKernel(kernel_name,
                                          num_dimension,
                                          global_work_size,
                                          local_work_size);
}




// sʂ擾
void OpenCLWrapperClass::getResult(std::string        kernel_name, 
                                   std::string        src_memory_name,
                                   cl_bool            block,
                                   size_t             offset,
                                   size_t             memory_size,
                                   void               *dst_memory,
                                   cl_uint            num_event,
                                   const cl_event     *event_list,
                                   cl_event           *event_ ) const
{
    this->ocl[this->use_device].getResult(kernel_name,
                                          src_memory_name,
                                          block,
                                          offset,
                                          memory_size,
                                          dst_memory,
                                          num_event,
                                          event_list,
                                          event_ );
}

// I[o[[h2
void OpenCLWrapperClass::getResult(std::string        kernel_name, 
                                   std::string        src_memory_name,
                                   cl_bool            block,
                                   size_t             memory_size,
                                   void               *dst_memory,
                                   cl_uint            num_event,
                                   const cl_event     *event_list,
                                   cl_event           *event_ ) const
{
    this->ocl[this->use_device].getResult(kernel_name,
                                          src_memory_name,
                                          block,
                                          memory_size,
                                          dst_memory,
                                          num_event,
                                          event_list,
                                          event_ );
}

// I[o[[h3
void OpenCLWrapperClass::getResult(std::string        kernel_name, 
                                   std::string        src_memory_name,
                                   size_t             memory_size,
                                   void               *dst_memory,
                                   cl_uint            num_event,
                                   const cl_event     *event_list,
                                   cl_event           *event_ ) const
{
    this->ocl[this->use_device].getResult(kernel_name,
                                          src_memory_name,
                                          memory_size,
                                          dst_memory,
                                          num_event,
                                          event_list,
                                          event_ );
}

// I[o[[h4
void OpenCLWrapperClass::getResult(std::string        kernel_name, 
                                   std::string        src_memory_name,
                                   cl_bool            block,
                                   size_t             offset,
                                   size_t             memory_size,
                                   void               *dst_memory) const
{
    this->ocl[this->use_device].getResult(kernel_name,
                                          src_memory_name,
                                          block,
                                          offset,
                                          memory_size,
                                          dst_memory);
}

// I[o[[h5
void OpenCLWrapperClass::getResult(std::string        kernel_name, 
                                   std::string        src_memory_name,
                                   cl_bool            block,
                                   size_t             memory_size,
                                   void               *dst_memory) const
{
    this->ocl[this->use_device].getResult(kernel_name,
                                          src_memory_name,
                                          block,
                                          0,
                                          memory_size,
                                          dst_memory);
}

// I[o[[h6
void OpenCLWrapperClass::getResult(std::string        kernel_name, 
                                   std::string        src_memory_name,
                                   size_t             memory_size,
                                   void               *dst_memory) const
{
    cl_int status;
    status = clEnqueueReadBuffer(ocl[this->use_device].getCommandQueue(),
                                 *ocl[this->use_device].getMemory(src_memory_name), // 󂯎錋ʂi[Ă郁IuWFNg(src)
                                 CL_TRUE,                                           // ubLO邩Ȃ
                                 0,                                                 // ǂݍ݃f[^̃ItZbg
                                 memory_size,                                       // ǂݍރf[^̃TCY
                                 dst_memory,                                        // ʂ󂯎z(dst)
                                 0,                                                 // Cxg̐
                                 NULL,                                              // Cxg̃Xg
                                 NULL);                                             // Cxgւ̃|C^
    if(status != CL_SUCCESS){
        clErrorClass err(status, "clEnqueueReadBuffer failed.", __FUNCTION__);
        err.showErrMsg();
    }
}
