/*
 * Copyright (c) 2003-2004 The Ochusha Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: monitor.h,v 1.1.2.2 2004/06/08 15:31:05 fuyu Exp $
 */

#ifndef _MONITOR_H_
#define _MONITOR_H_

#include <pthread.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef struct _Monitor
{
  pthread_mutex_t mutex;
  pthread_cond_t cond;
  pthread_t locker;
  int count;
  struct _Monitor *other;
} Monitor;


Monitor *ochusha_monitor_new(Monitor *other);
void ochusha_monitor_free(Monitor *monitor);
void ochusha_monitor_enter(Monitor *monitor);
int ochusha_monitor_try_enter(Monitor *monitor);
void ochusha_monitor_exit(Monitor *monitor);
void ochusha_monitor_wait(Monitor *monitor);
int ochusha_monitor_timedwait(Monitor *monitor, long ms);
void ochusha_monitor_notify(Monitor *monitor);
void ochusha_monitor_notify_all(Monitor *monitor);


#ifdef __cplusplus
} // extern "C"
#endif

#endif	/* _MONITOR_H_ */
