/*
 * Copyright (c) 2003-2004 The Ochusha Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: ochusha_bbs_table.h,v 1.8 2004/04/13 15:38:05 fuyu Exp $
 */

#ifndef _OCHUSHA_BBS_TABLE_H_
#define _OCHUSHA_BBS_TABLE_H_

#include "ochusha.h"
#include "ochusha_bulletin_board.h"
#include "ochusha_board_category.h"

#include <glib-object.h>
#include <glib.h>

#include <zlib.h>

#ifdef __cplusplus
extern "C" {
#endif


#define OCHUSHA_TYPE_BBS_TABLE			(ochusha_bbs_table_get_type())
#define OCHUSHA_BBS_TABLE(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj), OCHUSHA_TYPE_BBS_TABLE, OchushaBBSTable))
#define OCHUSHA_BBS_TABLE_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST((klass), OCHUSHA_TYPE_BBS_TABLE, OchushaBBSTableClass))
#define OCHUSHA_IS_BBS_TABLE(obj)		(G_TYPE_CHECK_INSTANCE_TYPE((obj), OCHUSHA_TYPE_BBS_TABLE))
#define OCHUSHA_IS_BBS_TABLE_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), OCHUSHA_TYPE_BBS_TABLE))
#define OCHUSHA_BBS_TABLE_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS((obj), OCHUSHA_TYPE_BBS_TABLE, OchushaBBSTableClass))


typedef struct _OchushaBBSTable OchushaBBSTable;
typedef struct _OchushaBBSTableClass OchushaBBSTableClass;


struct _OchushaBBSTable
{
  GObject parent_object;

  GSList *category_list;	/* of (OchushaBoardCategory *) */

  GHashTable *category_table;	/* name=>(OchushaBoardCategory *) */
  GHashTable *board_table;	/* base_url=>(OchushaBulletinBoard *) */

  /* XXX: ΤȤȤäƤʤİžбʤɤ˻Ȥͽ */
  GHashTable *board_name_table;	/* name=>(OchushaBulletinBoard *) */
};


struct _OchushaBBSTableClass
{
  GObjectClass parent_class;

  /* Signals */
  OchushaBoardCategory *(*category_new)(OchushaBBSTable *table,
					const gchar *name);
  OchushaBulletinBoard *(*board_new)(OchushaBBSTable *table,
				     int bbs_type,
				     const gchar *name, const char *base_url);
  void (*boardlist_read_category_element)(OchushaBBSTable *table,
					  OchushaBoardCategory *category,
					  GHashTable *category_attributes);
  void (*boardlist_write_category_element)(OchushaBBSTable *table,
					   OchushaBoardCategory *category,
					   gzFile boardlist_xml);
  void (*boardlist_read_board_element)(OchushaBBSTable *table,
				       OchushaBulletinBoard *board,
				       GHashTable *board_attributes);
  void (*boardlist_write_board_element)(OchushaBBSTable *table,
					OchushaBulletinBoard *board,
					gzFile boardlist_xml);
};


GType ochusha_bbs_table_get_type(void);
OchushaBBSTable *ochusha_bbs_table_new(void);

void ochusha_bbs_table_prepend_category(OchushaBBSTable *table,
					OchushaBoardCategory *category);
void ochusha_bbs_table_add_category(OchushaBBSTable *table,
				    OchushaBoardCategory *category);
void ochusha_bbs_table_remove_category(OchushaBBSTable *table,
				       OchushaBoardCategory *category);
OchushaBoardCategory *ochusha_bbs_table_lookup_category(OchushaBBSTable *table,
							const gchar *name);

void ochusha_bbs_table_add_board(OchushaBBSTable *table,
				 OchushaBulletinBoard *board);
void ochusha_bbs_table_remove_board(OchushaBBSTable *table,
				    OchushaBulletinBoard *board);
OchushaBulletinBoard *ochusha_bbs_table_lookup_board_by_url(
							OchushaBBSTable *table,
							const char *url);
OchushaBulletinBoard *ochusha_bbs_table_lookup_board_by_name(
							OchushaBBSTable *table,
							const gchar *name);

gboolean ochusha_bbs_table_check_url(OchushaBBSTable *table, const char *url,
				     OchushaBulletinBoard **board_p,
				     char **board_url_p,
				     int *bbs_type_p,
				     char **thread_id_p,
				     unsigned int *from_p, unsigned int *to_p,
				     gboolean *is_kako_html_p);

gboolean ochusha_bbs_table_read_boardlist_xml(OchushaBBSTable *table,
					      OchushaConfig *conf,
					      const char *subdir);
gboolean ochusha_bbs_table_write_boardlist_xml(OchushaBBSTable *table,
					       OchushaConfig *conf,
					       const char *subdir);

#ifdef __cplusplus
} // extern "C"
#endif

#endif	/* _OCHUSHA_BBS_TABLE_H_ */
