/*
 * Copyright (c) 2003-2004 The Ochusha Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: htmlutils.h,v 1.5 2004/01/15 02:12:14 fuyu Exp $
 */

#ifndef _HTMLUTILS_H_
#define _HTMLUTILS_H_

#include "utils.h"

#include <glib.h>
#include <iconv.h>

#ifdef __cplusplus
extern "C" {
#endif

/*
 * (SAX)HTMLѡϢ
 */
typedef struct _ElementHandler
{
  iconv_t converter;
  iconv_helper *helper;

  void (*startElement)(void *context, const char *name,
		       const char *const attrs[]);
  void (*endElement)(void *context, const char *name);
  void (*entityReference)(void *context, const char *name);
  void (*characters)(void *context, const gchar *ch, int len);
} ElementHandler;


void initialize_default_entity_dictionary(void);
GHashTable *get_default_entity_dictionary(void);
GHashTable *get_reverse_entity_dictionary(void);
const char *parse_text(ElementHandler *handler, void *context,
		       const char *text, int len);
gchar *simple_string_canon(const char *src, int len,
			   iconv_t converter, iconv_helper *helper);

#ifdef __cplusplus
} // extern "C"
#endif

#endif	/* _HTMLUTILS_H_ */
