/*
 * Copyright (c) 2003-2004 The Ochusha Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: paned_notebook.h,v 1.6 2004/01/15 02:18:05 fuyu Exp $
 */

#ifndef _PANED_NOTEBOOK_H_
#define _PANED_NOTEBOOK_H_

#include <glib.h>
#include <gtk/gtk.h>
#include "mod_notebook.h"

#ifdef __cplusplus
extern "C" {
#endif


#define PANED_NOTEBOOK_TYPE		(paned_notebook_get_type())
#define PANED_NOTEBOOK(obj)		(G_TYPE_CHECK_INSTANCE_CAST((obj), PANED_NOTEBOOK_TYPE, PanedNotebook))
#define PANED_NOTEBOOK_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST((klass), PANED_NOTEBOOK_TYPE, PanedNotebookClass))
#define IS_PANED_NOTEBOOK(obj)		(G_TYPE_CHECK_INSTANCE_TYPE((obj), PANED_NOTEBOOK_TYPE))
#define IS_PANED_NOTEBOOK_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), PANED_NOTEBOOK_TYPE))
#define PANED_NOTEBOOK_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS((obj), PANED_NOTEBOOK_TYPE, PanedNotebookClass))


typedef enum
{
  HPANED_STYLE,
  VPANED_STYLE
} PanedStyleType;

GType paned_style_get_type(void);
#define PANED_STYLE_TYPE		(paned_style_get_type())


typedef struct _PanedNotebook PanedNotebook;
typedef struct _PanedNotebookClass PanedNotebookClass;

struct _PanedNotebook
{
  GtkPaned container;

  /* HPanedVPaned */
  PanedStyleType paned_style;

  /* ModNotebookTabɤʾɽ뤫 */
  GtkPolicyType tab_policy;

  /* contents_paneɽ뤫 */
  gboolean always_show_contents_pane;

  /* containerpane1¦(ThreadlistViewʤɤꤷƤ뤬ɽ) */
  GtkWidget *selector;


  /* containerpane2¦ */
  GtkWidget *contents_pane;

  /* contents_paneξ */
  GtkBox *toolbar_box;

  /* toolbar_boxκ¦ */
  GtkToolbar *toolbar;

  /* toolbar_boxα¦ */
  GtkToolbar *right_toolbar;


  /* tool_bar */
  GtkWidget *left_arrow;
  GtkWidget *right_arrow;
  GtkOptionMenu *contents_menu;

  /* contents_menu */
  GtkMenu *contents_list;

  /* contents_paneβ */
  ModNotebook *item_contents;


  /* item_contentsɽitemΥꥹ */
  GSList *items_shown;
  int number_of_items_shown;

  gpointer current_item;
  GtkWidget *current_item_view;

  GtkMenuItem *active_menu_item;

  gboolean position_zero_hack;
};


struct _PanedNotebookClass
{
  GtkPanedClass parent_class;

  void (*item_view_required)(PanedNotebook *paned_notebook, gpointer item,
			     GtkWidget **item_view, const gchar **title,
			     GtkWidget **tab_label);
  void (*item_view_accepted)(PanedNotebook *paned_notebook, gpointer item,
			     GtkWidget *item_view);
  void (*item_view_being_closed)(PanedNotebook *paned_notebook,
				 gpointer item, GtkWidget *item_view);
  void (*item_view_closed)(PanedNotebook *paned_notebook, gpointer item,
			   GtkWidget *item_view);
  void (*page_switched)(PanedNotebook *paned_notebook,
			GtkWidget *previous_view, GtkWidget *current_view);
};


GType paned_notebook_get_type(void);

GtkWidget *paned_notebook_new(PanedStyleType paned_style);
GtkWidget *paned_notebook_new_with_selector(PanedStyleType paned_style,
					    GtkWidget *selector);

void paned_notebook_set_paned_style(PanedNotebook *paned_notebook,
				    PanedStyleType paned_style);
PanedStyleType paned_notebook_get_paned_style(PanedNotebook *paned_notebook);

void paned_notebook_set_tab_policy(PanedNotebook *paned_notebook,
				   GtkPolicyType tab_policy);
GtkPolicyType paned_notebook_get_tab_policy(PanedNotebook *paned_notebook);
void paned_notebook_set_tab_shrinkable(PanedNotebook *paned_notebook,
				       gboolean shrinkable);
gboolean paned_notebook_get_tab_shrinkable(PanedNotebook *paned_notebook);
void paned_notebook_set_minimum_tab_label_size(PanedNotebook *paned_notebook,
					       guint size);
guint paned_notebook_get_minimum_tab_label_size(PanedNotebook *paned_notebook);
void paned_notebook_set_tooltips(PanedNotebook *paned_notebook,
				 gboolean enable);
void paned_notebook_set_always_show_contents_pane(PanedNotebook *paned_notebook,
						  gboolean show_always);
gboolean paned_notebook_get_always_show_contents_pane(PanedNotebook *paned_notebook);

GtkWidget *paned_notebook_get_selector(PanedNotebook *paned_notebook);
void paned_notebook_set_selector(PanedNotebook *paned_notebook,
				 GtkWidget *selector);

GtkToolbar *paned_notebook_get_toolbar(PanedNotebook *paned_notebook);

gpointer paned_notebook_get_current_item(PanedNotebook *paned_notebook);
GtkWidget *paned_notebook_get_current_item_view(PanedNotebook *paned_notebook);
gpointer paned_notebook_get_item(PanedNotebook *paned_notebook,
				 GtkWidget *item_view);
GtkWidget *paned_notebook_get_item_view(PanedNotebook *paned_notebook,
					gpointer item);
GtkWidget *paned_notebook_get_tab_label(PanedNotebook *paned_notebook,
					gpointer item);
void paned_notebook_foreach_item(PanedNotebook *paned_notebook,
				 GFunc func, gpointer user_data);
void paned_notebook_foreach_item_view(PanedNotebook *paned_notebook,
				      GFunc func, gpointer user_data);

void paned_notebook_open_item_view(PanedNotebook *paned_notebook,
				   gpointer item, gboolean in_tab,
				   gboolean select_page);
/* itemɽǤʤitem_view_requiredȯ */
void paned_notebook_close_item_view(PanedNotebook *paned_notebook,
				    gpointer item);
/* itemɽäitem_view_closedȯ */
void paned_notebook_close_current_item_view(PanedNotebook *paned_notebook);


#ifdef __cplusplus
} // extern "C"
#endif

#endif	/* _PANED_NOTEBOOK_H_ */
