/*
 * Copyright (c) 2003 The Ochusha Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: virtual_board.h,v 1.7 2004/01/13 01:23:08 fuyu Exp $
 */

#ifndef _VIRTUAL_BOARD_H_
#define _VIRTUAL_BOARD_H_

#include "ochusha_bbs_thread.h"
#include "ochusha_bulletin_board.h"

#include "ochusha_ui.h"

#include <glib-object.h>
#include <glib.h>

#ifdef __cplusplus
extern "C" {
#endif

#define VIRTUAL_BOARD_TYPE		(virtual_board_get_type())
#define VIRTUAL_BOARD(obj)		(G_TYPE_CHECK_INSTANCE_CAST((obj), VIRTUAL_BOARD_TYPE, VirtualBoard))
#define VIRTUAL_BOARD_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST((klass), VIRTUAL_BOARD_TYPE, VirtualBoardClass))
#define IS_VIRTUAL_BOARD(obj)		(G_TYPE_CHECK_INSTANCE_TYPE((obj), VIRTUAL_BOARD_TYPE))
#define IS_VIRTUAL_BOARD_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), VIRTUAL_BOARD_TYPE))
#define VIRTUAL_BOARD_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS((obj), VIRTUAL_BOARD_TYPE, VirtualBoardClass))


typedef struct _VirtualBoard VirtualBoard;
typedef struct _VirtualBoardClass VirtualBoardClass;


#define OCHUSHA_BBS_TYPE_VIRTUAL_BOARD		-2


struct _VirtualBoard
{
  OchushaBulletinBoard parent_object;

  OchushaApplication *application;
  GSList *board_list;

  GSList *recent_thread_list;
};


struct _VirtualBoardClass
{
  OchushaBulletinBoardClass parent_class;
};


GType virtual_board_get_type(void);
OchushaBulletinBoard *virtual_board_new(const gchar *name, const char *id,
					OchushaApplication *application);
void virtual_board_remove_thread(VirtualBoard *board,
				 OchushaBBSThread *thread);
void virtual_board_clean_up_threadlist(VirtualBoard *board,
				       gboolean remove_unread_thread);

#ifdef __cplusplus
} // extern "C"
#endif

#endif	/* _VIRTUAL_BOARD_H_ */
