/*
 * Copyright (c) 2003 The Ochusha Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: ochusha_board_category.h,v 1.4 2003/12/24 03:40:50 fuyu Exp $
 */

#ifndef _OCHUSHA_BOARD_CATEGORY_H_
#define _OCHUSHA_BOARD_CATEGORY_H_

#include <glib-object.h>
#include <glib.h>

#include <zlib.h>

#ifdef __cplusplus
extern "C" {
#endif


#define OCHUSHA_TYPE_BOARD_CATEGORY		(ochusha_board_category_get_type())
#define OCHUSHA_BOARD_CATEGORY(obj)		(G_TYPE_CHECK_INSTANCE_CAST((obj), OCHUSHA_TYPE_BOARD_CATEGORY, OchushaBoardCategory))
#define OCHUSHA_BOARD_CATEGORY_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST((klass), OCHUSHA_TYPE_BOARD_CATEGORY, OchushaBoardCategoryClass))
#define OCHUSHA_IS_BOARD_CATEGORY(obj)		(G_TYPE_CHECK_INSTANCE_TYPE((obj), OCHUSHA_TYPE_BOARD_CATEGORY))
#define OCHUSHA_IS_BOARD_CATEGORY_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), OCHUSHA_TYPE_BOARD_CATEGORY))
#define OCHUSHA_BOARD_CATEGORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), OCHUSHA_TYPE_BOARD_CATEGORY, OchushaBoardCategoryClass))


typedef struct _OchushaBoardCategory OchushaBoardCategory;
typedef struct _OchushaBoardCategoryClass OchushaBoardCategoryClass;


struct _OchushaBoardCategory
{
  GObject parent_object;

  gchar *name;

  GSList *board_list;

  gboolean hidden;		/* İ鱣 */
  gboolean killed;		/* İ¸˼ΤƤ */
};


struct _OchushaBoardCategoryClass
{
  GObjectClass parent_class;

  /* signals */
  void (*read_boardlist_element)(OchushaBoardCategory *category,
				 GHashTable *board_attributes);
  void (*write_boardlist_element)(OchushaBoardCategory *category,
				  gzFile *boardlist_xml);
};


GType ochusha_board_category_get_type(void);
OchushaBoardCategory *ochusha_board_category_new(const gchar *name);

void ochusha_board_category_set_name(OchushaBoardCategory *category,
				     const gchar *name);
const gchar *ochusha_board_category_get_name(OchushaBoardCategory *category);

void ochusha_board_category_add_board(OchushaBoardCategory *category,
				      OchushaBulletinBoard *board);
void ochusha_board_category_remove_board(OchushaBoardCategory *category,
					 OchushaBulletinBoard *board);
void ochusha_board_category_append_boards(OchushaBoardCategory *category,
					  GSList *board_list);

OchushaBulletinBoard *ochusha_board_category_lookup_board_by_url(
						OchushaBoardCategory *category,
						const gchar *url);
OchushaBulletinBoard *ochusha_board_category_lookup_board_by_name(
						OchushaBoardCategory *category,
						const gchar *name);


#ifdef __cplusplus
} // extern "C"
#endif

#endif	/* _OCHUSHA_BOARD_CATEGORY_H_ */
