/*
 * Copyright (c) 2003 The Ochusha Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: threadlist_filter.h,v 1.4 2003/12/30 21:53:29 fuyu Exp $
 */

#ifndef _THREADLIST_FILTER_H_
#define _THREADLIST_FILTER_H_

#include "ochusha.h"
#include "ochusha_ui.h"

#include <glib.h>
#include <gtk/gtk.h>


#ifdef __cplusplus
extern "C" {
#endif


#define THREADLIST_FILTER_SETTING_TYPE			(threadlist_filter_setting_get_type())
#define THREADLIST_FILTER_SETTING(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj), THREADLIST_FILTER_SETTING_TYPE, ThreadlistFilterSetting))
#define THREADLIST_FILTER_SETTING_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST((klass), THREADLIST_FILTER_SETTING_TYPE, ThreadlistFilterSettingClass))
#define IS_THREADLIST_FILTER_SETTING(obj)		(G_TYPE_CHECK_INSTANCE_TYPE((obj), THREADLIST_FILTER_SETTING_TYPE))
#define IS_THREADLIST_FILTER_SETTING_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), THREADLIST_FILTER_SETTING_TYPE))
#define THREADLIST_FILTER_SETTING_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS((obj), THREADLIST_FILTER_SETTING_TYPE, ThreadlistFilterSettingClass))


typedef struct _ThreadlistFilterSetting ThreadlistFilterSetting;
typedef struct _ThreadlistFilterSettingClass ThreadlistFilterSettingClass;

typedef struct _ThreadlistFilter
{
  gchar *rule;
  int ignore_threshold;
} ThreadlistFilter;


typedef struct _RuleModelRelation
{
  GtkTreeIter all_rules_iter;
  GtkTreeIter current_rules_iter;
  int priority;
} RuleModelRelation;


/* Ĥ̰ */
#define THREADLIST_FILTER_RULE_END				'\0'
#if 0
#define THREADLIST_FILTER_RULE_NOP				'\377'
#else
#define THREADLIST_FILTER_RULE_NOP				'X'
#endif
/* ʲ¾Ū */
#define THREADLIST_FILTER_RULE_SHOW_ALL				'A'
#define THREADLIST_FILTER_RULE_HIDE_ALL				'a'

/* ʲ̾ε§ */
#define THREADLIST_FILTER_RULE_SHOW_FAVORITE				'F'
#define THREADLIST_FILTER_RULE_HIDE_NON_FAVORITE			'f'
#define THREADLIST_FILTER_RULE_SHOW_THREAD_SEEN				'S'
#define THREADLIST_FILTER_RULE_HIDE_THREAD_NEVER_SEEN			's'
#define THREADLIST_FILTER_RULE_SHOW_THREAD_SEEN_OFFLINE			'O'
#define THREADLIST_FILTER_RULE_HIDE_THREAD_NEVER_SEEN_OFFLINE		'o'
#define THREADLIST_FILTER_RULE_SHOW_NEW_COMER_THREAD			'N'
#define THREADLIST_FILTER_RULE_SHOW_THREAD_WITH_NEW_RESPONSES		'R'
#define THREADLIST_FILTER_RULE_HIDE_THREAD_WITHOUT_NEW_RESPONSES	'r'
#define THREADLIST_FILTER_RULE_SHOW_DAT_DROPPED_THREAD			'D'
#define THREADLIST_FILTER_RULE_HIDE_MUCH_IGNORED_THREAD			'i'
#define THREADLIST_FILTER_RULE_HIDE_HIDDEN_THREAD			'h'
#define THREADLIST_FILTER_RULE_SHOW_GOOD_TITLE_THREAD			'G'
#define THREADLIST_FILTER_RULE_HIDE_NO_GOOD_TITLE_THREAD		'g'


#if 0	/* XXX */
#define THREADLIST_FILTER_NORMAL_RULES	"FfSsOoNRrDihGg"
#define MAXIMUM_LENGTH_OF_RULE_STRING	16
#else
#define THREADLIST_FILTER_NORMAL_RULES	"FfSsOoNRrDih"
#define MAXIMUM_LENGTH_OF_RULE_STRING	14
#endif


struct _ThreadlistFilterSetting
{
  GtkVBox container;

  GtkTreeView *all_rules_view;
  GtkTreeModel *all_rules_model;
  GtkTreeSelection *all_rules_selection;

  GtkTreeView *current_rules_view;
  GtkTreeModel *current_rules_model;
  GtkTreeSelection *current_rules_selection;

  GtkToggleButton *default_show_all_button;
  GtkToggleButton *default_hide_all_button;

  GtkSpinButton *spin_button;
  GtkWidget *restore_default_button;

  int number_of_rules_applied;

  RuleModelRelation show_favorite;
  RuleModelRelation hide_non_favorite;
  RuleModelRelation show_seen;
  RuleModelRelation hide_never_seen;
  RuleModelRelation show_seen_offline;
  RuleModelRelation hide_never_seen_offline;
  RuleModelRelation show_new_comer;
  RuleModelRelation show_with_new_responses;
  RuleModelRelation hide_without_new_responses;
  RuleModelRelation show_dat_dropped;
  RuleModelRelation hide_much_ignored;
  RuleModelRelation hide_hidden;
  RuleModelRelation show_good_title;
  RuleModelRelation hide_no_good_title;

  gchar current_rule_string[MAXIMUM_LENGTH_OF_RULE_STRING];

  ThreadlistFilter filter;

  gboolean unselecting;
};


struct _ThreadlistFilterSettingClass
{
  GtkVBoxClass parent_class;

  void (*restore_default)(ThreadlistFilterSetting *setting);
  void (*changed)(ThreadlistFilterSetting *setting, ThreadlistFilter *filter);
};


GType threadlist_filter_setting_get_type(void);
GtkWidget *threadlist_filter_setting_new(void);
GtkWidget *threadlist_filter_setting_new_with_initial_setting(const ThreadlistFilter *filter);

void threadlist_filter_setting_set_filter(ThreadlistFilterSetting *setting,
					  const ThreadlistFilter *filter);
const ThreadlistFilter *threadlist_filter_setting_get_filter(ThreadlistFilterSetting *setting);
void threadlist_filter_setting_set_restore_default_button_sensitive(ThreadlistFilterSetting *setting, gboolean state);

void setup_default_threadlist_filter(OchushaApplication *application);
gboolean threadlist_filter_check_thread(ThreadlistFilter *filter,
					OchushaApplication *application,
					OchushaBBSThread *thread);

#ifdef __cplusplus
} // extern "C"
#endif

#endif	/* _THREADLIST_FILTER_H_ */
