/*
 * Copyright (c) 2003 The Ochusha Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id$
 */

#include "ochusha.h"

#include <glib.h>

#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>


/*
 * ochusha_cache_open_file
 *
 * ꤵ줿URLФ륭åե򳫤
 * flagsopenƥॳͿflagsǤ롣
 */
int
ochusha_cache_open_file(OchushaConfig *conf, const char *url, int flags)
{
  /*
   * ݤʤΤurlhttp://server/.*ǤȷǤ
   */
  char *cur_pos;
  char buffer[PATH_MAX];
  int len;
  int result;

  if (url == NULL)
    return -1;

  if (conf->home == NULL)
    return -1;

  if (url[strlen(url) - 1] == '/')
    return -1;

  cur_pos = strstr(url, "http://");
  if (cur_pos == NULL)
    return -1;

  len = snprintf(buffer, PATH_MAX, "%s/cache/%s", conf->home,
		 url + 7);	/* "http://"ʬά */

  if (len >= PATH_MAX)
    return -1;

  if ((flags & O_CREAT) == 0)
    return open(buffer, flags);

  result = open(buffer, flags, 0x180);
  if (result >= 0)
    return result;

  while (TRUE)
    {
      if (buffer[len] == '/')
	break;
      len--;
    }
  buffer[len] = '\0';

  if (!mkdir_p(buffer))
    return -1;

  buffer[len] = '/';

  return open(buffer, flags, 0x180);
}


/*
 * åե뤬¸ߤunlink롣
 */
void
ochusha_cache_unlink_file(OchushaConfig *conf, const char *url)
{
  /*
   * ݤʤΤurlhttp://server/.*ǤȷǤ
   */
  char *cur_pos;
  char buffer[PATH_MAX];
  int len;
  char *pathname;

  if (url == NULL)
    return;

  if (conf->home == NULL)
    return;

  if (url[strlen(url) - 1] == '/')
    return;

  cur_pos = strstr(url, "http://");
  if (cur_pos == NULL)
    return;

  len = snprintf(buffer, PATH_MAX, "%s/cache/%s", conf->home,
		 url + 7);	/* "http://"ʬά */

  if (len >= PATH_MAX)
    return;

  pathname = ochusha_find_file(conf, buffer);
  if (pathname == NULL)
    return;

  unlink(pathname);

  free(pathname);
}
