/*
 * Copyright (c) 2003 The Ochusha Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id$
 */

#ifndef _BBS_THREAD_VIEW_H_
#define _BBS_THREAD_VIEW_H_

#include "ochusha.h"

#include <gtk/gtk.h>

#ifdef __cplusplus
extern "C" {
#endif


#define BBS_THREAD_VIEW_TYPE			(bbs_thread_view_get_type())
#define BBS_THREAD_VIEW(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj), BBS_THREAD_VIEW_TYPE, BBSThreadView))
#define BBS_THREAD_VIEW_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST((klass), BBS_THREAD_VIEW_TYPE, BBSThreadViewClass))
#define IS_BBS_THREAD_VIEW(obj)			(G_TYPE_CHECK_INSTANCE_TYPE((obj), BBS_THREAD_VIEW_TYPE))
#define IS_BBS_THREAD_VIEW_CLASS(klass)		(G_TYPE_CHECK_CLASS_TYPE((klass), BBS_THREAD_VIEW_TYPE))
#define BBS_THREAD_VIEW_GET_CLASS(obj)		(G_TYPE_INSTANCE_GET_CLASS((obj), BBS_THREAD_VIEW_TYPE, BBSThreadViewClass))


typedef struct _BBSThreadView BBSThreadView;
typedef struct _BBSThreadViewClass BBSThreadViewClass;

struct _BBSThreadView
{
  GtkScrolledWindow text_container;

  GtkTextView *text_view;
  GtkTextBuffer *text_buffer;

  /* Хåե˻Ȥ */
  GtkTextIter iter;
  GSList *tags;
  int alt_link_tag;

  /* ʥطǻȤ */
  gint last_offset;
  BBSThread *thread;
  GHashTable *link_table;	/* offset=>linkʥơ֥ */

  GdkCursor *ibeam_cursor;
  GdkCursor *hand_cursor;
};


struct _BBSThreadViewClass
{
  GtkScrolledWindowClass parent_class;

  GtkTextTagTable *tag_table;

  void (*link_mouse_over)(BBSThreadView *bbs_thread_view,
			  GdkEventMotion *event,
			  BBSThread *thread, const gchar *link);
  void (*link_mouse_out)(BBSThreadView *bbs_thread_view,
			 GdkEventMotion *event,
			 BBSThread *thread, const gchar *link);
  void (*link_mouse_press)(BBSThreadView *bbs_therad_view,
			   GdkEventButton *event,
			   BBSThread *thread, const gchar *link);
  void (*link_mouse_release)(BBSThreadView *bbs_thread_view,
			     GdkEventButton *event,
			     BBSThread *thread, const gchar *link);

  void (*scroll_to)(BBSThreadView *bbs_thread_view, gint to_where);
};


typedef struct _BBSThreadInfo
{
} BBSThreadInfo;


GType bbs_thread_view_get_type(void);

GtkTextTagTable *bbs_thread_view_class_get_default_tag_table(BBSThreadViewClass *klass);

GtkWidget *bbs_thread_view_new(BBSThread *thread);
void bbs_thread_view_set_thread(BBSThreadView *view, BBSThread *thread);
BBSThread *bbs_thread_view_get_thread(BBSThreadView *view);

void bbs_thread_view_set_wrap_mode(BBSThreadView *view, GtkWrapMode mode);
GtkWrapMode bbs_thread_view_get_wrap_mode(BBSThreadView *view);

void bbs_thread_view_clear(BBSThreadView *view);

gint bbs_thread_view_get_current_offset(BBSThreadView *view);
GtkTextMark *bbs_thread_view_create_mark(BBSThreadView *view);
void bbs_thread_view_delete_mark(BBSThreadView *view, GtkTextMark *mark);
void bbs_thread_view_append_text(BBSThreadView *view, const gchar *text,
				 int len);
void bbs_thread_view_append_text_as_link(BBSThreadView *view,
					 const gchar *text, int len,
					 const gchar *link);
void bbs_thread_view_append_widget(BBSThreadView *view, GtkWidget *widget);

GtkTextTag *bbs_thread_view_get_tag_by_name(BBSThreadView *view,
					    const gchar *name);

void bbs_thread_view_push_tag_by_name(BBSThreadView *view, const gchar *name);
void bbs_thread_view_push_tag(BBSThreadView *view, GtkTextTag *tag);
GtkTextTag *bbs_thread_view_pop_tag(BBSThreadView *view);
void bbs_thread_view_pop_tags(BBSThreadView *view, GtkTextTag *tag);

void bbs_thread_view_scroll_to_start(BBSThreadView *view);
void bbs_thread_view_scroll_to_end(BBSThreadView *view);
void bbs_thread_view_scroll_to_mark(BBSThreadView *view, GtkTextMark *mark);
gint bbs_thread_view_scroll_to_offset(BBSThreadView *view, gint offset);

void bbs_thread_view_place_cursor_onscreen(BBSThreadView *view);

void bbs_thread_view_hide_scrollbar(BBSThreadView *view);

#ifdef __cplusplus
} // extern "C"
#endif

#endif	/* _BBS_THREAD_VIEW_H_ */
