/*
 * Decompiled with CFR 0.152.
 */
package oaks.make;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import oaks.make.AtomTable;
import oaks.make.DAO;
import oaks.make.DefEnum;
import oaks.make.DefTable;
import oaks.make.Version;

class Farm {
    private static HashMap<String, Farm> farm = new HashMap();
    private static ArrayList<DefEnum> en = null;
    private static ArrayList<DefTable> table = null;
    private String pack;

    private Farm(String p) {
        en = new ArrayList();
        table = new ArrayList();
        this.pack = p;
        if (p == null) {
            p = "";
        }
        farm.put(p, this);
    }

    static Farm getFarm(String p) {
        Farm f;
        String key = p;
        if (key == null) {
            key = "";
        }
        if ((f = farm.get(key)) == null) {
            f = new Farm(p);
        }
        return f;
    }

    File getDir() {
        if (this.pack != null) {
            String[] str = this.pack.split("\\.");
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < str.length; ++i) {
                buf = buf.append(str[i]);
                buf = buf.append(File.separator);
            }
            File dir = new File(DAO.out_dir, buf.toString());
            dir.mkdirs();
            if (!dir.isDirectory()) {
                System.out.print(dir.toString());
                System.out.println(" \u304c\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
                System.exit(1);
            }
            return dir;
        }
        return DAO.out_dir;
    }

    void add(DefEnum e) {
        en.add(e);
    }

    void add(DefTable t) {
        table.add(t);
    }

    static void output() {
        for (String key : farm.keySet()) {
            Farm f = farm.get(key);
            f.my_output();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void my_output() {
        PrintWriter pw = null;
        File out = new File(this.getDir(), "Farm.java");
        System.out.print("write: ");
        System.out.println(out.toString());
        try {
            pw = new PrintWriter(new BufferedWriter(new FileWriter(out)));
            pw.print(AtomTable.getHead());
            pw.print(this.toString());
        }
        catch (Exception e) {
            System.out.println("\u30d5\u30a1\u30a4\u30eb\u66f8\u304d\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            System.exit(1);
        }
        finally {
            if (pw != null) {
                try {
                    pw.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public String toString() {
        StringBuilder buf;
        String pk = "";
        if (this.pack != null) {
            buf = new StringBuilder("package ");
            buf = buf.append(this.pack).append(";").append(DAO.LF);
            pk = buf.toString();
        }
        buf = new StringBuilder(DAO.toString("// ", Version.getTitle(), "  ", new Date().toString(), " output", DAO.LF, pk, "import oaks.*;", DAO.LF, "/** DAO\u5b9a\u7fa9\u7ba1\u7406\u3002 */", DAO.LF, "public class Farm{", DAO.LF, "private Farm(){}", DAO.LF));
        for (DefEnum e : en) {
            if (e.getIO() == null) continue;
            buf = buf.append(e.toString());
        }
        for (DefTable t : table) {
            buf = buf.append(DAO.toString("/** ", t.getName(), " \u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u751f\u6210", DAO.LF, " * @return \u65b0\u3057\u3044\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u3002", DAO.LF, " */", DAO.LF, "public static ", t.getClassName(), " make", t.getClassName(), "(){return ", t.getClassName(), ".newInstance();}", DAO.LF));
        }
        buf = buf.append("}");
        return buf.toString();
    }
}

