/*
 * Decompiled with CFR 0.152.
 */
package oaks.make;

import java.util.ArrayList;
import java.util.Date;
import oaks.make.DAO;
import oaks.make.DefField;
import oaks.make.JavaDefine;
import oaks.make.Line;
import oaks.make.Version;

class DefTable {
    private Line line;
    private String pack = null;
    private String real_name;
    private String class_name;
    private boolean view_f;
    private ArrayList<DefField> field = new ArrayList();

    Line getLine() {
        return this.line;
    }

    DefTable(Line l, String p, String r, String c, boolean v) {
        this.real_name = r;
        if (c == null) {
            c = this.real_name;
        }
        this.class_name = c;
        if (JavaDefine.isDefine(c, true)) {
            System.out.println(l.toString(c + " \u306f\u30af\u30e9\u30b9\u540d\u306b\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002"));
            System.exit(1);
        }
        if ("Farm".equals(c)) {
            System.out.println(l.toString("Farm \u306f\u30af\u30e9\u30b9\u540d\u306b\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002"));
            System.exit(1);
        }
        this.view_f = v;
        this.pack = p;
        this.line = l;
    }

    void add(DefField f) {
        this.field.add(f);
    }

    String getName() {
        return this.real_name;
    }

    String getClassName() {
        return this.class_name;
    }

    public String toString() {
        StringBuilder buf;
        String pk = "";
        if (this.pack != null) {
            buf = new StringBuilder("package ");
            buf = buf.append(this.pack).append(";").append(DAO.LF);
            pk = buf.toString();
        }
        buf = new StringBuilder(DAO.toString("// ", Version.getTitle(), "  ", new Date().toString(), " output", DAO.LF, pk, "import oaks.*;", DAO.LF, "/** ", this.real_name, " */", DAO.LF, "public class ", this.class_name, " extends ", this.view_f ? "View<" : "Table<", this.class_name, ">{", DAO.LF, "private static final long serialVersionUID = 1;", DAO.LF, "protected View getInstance(){return new ", this.class_name, "();}", DAO.LF));
        for (DefField f : this.field) {
            buf = buf.append(f.toString());
        }
        buf = buf.append(DAO.toString("/** \u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf */", DAO.LF, "private ", this.class_name, "(){", DAO.LF, "super(\"", this.real_name, "\");", DAO.LF, "fields = new Field[]{", DAO.LF));
        for (DefField f : this.field) {
            buf = buf.append(DAO.toString("new ", f.getClassName(), "(),", DAO.LF));
        }
        buf = buf.append(DAO.toString("};", DAO.LF, "}", DAO.LF));
        int count = this.field.size();
        for (int i = 0; i < count; ++i) {
            DefField f = this.field.get(i);
            buf = buf.append(DAO.toString("/** ", f.getFieldName(), DAO.LF, " * @return ", f.getFieldName(), DAO.LF, " */", DAO.LF, "@SuppressWarnings(\"unchecked\")", DAO.LF, "public ", f.getClassName(), " get", f.getClassName(), "(){return (", f.getClassName(), ")fields[", Integer.toString(i), "];}", DAO.LF));
        }
        buf = buf.append(DAO.toString("static{", DAO.LF, "init(new ", this.class_name, "());", DAO.LF, "}", DAO.LF, "@SuppressWarnings(\"unchecked\")", DAO.LF, "static ", this.class_name, " newInstance(){return (", this.class_name, ")newInstance(", this.class_name, ".class);}", DAO.LF, "}", DAO.LF));
        return buf.toString();
    }
}

