/*
 * Decompiled with CFR 0.152.
 */
package oaks;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import oaks.DB;
import oaks.Field;
import oaks.GroupBy;
import oaks.OrderBy;
import oaks.SelectItem;
import oaks.View;

class SelectGroup {
    private ArrayList<SelectItem> select = new ArrayList();
    private HashMap<SelectItem, Integer> no = new HashMap();
    private ArrayList<OrderBy> order = new ArrayList();
    private ArrayList<Integer> order_no = new ArrayList();

    void set(View v, ResultSet rs) throws SQLException {
        for (SelectItem si : this.no.keySet()) {
            Object obj = rs.getObject(this.no.get(si));
            if (obj instanceof Date) {
                obj = rs.getDate(this.no.get(si), DB.TIMEZONE);
            } else if (obj instanceof Time) {
                obj = rs.getTime(this.no.get(si), DB.TIMEZONE);
            } else if (obj instanceof Timestamp) {
                obj = rs.getTimestamp(this.no.get(si), DB.TIMEZONE);
            }
            si.set(v, obj);
        }
    }

    SelectGroup(Field[] f, GroupBy gb, OrderBy[] od) throws DB.DBException {
        SelectItem item;
        int i;
        if (od == null) {
            od = new OrderBy[]{};
        }
        int cnt = 1;
        for (i = 0; i < f.length; ++i) {
            if (gb != null) {
                Field.GRP[] g = f[i].getGroup();
                if (g != null && g.length != 0) {
                    for (int j = 0; j < g.length; ++j) {
                        SelectItem item2 = new SelectItem(f[i].getClass(), g[j]);
                        this.select.add(item2);
                        this.no.put(item2, cnt);
                        ++cnt;
                    }
                }
                if (!gb.isHit(f[i])) continue;
            }
            item = new SelectItem(f[i].getClass(), null);
            this.select.add(item);
            this.no.put(item, cnt);
            ++cnt;
        }
        for (i = 0; i < od.length; ++i) {
            this.order.add(od[i]);
            item = od[i].toSelectItem();
            Integer seq = this.no.get(item);
            if (seq == null) {
                if (!od[i].isGroup()) {
                    throw new DB.DBException(String.format("[order by]%s \u306f group by \u5bfe\u8c61\u5916\u306a\u306e\u3067\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002", new Object[0]));
                }
                this.select.add(item);
                this.no.put(item, cnt);
                seq = cnt;
                ++cnt;
            }
            this.order_no.add(seq);
        }
    }

    String getSelect() {
        int cnt = this.select.size();
        StringBuilder buf = new StringBuilder(this.select.get(0).toString());
        for (int i = 1; i < cnt; ++i) {
            buf = buf.append(",").append(this.select.get(i).toString());
        }
        return buf.toString();
    }

    String getOrderBy() {
        int cnt = this.order.size();
        if (cnt == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < cnt; ++i) {
            buf = i == 0 ? buf.append(" order by ") : buf.append(",");
            buf = buf.append(this.order_no.get(i).toString());
            if (!this.order.get(i).isDesc()) continue;
            buf = buf.append(" desc");
        }
        return buf.toString();
    }
}

