/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyar4psg;

import java.io.InputStream;
import jp.nyatla.nyar4psg.NyAR4PsgConfig;
import jp.nyatla.nyar4psg.NyARPsgBaseClass;
import jp.nyatla.nyar4psg.PImageRaster;
import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.param.NyARFrustum;
import jp.nyatla.nyartoolkit.core.param.NyARParam;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.rasterdriver.INyARPerspectiveCopy;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARSquare;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint3d;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;
import jp.nyatla.nyartoolkit.core.types.matrix.NyARDoubleMatrix44;
import processing.core.PApplet;
import processing.core.PImage;
import processing.core.PMatrix;
import processing.core.PMatrix3D;
import processing.core.PVector;
import processing.opengl.PGraphicsOpenGL;

class SingleMarkerBaseClass
extends NyARPsgBaseClass {
    protected final PMatrix3D _ps_projection = new PMatrix3D();
    protected NyARParam _ar_param;
    protected final NyARFrustum _frustum = new NyARFrustum();
    protected NyAR4PsgConfig _config;
    protected PImageRaster _src_raster;
    public final PVector angle = new PVector();
    public final PVector trans = new PVector();
    public final int[][] pos2d = new int[4][2];
    public final double[] transmat = new double[16];
    public final double[] projection = new double[16];
    private final NyARDoubleMatrix44 _result = new NyARDoubleMatrix44();
    private boolean _is_in_begin_end_session;
    private final NyARDoublePoint3d _tmp_d3p = new NyARDoublePoint3d();
    private INyARPerspectiveCopy _pcopy;

    @Override
    public PMatrix3D getProjectionMatrix() {
        return this._ps_projection;
    }

    @Override
    public PMatrix3D getProjectionMatrix(PMatrix3D iBuf) {
        return new PMatrix3D((PMatrix)this._ps_projection);
    }

    @Override
    public void setARClipping(float i_near, float i_far) {
        super.setARClipping(i_near, i_far);
        NyARDoubleMatrix44 tmp = new NyARDoubleMatrix44();
        NyARIntSize s = this._ar_param.getScreenSize();
        this._ar_param.getPerspectiveProjectionMatrix().makeCameraFrustumRH((double)s.w, (double)s.h, (double)i_near, (double)i_far, tmp);
        SingleMarkerBaseClass.nyarMat2PsMat(tmp, this._ps_projection);
        this._frustum.setValue(tmp, s.w, s.h);
    }

    public PMatrix3D getMarkerMatrix() {
        PMatrix3D ret = new PMatrix3D();
        SingleMarkerBaseClass.matResult2PMatrix3D(this._result, this._config._coordinate_system, ret);
        return new PMatrix3D((PMatrix)ret);
    }

    public PVector[] getMarkerVertex2D() {
        PVector[] r = new PVector[4];
        int i = 0;
        while (i < 4) {
            r[i] = new PVector((float)this.pos2d[i][0], (float)this.pos2d[i][1]);
            ++i;
        }
        return r;
    }

    public void beginTransform(PGraphicsOpenGL i_pgl) {
        assert (i_pgl.equals(this._ref_papplet.g));
        this.beginTransform();
    }

    public void beginTransform() {
        if (this._is_in_begin_end_session) {
            this._ref_papplet.die("The function beginTransform is already called.", null);
        }
        this._is_in_begin_end_session = true;
        if (!(this._ref_papplet.g instanceof PGraphicsOpenGL)) {
            this._ref_papplet.die("NyAR4Psg require PGraphicsOpenGL instance.");
        }
        PGraphicsOpenGL pgl = (PGraphicsOpenGL)this._ref_papplet.g;
        pgl.pushProjection();
        this.setARPerspective();
        this._ref_papplet.pushMatrix();
        this._ref_papplet.setMatrix(this.getMarkerMatrix());
    }

    public void endTransform() {
        if (!this._is_in_begin_end_session) {
            this._ref_papplet.die("The function beginTransform is never called.", null);
        }
        this._is_in_begin_end_session = false;
        this._ref_papplet.popMatrix();
        PGraphicsOpenGL pgl = (PGraphicsOpenGL)this._ref_papplet.g;
        pgl.popProjection();
    }

    public PVector screen2MarkerCoordSystem(int i_x, int i_y) {
        PVector ret = new PVector();
        NyARDoublePoint3d tmp = new NyARDoublePoint3d();
        this._frustum.unProjectOnMatrix((double)i_x, (double)i_y, this._result, tmp);
        ret.x = (float)tmp.x;
        ret.y = (float)tmp.y;
        ret.z = (float)tmp.z;
        if (this._config._coordinate_system == 1) {
            ret.x *= -1.0f;
        }
        return ret;
    }

    public PImage pickupMarkerImage(int i_x1, int i_y1, int i_x2, int i_y2, int i_x3, int i_y3, int i_x4, int i_y4, int i_out_w_pix, int i_out_h_pix) {
        return this.pickupMarkerImage(this._result, i_x1, i_y1, i_x2, i_y2, i_x3, i_y3, i_x4, i_y4, i_out_w_pix, i_out_h_pix);
    }

    public PImage pickupRectMarkerImage(int i_l, int i_t, int i_w, int i_h, int i_out_w_pix, int i_out_h_pix) {
        return this.pickupMarkerImage(i_l + i_w - 1, i_t + i_h - 1, i_l, i_t + i_h - 1, i_l, i_t, i_l + i_w - 1, i_t, i_out_w_pix, i_out_h_pix);
    }

    protected void updateTransmat(NyARSquare i_square, NyARDoubleMatrix44 i_src) {
        this._result.setValue(i_src);
        SingleMarkerBaseClass.matResult2GLArray(i_src, this.transmat);
        i_src.getZXYAngle(this._tmp_d3p);
        this.angle.x = (float)this._tmp_d3p.x;
        this.angle.y = (float)this._tmp_d3p.y;
        this.angle.z = (float)this._tmp_d3p.z;
        this.trans.x = (float)i_src.m03;
        this.trans.y = (float)i_src.m13;
        this.trans.z = (float)i_src.m23;
        NyARDoublePoint2d[] pts = i_square.sqvertex;
        int i = 0;
        while (i < 4) {
            this.pos2d[i][0] = (int)pts[i].x;
            this.pos2d[i][1] = (int)pts[i].y;
            ++i;
        }
    }

    protected void initInstance(PApplet parent, String i_cparam_file, int i_width, int i_height, NyAR4PsgConfig i_config) throws NyARException {
        this._config = i_config;
        this._ar_param = NyARParam.createFromARParamFile((InputStream)parent.createInput(i_cparam_file));
        this._ar_param.changeScreenSize(i_width, i_height);
        this._src_raster = new PImageRaster(i_width, i_height);
        this._pcopy = (INyARPerspectiveCopy)this._src_raster.createInterface(INyARPerspectiveCopy.class);
        super.initInstance(parent, i_config);
        SingleMarkerBaseClass.PMatrix2GLProjection(this._ps_projection, this.transmat);
    }

    protected SingleMarkerBaseClass() {
    }

    protected PImage pickupMarkerImage(NyARDoubleMatrix44 i_mat, int i_x1, int i_y1, int i_x2, int i_y2, int i_x3, int i_y3, int i_x4, int i_y4, int i_out_w_pix, int i_out_h_pix) {
        if (!this._src_raster.hasBuffer()) {
            this._ref_papplet.die("_rel_detector is null.(Function detect() was never called. )");
        }
        PImage img = new PImage(i_out_w_pix, i_out_h_pix);
        img.parent = this._ref_papplet;
        try {
            NyARDoublePoint3d[] pos = NyARDoublePoint3d.createArray((int)4);
            i_mat.transform3d((double)i_x1, (double)i_y1, 0.0, pos[1]);
            i_mat.transform3d((double)i_x2, (double)i_y2, 0.0, pos[0]);
            i_mat.transform3d((double)i_x3, (double)i_y3, 0.0, pos[3]);
            i_mat.transform3d((double)i_x4, (double)i_y4, 0.0, pos[2]);
            NyARDoublePoint2d[] pos2 = NyARDoublePoint2d.createArray((int)4);
            int i = 3;
            while (i >= 0) {
                this._frustum.project(pos[i], pos2[i]);
                --i;
            }
            PImageRaster out_raster = new PImageRaster(i_out_w_pix, i_out_h_pix);
            out_raster.wrapBuffer(img);
            if (!this._pcopy.copyPatt(pos2, 0, 0, 1, (INyARRgbRaster)out_raster)) {
                throw new Exception("this._pcopy.copyPatt failed.");
            }
            img.updatePixels();
            return img;
        }
        catch (Exception e) {
            e.printStackTrace();
            this._ref_papplet.die("Exception occurred at MultiARTookitMarker.pickupImage");
            return null;
        }
    }
}

