/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.test;

import java.io.File;
import java.io.FileInputStream;
import java.util.Date;
import jp.nyatla.nyartoolkit.core.raster.rgb.NyARRgbRaster;
import jp.nyatla.nyartoolkit.core.types.matrix.NyARDoubleMatrix44;
import jp.nyatla.nyartoolkit.markersystem.NyARMarkerSystem;
import jp.nyatla.nyartoolkit.markersystem.NyARMarkerSystemConfig;
import jp.nyatla.nyartoolkit.markersystem.NyARSensor;

public class MarkerSystem {
    private static final String data_file = "../Data/320x240ABGR.raw";
    private static final String code_file = "../Data/patt.hiro";

    public static void main(String[] args) {
        try {
            File f = new File(data_file);
            FileInputStream fs = new FileInputStream(data_file);
            byte[] buf = new byte[(int)f.length()];
            fs.read(buf);
            NyARRgbRaster ra = new NyARRgbRaster(320, 240, 65793, false);
            ra.wrapBuffer(buf);
            NyARMarkerSystemConfig config = new NyARMarkerSystemConfig(320, 240);
            NyARSensor sensor = new NyARSensor(config.getScreenSize());
            NyARMarkerSystem s = new NyARMarkerSystem(config);
            int aid = s.addARMarker(new FileInputStream(code_file), 16, 25, 80.0);
            sensor.update(ra);
            s.update(sensor);
            Date d2 = new Date();
            int i = 0;
            while (i < 1000) {
                sensor.update(ra);
                s.update(sensor);
                ++i;
            }
            Date d = new Date();
            System.out.println(d.getTime() - d2.getTime());
            if (s.isExistMarker(aid)) {
                NyARDoubleMatrix44 mat = s.getMarkerMatrix(aid);
                System.out.println(s.getConfidence(aid));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

