/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.rasterdriver;

import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.raster.INyARRaster;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.rasterdriver.INyARPerspectiveCopy;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARIntPoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;
import jp.nyatla.nyartoolkit.core.utils.NyARPerspectiveParamGenerator;
import jp.nyatla.nyartoolkit.core.utils.NyARPerspectiveParamGenerator_O1;

public abstract class NyARPerspectiveCopy_Base
implements INyARPerspectiveCopy {
    private static final int LOCAL_LT = 1;
    protected NyARPerspectiveParamGenerator _perspective_gen;
    protected final double[] __pickFromRaster_cpara = new double[8];

    protected NyARPerspectiveCopy_Base() {
        this._perspective_gen = new NyARPerspectiveParamGenerator_O1(1, 1);
    }

    @Override
    public boolean copyPatt(double i_x1, double i_y1, double i_x2, double i_y2, double i_x3, double i_y3, double i_x4, double i_y4, int i_edge_x, int i_edge_y, int i_resolution, INyARRgbRaster i_out) throws NyARException {
        NyARIntSize out_size = i_out.getSize();
        int xe = out_size.w * i_edge_x / 50;
        int ye = out_size.h * i_edge_y / 50;
        if (i_resolution == 1) {
            if (!this._perspective_gen.getParam(xe * 2 + out_size.w, ye * 2 + out_size.h, i_x1, i_y1, i_x2, i_y2, i_x3, i_y3, i_x4, i_y4, this.__pickFromRaster_cpara)) {
                return false;
            }
            this.onePixel(xe + 1, ye + 1, this.__pickFromRaster_cpara, i_out);
        } else {
            if (!this._perspective_gen.getParam((xe * 2 + out_size.w) * i_resolution, (ye * 2 + out_size.h) * i_resolution, i_x1, i_y1, i_x2, i_y2, i_x3, i_y3, i_x4, i_y4, this.__pickFromRaster_cpara)) {
                return false;
            }
            this.multiPixel(xe * i_resolution + 1, ye * i_resolution + 1, this.__pickFromRaster_cpara, i_resolution, i_out);
        }
        return true;
    }

    @Override
    public boolean copyPatt(NyARDoublePoint2d[] i_vertex, int i_edge_x, int i_edge_y, int i_resolution, INyARRgbRaster i_out) throws NyARException {
        return this.copyPatt(i_vertex[0].x, i_vertex[0].y, i_vertex[1].x, i_vertex[1].y, i_vertex[2].x, i_vertex[2].y, i_vertex[3].x, i_vertex[3].y, i_edge_x, i_edge_y, i_resolution, i_out);
    }

    @Override
    public boolean copyPatt(NyARIntPoint2d[] i_vertex, int i_edge_x, int i_edge_y, int i_resolution, INyARRgbRaster i_out) throws NyARException {
        return this.copyPatt(i_vertex[0].x, i_vertex[0].y, i_vertex[1].x, i_vertex[1].y, i_vertex[2].x, i_vertex[2].y, i_vertex[3].x, i_vertex[3].y, i_edge_x, i_edge_y, i_resolution, i_out);
    }

    protected abstract boolean onePixel(int var1, int var2, double[] var3, INyARRaster var4) throws NyARException;

    protected abstract boolean multiPixel(int var1, int var2, double[] var3, int var4, INyARRaster var5) throws NyARException;
}

