/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.pixeldriver;

import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.pixeldriver.INyARRgbPixelDriver;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

final class NyARRgbPixelDriver_INT1D_X8R8G8B8_32
implements INyARRgbPixelDriver {
    private int[] _ref_buf;
    private NyARIntSize _ref_size;

    NyARRgbPixelDriver_INT1D_X8R8G8B8_32() {
    }

    @Override
    public NyARIntSize getSize() {
        return this._ref_size;
    }

    @Override
    public void getPixel(int i_x, int i_y, int[] o_rgb) {
        int rgb = this._ref_buf[i_x + i_y * this._ref_size.w];
        o_rgb[0] = rgb >> 16 & 0xFF;
        o_rgb[1] = rgb >> 8 & 0xFF;
        o_rgb[2] = rgb & 0xFF;
    }

    @Override
    public void getPixelSet(int[] i_x, int[] i_y, int i_num, int[] o_rgb) {
        int width = this._ref_size.w;
        int[] ref_buf = this._ref_buf;
        int i = i_num - 1;
        while (i >= 0) {
            int rgb = ref_buf[i_x[i] + i_y[i] * width];
            o_rgb[i * 3 + 0] = rgb >> 16 & 0xFF;
            o_rgb[i * 3 + 1] = rgb >> 8 & 0xFF;
            o_rgb[i * 3 + 2] = rgb & 0xFF;
            --i;
        }
    }

    @Override
    public void setPixel(int i_x, int i_y, int[] i_rgb) throws NyARException {
        this._ref_buf[i_x + i_y * this._ref_size.w] = i_rgb[0] << 16 | i_rgb[1] << 8 | i_rgb[2];
    }

    @Override
    public void setPixel(int i_x, int i_y, int i_r, int i_g, int i_b) throws NyARException {
        this._ref_buf[i_x + i_y * this._ref_size.w] = i_r << 16 | i_g << 8 | i_b;
    }

    @Override
    public void setPixels(int[] i_x, int[] i_y, int i_num, int[] i_intrgb) throws NyARException {
        NyARException.notImplement();
    }

    @Override
    public void switchRaster(INyARRgbRaster i_raster) throws NyARException {
        this._ref_buf = (int[])i_raster.getBuffer();
        this._ref_size = i_raster.getSize();
    }
}

