/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.rpf.tracker.nyartk;

import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.param.NyARCameraDistortionFactor;
import jp.nyatla.nyartoolkit.core.raster.NyARGrayscaleRaster;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARContourPickup;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARIntCoordinates;
import jp.nyatla.nyartoolkit.core.types.NyARIntPoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;
import jp.nyatla.nyartoolkit.core.types.NyARLinear;
import jp.nyatla.nyartoolkit.rpf.tracker.nyartk.INyARVectorReader;
import jp.nyatla.nyartoolkit.rpf.utils.VecLinearCoordinates;

public abstract class NyARVectorReader_Base
implements INyARVectorReader {
    private VecLinearCoordinates.VecLinearCoordinatePoint[] _tmp_coord_pos;
    private int _rob_resolution;
    protected NyARGrayscaleRaster _ref_base_raster;
    private NyARGrayscaleRaster _ref_rob_raster;
    protected NyARCameraDistortionFactor _factor;
    protected NyARIntCoordinates _coord_buf;
    private NyARContourPickup _cpickup;
    protected final double _MARGE_ANG_TH = 0.9848;
    private NyARIntPoint2d[] __pt = NyARIntPoint2d.createArray(2);
    private NyARLinear __temp_l = new NyARLinear();

    protected NyARVectorReader_Base() {
    }

    public void initInstance(NyARGrayscaleRaster i_ref_raster, NyARCameraDistortionFactor i_ref_raster_distortion, NyARGrayscaleRaster i_ref_rob_raster, NyARContourPickup i_contour_pickup) {
        this._rob_resolution = i_ref_raster.getWidth() / i_ref_rob_raster.getWidth();
        this._ref_rob_raster = i_ref_rob_raster;
        this._ref_base_raster = i_ref_raster;
        this._coord_buf = new NyARIntCoordinates((i_ref_raster.getWidth() + i_ref_raster.getHeight()) * 4);
        this._factor = i_ref_raster_distortion;
        this._tmp_coord_pos = VecLinearCoordinates.VecLinearCoordinatePoint.createArray(this._coord_buf.items.length);
        this._cpickup = i_contour_pickup;
    }

    @Override
    public boolean traceConture(int i_th, NyARIntPoint2d i_entry, VecLinearCoordinates o_coord) throws NyARException {
        NyARIntCoordinates coord = this._coord_buf;
        if (!this._cpickup.getContour(this._ref_rob_raster, i_th, i_entry.x, i_entry.y, coord)) {
            return false;
        }
        return this.traceConture(coord, this._rob_resolution, this._rob_resolution * 2, o_coord);
    }

    @Override
    public boolean traceLine(NyARIntPoint2d i_pos1, NyARIntPoint2d i_pos2, int i_edge, VecLinearCoordinates o_coord) {
        NyARIntCoordinates coord = this._coord_buf;
        NyARIntSize base_s = this._ref_base_raster.getSize();
        int dist = (int)Math.sqrt(i_pos1.sqDist(i_pos2));
        if (dist < 4) {
            return false;
        }
        if (dist > 12) {
            dist = 12;
        }
        int s = i_edge * 2 + 1;
        int dx = i_pos2.x - i_pos1.x;
        int dy = i_pos2.y - i_pos1.y;
        int r = base_s.w - s;
        int b = base_s.h - s;
        int i = 1;
        while (i < dist - 1) {
            int x = i * dx / dist + i_pos1.x - i_edge;
            int y = i * dy / dist + i_pos1.y - i_edge;
            coord.items[i - 1].x = x < 0 ? 0 : (x >= r ? r : x);
            coord.items[i - 1].y = y < 0 ? 0 : (y >= b ? b : y);
            ++i;
        }
        coord.length = dist - 2;
        return this.traceConture(coord, 1, s, o_coord);
    }

    @Override
    public boolean traceLine(NyARDoublePoint2d i_pos1, NyARDoublePoint2d i_pos2, int i_edge, VecLinearCoordinates o_coord) {
        NyARIntCoordinates coord = this._coord_buf;
        NyARIntSize base_s = this._ref_base_raster.getSize();
        int dist = (int)Math.sqrt(i_pos1.sqDist(i_pos2));
        if (dist < 4) {
            return false;
        }
        if (dist > 12) {
            dist = 12;
        }
        int s = i_edge * 2 + 1;
        int dx = (int)(i_pos2.x - i_pos1.x);
        int dy = (int)(i_pos2.y - i_pos1.y);
        int r = base_s.w - s;
        int b = base_s.h - s;
        int i = 1;
        while (i < dist - 1) {
            int x = (int)((double)(i * dx / dist) + i_pos1.x - (double)i_edge);
            int y = (int)((double)(i * dy / dist) + i_pos1.y - (double)i_edge);
            coord.items[i - 1].x = x < 0 ? 0 : (x >= r ? r : x);
            coord.items[i - 1].y = y < 0 ? 0 : (y >= b ? b : y);
            ++i;
        }
        coord.length = dist - 2;
        return this.traceConture(coord, 1, s, o_coord);
    }

    private static final boolean checkVecCos(VecLinearCoordinates.VecLinearCoordinatePoint i_current_vec, VecLinearCoordinates.VecLinearCoordinatePoint i_prev_vec, double i_ave_dx, double i_ave_dy) {
        double x1 = i_current_vec.dx;
        double y1 = i_current_vec.dy;
        double d = (x1 * i_ave_dx + y1 * i_ave_dy) / 0.9396;
        double n = x1 * x1 + y1 * y1;
        return d * d < n * (i_ave_dx * i_ave_dx + i_ave_dy * i_ave_dy) && (d = (x1 * i_prev_vec.dx + y1 * i_prev_vec.dy) / 0.9961) * d < n * (i_prev_vec.dx * i_prev_vec.dx + i_prev_vec.dy * i_prev_vec.dy);
    }

    @Override
    public boolean traceConture(NyARIntCoordinates i_coord, int i_pos_mag, int i_cell_size, VecLinearCoordinates o_coord) {
        VecLinearCoordinates.VecLinearCoordinatePoint pos_ptr;
        double sq;
        assert (i_cell_size <= 45);
        VecLinearCoordinates.VecLinearCoordinatePoint[] pos = this._tmp_coord_pos;
        int MAX_COORD = o_coord.items.length;
        int i_coordlen = i_coord.length;
        NyARIntPoint2d[] coord = i_coord.items;
        int number_of_data = 0;
        int sq_sum = 0;
        pos[0].scalar = sq = (double)this.getAreaVector33(coord[0].x * i_pos_mag, coord[0].y * i_pos_mag, i_cell_size, i_cell_size, pos[0]);
        sq_sum += (int)sq;
        int coord_last_edge = i_coordlen;
        int sum = 1;
        double ave_dx = pos[0].dx;
        double ave_dy = pos[0].dy;
        int i = i_coordlen - 1;
        while (i > 0) {
            pos_ptr = pos[sum];
            pos_ptr.scalar = sq = (double)this.getAreaVector33(coord[i].x * i_pos_mag, coord[i].y * i_pos_mag, i_cell_size, i_cell_size, pos_ptr);
            sq_sum += (int)sq;
            if (NyARVectorReader_Base.checkVecCos(pos[sum], pos[sum - 1], ave_dx, ave_dy)) {
                ave_dx = pos_ptr.dx;
                ave_dy = pos_ptr.dy;
                coord_last_edge = i;
                break;
            }
            ave_dx += pos_ptr.dx;
            ave_dy += pos_ptr.dy;
            ++sum;
            --i;
        }
        i = 1;
        while (i < coord_last_edge) {
            pos_ptr = pos[sum];
            pos_ptr.scalar = sq = (double)this.getAreaVector33(coord[i].x * i_pos_mag, coord[i].y * i_pos_mag, i_cell_size, i_cell_size, pos_ptr);
            sq_sum += (int)sq;
            if (sq != 0.0) {
                if (NyARVectorReader_Base.checkVecCos(pos[sum], pos[sum - 1], ave_dx, ave_dy)) {
                    if (this.leastSquaresWithNormalize(pos, sum, o_coord.items[number_of_data], sq_sum / (sum * 5))) {
                        ++number_of_data;
                    }
                    ave_dx = pos_ptr.dx;
                    ave_dy = pos_ptr.dy;
                    pos[0].setValue(pos[sum]);
                    sq_sum = 0;
                    sum = 1;
                } else {
                    ave_dx += pos_ptr.dx;
                    ave_dy += pos_ptr.dy;
                    ++sum;
                }
                if (number_of_data == MAX_COORD) {
                    return false;
                }
            }
            ++i;
        }
        if (this.leastSquaresWithNormalize(pos, sum, o_coord.items[number_of_data], sq_sum / (sum * 5))) {
            ++number_of_data;
        }
        o_coord.length = number_of_data;
        return true;
    }

    private final boolean leastSquaresWithNormalize(VecLinearCoordinates.VecLinearCoordinatePoint[] i_points, int i_number_of_data, VecLinearCoordinates.VecLinearCoordinatePoint o_dest, double i_scale_th) {
        int num = 0;
        double sum_xy = 0.0;
        double sum_x = 0.0;
        double sum_y = 0.0;
        double sum_x2 = 0.0;
        int i = i_number_of_data - 1;
        while (i >= 0) {
            VecLinearCoordinates.VecLinearCoordinatePoint ptr = i_points[i];
            if (!(ptr.scalar < i_scale_th)) {
                double xw = ptr.x;
                sum_xy += xw * ptr.y;
                sum_x += xw;
                sum_y += ptr.y;
                sum_x2 += xw * xw;
                ++num;
            }
            --i;
        }
        if (num < 3) {
            return false;
        }
        double la = -((double)num * sum_x2 - sum_x * sum_x);
        double lb = -((double)num * sum_xy - sum_x * sum_y);
        double cc = sum_x2 * sum_y - sum_xy * sum_x;
        double lc = -(la * sum_x + lb * sum_y) / (double)num;
        double w1 = -lb * lb - la * la;
        if (w1 == 0.0) {
            return false;
        }
        o_dest.x = (la * lc - lb * cc) / w1;
        o_dest.y = (la * cc + lb * lc) / w1;
        o_dest.dy = -lb;
        o_dest.dx = -la;
        o_dest.scalar = num;
        return true;
    }

    @Override
    public boolean traceLineWithClip(NyARDoublePoint2d i_pos1, NyARDoublePoint2d i_pos2, int i_edge, VecLinearCoordinates o_coord) throws NyARException {
        NyARIntSize s = this._ref_base_raster.getSize();
        NyARIntPoint2d[] pt = this.__pt;
        boolean is_p1_inside_area = s.isInnerPoint(i_pos1);
        boolean is_p2_inside_area = s.isInnerPoint(i_pos2);
        if (is_p1_inside_area && is_p2_inside_area) {
            return this.traceLine(i_pos1, i_pos2, i_edge, o_coord);
        }
        if (!this.__temp_l.makeLinearWithNormalize(i_pos1, i_pos2)) {
            return false;
        }
        if (!this.__temp_l.makeSegmentLine(s.w, s.h, pt)) {
            return false;
        }
        if (is_p1_inside_area != is_p2_inside_area) {
            if (is_p1_inside_area) {
                pt[i_pos2.sqDist(pt[0]) < i_pos2.sqDist(pt[1]) ? 1 : 0].setValue(i_pos1);
            } else {
                pt[i_pos1.sqDist(pt[0]) < i_pos2.sqDist(pt[1]) ? 1 : 0].setValue(i_pos2);
            }
        } else {
            if (!this.__temp_l.makeLinearWithNormalize(i_pos1, i_pos2)) {
                return false;
            }
            if (!this.__temp_l.makeSegmentLine(s.w, s.h, pt)) {
                return false;
            }
        }
        return this.traceLine(pt[0], pt[1], i_edge, o_coord);
    }
}

