/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.markersystem.utils;

import java.util.ArrayList;
import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.match.NyARMatchPattDeviationColorData;
import jp.nyatla.nyartoolkit.core.match.NyARMatchPattResult;
import jp.nyatla.nyartoolkit.core.rasterdriver.INyARPerspectiveCopy;
import jp.nyatla.nyartoolkit.core.types.NyARIntPoint2d;
import jp.nyatla.nyartoolkit.markersystem.utils.ARMarkerSortList;
import jp.nyatla.nyartoolkit.markersystem.utils.MarkerInfoARMarker;
import jp.nyatla.nyartoolkit.markersystem.utils.MultiResolutionPattProvider;
import jp.nyatla.nyartoolkit.markersystem.utils.SquareStack;

public class ARMarkerList
extends ArrayList<MarkerInfoARMarker> {
    private static final long serialVersionUID = 1L;
    private double _configense_th = 0.5;
    private final NyARMatchPattResult _patt_result = new NyARMatchPattResult();
    private final MultiResolutionPattProvider _mpickup = new MultiResolutionPattProvider();
    private ARMarkerSortList _mkmap = new ARMarkerSortList();

    @Override
    public boolean add(MarkerInfoARMarker i_e) {
        int s = this.size() + 1;
        while (this._mkmap.getLength() < s * s) {
            this._mkmap.append();
        }
        return super.add(i_e);
    }

    public void setConficenceTh(double i_th) {
        this._configense_th = i_th;
    }

    public boolean update(INyARPerspectiveCopy i_pix_drv, SquareStack.Item i_sq) throws NyARException {
        boolean is_ganalated_sq = false;
        int i = this.size() - 1;
        while (i >= 0) {
            ARMarkerSortList.Item ip;
            MarkerInfoARMarker target = (MarkerInfoARMarker)this.get(i);
            NyARMatchPattDeviationColorData diff = this._mpickup.getDeviationColorData(target, i_pix_drv, i_sq.ob_vertex);
            if (target.matchpatt.evaluate(diff, this._patt_result) && !(this._patt_result.confidence < this._configense_th) && (ip = this._mkmap.getInsertPoint(this._patt_result.confidence)) != null) {
                ip = this._mkmap.insertFromTailBefore(ip);
                ip.cf = this._patt_result.confidence;
                ip.dir = this._patt_result.direction;
                ip.marker = target;
                ip.ref_sq = i_sq;
                is_ganalated_sq = true;
            }
            --i;
        }
        return is_ganalated_sq;
    }

    public void prepare() {
        this._mkmap.reset();
        int i = this.size() - 1;
        while (i >= 0) {
            MarkerInfoARMarker target = (MarkerInfoARMarker)this.get(i);
            if (target.life > 0L) {
                target.lost_count = target.lost_count + 1;
            }
            --i;
        }
    }

    public void finish() {
        ARMarkerSortList.Item top_item = this._mkmap.getTopItem();
        while (top_item != null) {
            MarkerInfoARMarker target = top_item.marker;
            if (target.lost_count > 0) {
                target.cf = top_item.cf;
                target.lost_count = 0;
                target.life = target.life + 1L;
                target.sq = top_item.ref_sq;
                target.sq.rotateVertexL(4 - top_item.dir);
                NyARIntPoint2d.shiftCopy(top_item.ref_sq.ob_vertex, target.tl_vertex, 4 - top_item.dir);
                target.tl_center.setValue(top_item.ref_sq.center2d);
                target.tl_rect_area = top_item.ref_sq.rect_area;
            }
            this._mkmap.disableMatchItem(top_item);
            top_item = this._mkmap.getTopItem();
        }
    }
}

