/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.markersystem;

import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.raster.INyARGrayscaleRaster;
import jp.nyatla.nyartoolkit.core.rasterdriver.INyARPerspectiveCopy;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARCoord2Linear;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARSquareContourDetector_Rle;
import jp.nyatla.nyartoolkit.core.transmat.INyARTransMat;
import jp.nyatla.nyartoolkit.core.types.NyARIntCoordinates;
import jp.nyatla.nyartoolkit.markersystem.INyARMarkerSystemConfig;
import jp.nyatla.nyartoolkit.markersystem.NyARSensor;
import jp.nyatla.nyartoolkit.markersystem.utils.ARMarkerList;
import jp.nyatla.nyartoolkit.markersystem.utils.MarkerInfoARMarker;
import jp.nyatla.nyartoolkit.markersystem.utils.MarkerInfoNyId;
import jp.nyatla.nyartoolkit.markersystem.utils.NyIdList;
import jp.nyatla.nyartoolkit.markersystem.utils.SquareStack;
import jp.nyatla.nyartoolkit.markersystem.utils.TMarkerData;
import jp.nyatla.nyartoolkit.markersystem.utils.TrackingList;

class RleDetector
extends NyARSquareContourDetector_Rle {
    private static final int INITIAL_MARKER_STACK_SIZE = 10;
    private NyARCoord2Linear _coordline;
    private SquareStack _sq_stack;
    public int lost_th = 5;
    public TrackingList _tracking_list;
    public ARMarkerList _armk_list;
    public NyIdList _idmk_list;
    public INyARTransMat _transmat;
    private INyARPerspectiveCopy _ref_input_rfb;
    private INyARGrayscaleRaster _ref_input_gs;

    public RleDetector(INyARMarkerSystemConfig i_config) throws NyARException {
        super(i_config.getNyARParam().getScreenSize());
        this._coordline = new NyARCoord2Linear(i_config.getNyARParam().getScreenSize(), i_config.getNyARParam().getDistortionFactor());
        this._armk_list = new ARMarkerList();
        this._idmk_list = new NyIdList();
        this._tracking_list = new TrackingList();
        this._transmat = i_config.createTransmatAlgorism();
        this._sq_stack = new SquareStack(10);
    }

    @Override
    protected void onSquareDetect(NyARIntCoordinates i_coord, int[] i_vertex_index) throws NyARException {
        SquareStack.Item sq_tmp = (SquareStack.Item)this._sq_stack.prePush();
        int i2 = 0;
        while (i2 < 4) {
            sq_tmp.ob_vertex[i2].setValue(i_coord.items[i_vertex_index[i2]]);
            ++i2;
        }
        sq_tmp.vertex_area.setAreaRect(sq_tmp.ob_vertex, 4);
        sq_tmp.center2d.setCenterPos(sq_tmp.ob_vertex, 4);
        sq_tmp.rect_area = sq_tmp.vertex_area.w * sq_tmp.vertex_area.h;
        boolean is_target_marker = false;
        if (this._tracking_list.update(sq_tmp)) {
            is_target_marker = true;
        } else if (this._idmk_list.size() > 0 && this._idmk_list.update(this._ref_input_gs, sq_tmp)) {
            is_target_marker = true;
        } else if (this._armk_list.size() > 0 && this._armk_list.update(this._ref_input_rfb, sq_tmp)) {
            is_target_marker = true;
        }
        if (is_target_marker) {
            int i22 = 0;
            while (i22 < 4) {
                this._coordline.coord2Line(i_vertex_index[i22], i_vertex_index[(i22 + 1) % 4], i_coord, sq_tmp.line[i22]);
                ++i22;
            }
            i22 = 0;
            while (i22 < 4) {
                if (!sq_tmp.line[i22].crossPos(sq_tmp.line[(i22 + 3) % 4], sq_tmp.sqvertex[i22])) {
                    throw new NyARException();
                }
                ++i22;
            }
        } else {
            this._sq_stack.pop();
        }
    }

    public void detectMarker(NyARSensor i_sensor, long i_time_stamp, int i_th) throws NyARException {
        TMarkerData target;
        this._sq_stack.clear();
        this._tracking_list.prepare();
        this._idmk_list.prepare();
        this._armk_list.prepare();
        this._ref_input_rfb = i_sensor.getPerspectiveCopy();
        this._ref_input_gs = i_sensor.getGsImage();
        super.detectMarker(this._ref_input_gs, i_th);
        this._tracking_list.finish();
        this._armk_list.finish();
        this._idmk_list.finish();
        int i = this._tracking_list.size() - 1;
        while (i >= 0) {
            TMarkerData item = (TMarkerData)this._tracking_list.get(i);
            if (item.lost_count > this.lost_th) {
                item.life = 0L;
            }
            --i;
        }
        i = this._armk_list.size() - 1;
        while (i >= 0) {
            target = (MarkerInfoARMarker)this._armk_list.get(i);
            if (target.lost_count == 0) {
                target.time_stamp = i_time_stamp;
                this._transmat.transMatContinue(target.sq, target.marker_offset, target.tmat, target.tmat);
            }
            --i;
        }
        i = this._idmk_list.size() - 1;
        while (i >= 0) {
            target = (MarkerInfoNyId)this._idmk_list.get(i);
            if (((MarkerInfoNyId)target).lost_count == 0) {
                ((MarkerInfoNyId)target).time_stamp = i_time_stamp;
                this._transmat.transMatContinue(((MarkerInfoNyId)target).sq, ((MarkerInfoNyId)target).marker_offset, ((MarkerInfoNyId)target).tmat, ((MarkerInfoNyId)target).tmat);
            }
            --i;
        }
    }
}

