package jp.android_group.artoolkit;

import java.io.InputStream;

import jp.android_group.artoolkit.model.VoicePlayer;
import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.NyARCode;
import jp.nyatla.nyartoolkit.core.param.NyARParam;
import jp.nyatla.nyartoolkit.core.raster.rgb.NyARRgbRaster_RGB;
import jp.nyatla.nyartoolkit.core.transmat.NyARTransMatResult;
import jp.nyatla.nyartoolkit.core.types.NyARBufferType;
import jp.nyatla.nyartoolkit.detector.NyARSingleDetectMarker;
import jp.nyatla.nyartoolkit.jogl.utils.NyARGLUtil;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Log;

public class ARToolkitDrawer {
	
	private NyARSingleDetectMarker nya = null;
	private NyARRgbRaster_RGB raster = null;
	private NyARGLUtil ar_util = null;
	private NyARParam ar_param = null;
	private NyARCode ar_code = null;
	private NyARTransMatResult ar_transmat_result = new NyARTransMatResult();

	
	private ModelRenderer mRenderer = null;
	private InputStream camePara = null;
	private InputStream patt = null;
	
	private VoicePlayer mVoiceSound = null;
	
	public ARToolkitDrawer(InputStream camePara, InputStream patt, ModelRenderer mRenderer) {
		this.camePara = camePara;
		this.patt = patt;
		this.mRenderer = mRenderer;
	}
	
	private void createNyARTool(int w, int h) {
		// NyARToolkit setting.
		try {
			if (ar_param == null) {
				ar_util = new NyARGLUtil();
				ar_param = new NyARParam();
				ar_param.loadARParam(camePara);
				ar_code = new NyARCode(16, 16);
				ar_code.loadARPatt(patt);
				//TODO 本当は、ここはifの外でないと行けない。だけど、出すとOutOfMemory
				ar_param.changeScreenSize(w, h);
				nya = new NyARSingleDetectMarker(ar_param, ar_code, 80.0, NyARBufferType.BYTE1D_B8G8R8_24);
				nya.setContinueMode(false);
			}
			Log.d("nyar", "resources have been loaded");
		} catch (Exception e) {
			Log.e("nyar", "resource loading failed", e);
		}

	}

	public void setVoicePlayer(VoicePlayer mVoiceSound) {
		this.mVoiceSound = mVoiceSound;
	}

	public void draw(byte[] data) {
		
		if(data == null) {
			Log.d("AR draw", "data= null");
			return;
		}
		Log.d("AR draw", "data.length= " + data.length);
		
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inSampleSize = 4;
        Bitmap bitmap = BitmapFactory.decodeByteArray(data, 0, data.length, options);
		if(bitmap.getHeight() < 240) {
			bitmap = BitmapFactory.decodeByteArray(data, 0, data.length);
		}

		if (bitmap == null) {
			Log.d("AR draw", "data is not BitMap data.");
			return;
		}
					
		Log.d("AR draw", "bitmap.getHeight()= " + bitmap.getHeight());
		Log.d("AR draw", "bitmap.getWidth()= " + bitmap.getWidth());
		mRenderer.setBgBitmap(bitmap);
		// start coordinates calculation.
		int w = bitmap.getWidth();
		int h = bitmap.getHeight();
		int[] pixels = new int[w * h];
		byte[] buf = new byte[pixels.length * 3];
		float[] resultf = new float[16];
		
		boolean is_marker_exist = false;
		bitmap.getPixels(pixels, 0, w, 0, 0, w, h);
		Log.d("AR draw", "pixels:" + pixels.length);

		for (int i = 0; i < pixels.length; i++) {
			int argb = pixels[i];
			// byte a = (byte) (argb & 0xFF000000 >> 24);
			byte r = (byte) (argb & 0x00FF0000 >> 16);
			byte g = (byte) (argb & 0x0000FF00 >> 8);
			byte b = (byte) (argb & 0x000000FF);
			buf[i * 3] = r;
			buf[i * 3 + 1] = g;
			buf[i * 3 + 2] = b;
			argb = pixels[i];
		}
		
		createNyARTool(w, h);
		// Marker detection 
		try {
			Log.d("AR draw", "Marker detection.");
			raster = new NyARRgbRaster_RGB(w, h);
			raster.wrapBuffer(buf);
			is_marker_exist = nya.detectMarkerLite(raster, 100);
		} catch (NyARException e) {
			Log.e("AR draw", "marker detection failed", e);
			return;
		}
		
		// An OpenGL object will be drawn if matched.
		if (is_marker_exist) {
			Log.d("AR draw", "!!!!!!!!!!!exist marker.!!!!!!!!!!!");
			// Projection transformation.
			float[] cameraRHf = new float[16];
			ar_util.toCameraFrustumRHf(ar_param, cameraRHf);
			try {
				NyARTransMatResult transmat_result = ar_transmat_result;
				nya.getTransmationMatrix(transmat_result);
				ar_util.toCameraViewRHf(transmat_result, resultf);
			} catch (NyARException e) {
				Log.e("AR draw", "getCameraViewRH failed", e);
				return;
			}
			mRenderer.objectPointChanged(resultf, cameraRHf);
			if(mVoiceSound != null)
				mVoiceSound.startVoice();
		} else {
			Log.d("AR draw", "not exist marker.");
			if(mVoiceSound != null)
				mVoiceSound.stopVoice();
			mRenderer.objectClear();
		}

	}
	
}
