/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.util.GLLib;

import android.content.res.AssetManager;
import android.util.Log;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import javax.microedition.khronos.opengles.GL11;
import jp.nyatla.util.GLLib.KGLException;
import jp.nyatla.util.GLLib.KGLMetaseq;
import jp.nyatla.util.GLLib.KGLTextures;

public class KGLModelData {
    protected KGLTextures texPool = null;
    protected boolean isMakeTexPool = false;
    protected boolean isUseVBO = false;
    protected GLObject[] glObj;
    private GLMaterial changeMat;

    public static KGLModelData createGLModel(GL11 gl, KGLTextures in_texPool, AssetManager am, String msqname, float scale) throws KGLException {
        return new KGLMetaseq(gl, in_texPool, am, msqname, scale);
    }

    public void Clear(GL11 gl) {
        if (this.glObj == null) {
            return;
        }
        this.glObj = null;
        if (this.isMakeTexPool) {
            this.texPool.Clear(gl);
            this.texPool = null;
        }
    }

    protected KGLModelData(KGLTextures in_texPool, AssetManager am, float scale) {
        this.texPool = in_texPool;
        this.glObj = null;
        if (this.texPool == null) {
            this.texPool = new KGLTextures(am);
            this.isMakeTexPool = true;
        }
    }

    public void objectVisible(String objectName, boolean isVisible) {
        if (this.glObj == null) {
            return;
        }
        int o = 0;
        while (o < this.glObj.length) {
            if (objectName.equals(this.glObj[o].name)) {
                this.glObj[o].isVisible = isVisible;
                break;
            }
            ++o;
        }
    }

    public void materialVisible(String materialtName, boolean isVisible) {
        if (this.glObj == null) {
            return;
        }
        int o = 0;
        while (o < this.glObj.length) {
            int m = 0;
            while (m < this.glObj[o].mat.length) {
                if (materialtName.equals(this.glObj[o].mat[m].name)) {
                    this.glObj[o].mat[m].isVisible = isVisible;
                    break;
                }
                ++m;
            }
            ++o;
        }
    }

    public void materialVisible(String objectName, String materialtName, boolean isVisible) {
        if (this.glObj == null) {
            return;
        }
        int o = 0;
        while (o < this.glObj.length) {
            if (objectName.equals(this.glObj[o].name)) {
                int m = 0;
                while (m < this.glObj[o].mat.length) {
                    if (materialtName.equals(this.glObj[o].mat[m].name)) {
                        this.glObj[o].mat[m].isVisible = isVisible;
                        break;
                    }
                    ++m;
                }
            }
            ++o;
        }
    }

    public void enables(GL11 gl, float scale) {
        gl.glFrontFace(2304);
        gl.glCullFace(1029);
        gl.glEnable(2884);
        gl.glEnable(2929);
        gl.glEnable(3008);
        if ((double)scale != 1.0) {
            gl.glScalef(scale, scale, scale);
            gl.glEnable(2977);
        }
        gl.glTexParameterx(3553, 10242, 33071);
        gl.glTexParameterx(3553, 10243, 33071);
        gl.glEnable(3553);
    }

    public void disables(GL11 gl) {
        gl.glDisable(3553);
        gl.glDisable(2977);
        gl.glDisable(3008);
        gl.glDisable(2929);
        gl.glDisableClientState(32888);
        gl.glDisableClientState(32886);
    }

    public void draw(GL11 gl) {
        this.draw(gl, 1.0f);
    }

    public void setDefaultChangeMat() {
        this.changeMat = new GLMaterial();
        this.changeMat.name = "";
        float[] fv = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        this.changeMat.color = fv;
        this.changeMat.dif = fv;
    }

    public void draw(GL11 gl, float alpha) {
        float[] fw = new float[4];
        if (this.glObj == null) {
            return;
        }
        gl.glPushMatrix();
        int o = 0;
        while (o < this.glObj.length) {
            GLObject glo = this.glObj[o];
            if (glo != null && glo.isVisible) {
                int m = 0;
                while (m < glo.mat.length) {
                    GLMaterial mat = glo.mat[m];
                    if (mat != null && mat.isVisible) {
                        if (this.changeMat != null) {
                            GLMaterial oldMat = mat;
                            mat = this.changeMat;
                            mat.vertex_num = oldMat.vertex_num;
                            mat.uvBuffer = oldMat.uvBuffer;
                            mat.colBuffer = oldMat.colBuffer;
                            mat.vertexBuffer = oldMat.vertexBuffer;
                            mat.normalBuffer = oldMat.normalBuffer;
                        }
                        boolean useAlpha = false;
                        if (mat.shadeMode_IsSmooth) {
                            gl.glShadeModel(7425);
                        } else {
                            gl.glShadeModel(7424);
                        }
                        gl.glColor4f(mat.color[0], mat.color[1], mat.color[2], mat.color[3]);
                        if (mat.dif != null) {
                            System.arraycopy(mat.dif, 0, fw, 0, mat.dif.length);
                            fw[3] = fw[3] * alpha;
                            gl.glMaterialfv(1032, 4609, fw, 0);
                            boolean bl = useAlpha = fw[3] < 1.0f;
                        }
                        if (mat.amb != null) {
                            gl.glMaterialfv(1032, 4608, mat.amb, 0);
                        }
                        if (mat.spc != null) {
                            System.arraycopy(mat.spc, 0, fw, 0, mat.spc.length);
                            fw[3] = fw[3] * alpha;
                            gl.glMaterialfv(1032, 4610, fw, 0);
                        }
                        if (mat.emi != null) {
                            gl.glMaterialfv(1032, 5632, mat.emi, 0);
                        }
                        if (mat.power != null) {
                            gl.glMaterialf(1032, 5633, mat.power[0]);
                        }
                        if (mat.texID != 0) {
                            gl.glBindTexture(3553, mat.texID);
                            gl.glTexEnvx(8960, 8704, 8448);
                        }
                        if (useAlpha) {
                            gl.glEnable(3042);
                            gl.glBlendFunc(770, 771);
                        } else {
                            gl.glDisable(3042);
                        }
                        if (mat.uvValid) {
                            mat.uvBuffer.position(0);
                            gl.glTexCoordPointer(2, 5126, 0, (Buffer)mat.uvBuffer);
                            gl.glEnableClientState(32888);
                        } else {
                            gl.glDisableClientState(32888);
                        }
                        if (mat.colValid) {
                            mat.colBuffer.position(0);
                            gl.glColorPointer(4, 5126, 0, (Buffer)mat.colBuffer);
                            gl.glEnableClientState(32886);
                        } else {
                            gl.glDisableClientState(32886);
                        }
                        mat.vertexBuffer.position(0);
                        mat.normalBuffer.position(0);
                        gl.glVertexPointer(3, 5126, 0, (Buffer)mat.vertexBuffer);
                        gl.glNormalPointer(5126, 0, (Buffer)mat.normalBuffer);
                        gl.glEnableClientState(32885);
                        gl.glEnableClientState(32884);
                        gl.glDrawArrays(4, 0, mat.vertex_num);
                        if (mat.texID != 0) {
                            gl.glBindTexture(3553, 0);
                        }
                    }
                    ++m;
                }
            }
            ++o;
        }
        gl.glPopMatrix();
    }

    public String toString() {
        String ret = null;
        String retCode = (String)System.getProperties().get("line.separator");
        StringBuffer sb = new StringBuffer();
        if (this.glObj == null) {
            return "\u30c7\u30fc\u30bf\u306a\u3057";
        }
        sb.append("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u540d(\u30de\u30c6\u30ea\u30a2\u30eb\u540d,...\uff09").append(retCode);
        int o = 0;
        while (o < this.glObj.length) {
            sb.append(this.glObj[o].name).append("(");
            int m = 0;
            while (m < this.glObj[o].mat.length) {
                sb.append(this.glObj[o].mat[m].name).append(",");
                ++m;
            }
            sb.append(")").append(retCode);
            ++o;
        }
        ret = sb.toString();
        return ret;
    }

    public void reloadTexture(GL11 gl) {
        int o = 0;
        while (o < this.glObj.length) {
            GLObject glo = this.glObj[o];
            if (glo != null) {
                int m = 0;
                while (m < glo.mat.length) {
                    GLMaterial mat = glo.mat[m];
                    if (mat.texName != null) {
                        mat.texID = this.texPool.getGLTexture(gl, mat.texName, mat.alphaTexName, true);
                    }
                    ++m;
                }
            }
            ++o;
        }
    }

    public void resetTexture() {
        int o = 0;
        while (o < this.glObj.length) {
            GLObject glo = this.glObj[o];
            if (glo != null) {
                int m = 0;
                while (m < glo.mat.length) {
                    GLMaterial mat = glo.mat[m];
                    if (mat.texName != null) {
                        this.texPool.reset(null, mat.texName, mat.alphaTexName);
                    }
                    ++m;
                }
            }
            ++o;
        }
    }

    protected class GLMaterial {
        String name;
        boolean isVisible = true;
        float[] color = null;
        float[] dif = null;
        float[] amb = null;
        float[] emi = null;
        float[] spc = null;
        float[] power = null;
        boolean shadeMode_IsSmooth = true;
        int vertex_num;
        int texID = 0;
        String texName = null;
        String alphaTexName = null;
        ByteBuffer vertexBuffer;
        ByteBuffer normalBuffer;
        ByteBuffer uvBuffer = null;
        ByteBuffer colBuffer = null;
        boolean uvValid = false;
        boolean colValid = false;

        protected GLMaterial() {
        }
    }

    protected class GLObject {
        String name = null;
        boolean isVisible = true;
        GLMaterial[] mat = null;
        int[] VBO_ids = null;

        protected GLObject() {
        }
    }

    protected class multiInput {
        private BufferedInputStream bis = null;

        public multiInput(InputStream is) {
            this.bis = new BufferedInputStream(is);
        }

        public int read(byte[] b) throws IOException {
            return this.bis.read(b);
        }

        public void close() throws IOException {
            this.bis.close();
        }

        public String readLine() {
            String ret = null;
            try {
                int idata;
                this.bis.mark(256);
                int len = 0;
                boolean retnum = false;
                while ((idata = this.bis.read()) != -1) {
                    if (idata == 10) {
                        ++len;
                        break;
                    }
                    if (idata == 13) {
                        ++len;
                        continue;
                    }
                    if (retnum) break;
                    ++len;
                }
                byte[] b = new byte[len];
                this.bis.reset();
                this.bis.read(b);
                BufferedReader br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(b)), 8192);
                ret = br.readLine();
            }
            catch (Exception e) {
                Log.e((String)"KGLModelData", (String)"readLine", (Throwable)e);
            }
            return ret;
        }
    }
}

