<?php
/**
 * NP_Uranai.php
 * 
 * This program is Nucleus Plugin.
 * ===========================================================================
 * This program is free software and open source software; you can redistribute
 * it and/or modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  or visit
 * http://www.gnu.org/licenses/gpl.html
 * ===========================================================================
 * 
 * @author  takab<http://d.hatena.ne.jp/nucsl/>
 * @license http://www.gnu.org/licenses/gpl.html GNU General Public License
 * @since   2006/05/22
 * @version CSV: $Id$
 */
// plugin needs to work on Nucleus versions <=2.0 as well
if (!function_exists('sql_table')) {
    function sql_table($name) {
        return 'nucleus_'.$name;
    }
}
if (!function_exists('echoh')) {
    function echoh($str) {
        echo htmlspecialchars($str);
    }
}


/**
 * NP_Uranai
 * 
 * Nucleus Plugin that display uranai blog.
 * 
 * @package plugin
 * @version 1.0.0
 */
class NP_Uranai extends NucleusPlugin {
    /**
     * @var string order of uranai
     */
    // ORDER BY zodiac
    var $_order = 'zodiac';
    // ORDER BY rank
    //var $_order = 'rank';
    
    /**
     * @var array cache
     */
    var $_cache = array();
    /**
     * @var arrat default zodiac data
     */
    var $_defaultData = array(
        'id' => NULL,
        'zodiac' => 0,
        'message' => '',
        'luckeyitem' => '',
        'rank' => 0,
        'glove' => 0,
        'gmoney' => 0,
        'ghealth' => 0,
        'rakuten' => ''
     );

    function NP_Uranai() {
        $this->I18N();
    }

    function I18N() {
       $this->lng = array(
            'description'     => '星占い専用プラグイン', 
            'title'           => "星占い",
            'name_glove'      => '恋愛運', 
            'name_gmoney'     => '金運', 
            'name_ghealth'    => '健康運', 
            'name_luckeyitem' => 'ラッキーアイテム', 
            'name_message'    => 'メッセージ', 
            'name_rakuten'    => '楽天リンク作成', 
            'name_rank'       => 'ランク', 
            'name_author'     => '担当', 
            'zodiac'          => 'Aries,Taurus,Gemini,Cancer,Leo,Virgo,Libra,Scorpio,Sagittarius,Capricornus,Aquarius,Pisces', 
            'zodiacjp'        => '牡羊座,牡牛座,双子座,蟹座,獅子座,乙女座,天秤座,蠍座,射手座,山羊座,水瓶座,魚座', 
            'rank_description' => '1,2,3,4,5,6,7,8,9,10,11,12',
            'useuranai_description' => "占いプラグインを使用しますか?",
            'cleanup_description' => "アンインストール時データを削除しますか?",
            'NoInputLuckeyItem' => 'Input Luckey Item!'
        );

    }

    function getName() {
        return 'Uranai';
    }

    // author of plugin
    function getAuthor() {
        return 'takab';
    }

    // an URL to the plugin website
    // can also be of the form mailto:foo@bar.com
    function getURL() {
        return 'http://d.hatena.ne.jp/nucsl/';
    }

    // version of the plugin
    function getVersion() {
        return '1.0.0';
    }

    // a description to be shown on the installed plugins listing
    function getDescription() {
        return $this->lng['description'];
    }

    function supportsFeature($what) {
        switch ($what) {
            case 'SqlTablePrefix' :
                return 1;
            default :
                return 0;
        }
    }

    function install() {
        // Create database
        
        sql_query(
            'CREATE TABLE '
            . 'IF NOT EXISTS ' 
            . sql_table('plugin_uranai')
            . ' ('
            . 'id INTEGER NOT NULL PRIMARY KEY  auto_increment,'
            . 'itemid INTEGER NOT NULL , '
            . 'zodiac SMALLINT NOT NULL , '
            . 'message TEXT NOT NULL, '
            . 'luckeyitem VARCHAR(64) NOT NULL, '
            . 'rank SMALLINT NOT NULL,'
            . 'glove SMALLINT NOT NULL, '
            . 'gmoney SMALLINT NOT NULL, '
            . 'ghealth SMALLINT NOT NULL,'
            . 'rakuten TEXT NOT NULL'
            . ')'
        );
        echo mysql_error();
        $this->createBlogOption('UseUranai', $this->lng['useuranai_description'], 'yesno', 'no');
        $this->createOption('Cleanup', $this->lng['cleanup_description'], 'yesno', 'no');
    }

    function unInstall() {
        if ($this->getOption('Cleanup') == 'yes')
            sql_query('DROP TABLE '.sql_table('plugin_uranai'));
    }

    function getEventList() {
        return array (
            'PostAddItem', 
            'PreUpdateItem', 
            'AddItemFormExtras', 
            'EditItemFormExtras', 
            'PostDeleteItem'
        );
    }

    function getTableList() {
        return sql_table('plugin_uranai');
    }

    function event_AddItemFormExtras($data) {
        global $manager;
        $blogid= $data['blog']->blogid;
        if ($blogid && $this->getBlogOption($blogid, 'UseUranai') == 'yes') {
            $this->_showInputForm(0, $blogid, 0);
        }
    }

    function event_EditItemFormExtras($data) {
        global $CONF;
        $blogid= $data['blog']->blogid;
        if (!$blogid || $this->getBlogOption($blogid, 'UseUranai') != 'yes') {
            return;
        }

        // Query for the contents of the field
        $itemid = intval($data['variables']['itemid']);
        $authorid = intval($data['variables']['authorid']);
        $this->_showInputForm($itemid, $blogid, $authorid);
    }

    function event_PostAddItem($data) {
        global $manager;
        $itemid= intval($data['itemid']);
        
        $blogid= getBlogIDFromItemID($itemid);
        if (!$blogid || $this->getBlogOption($blogid, 'UseUranai') != 'yes') {
            return;
        }


        $input = $this->_getInput();

//        print_r($input);
        for ($i = 0; $i < 12; $i ++) {
            $this->_store($input[$i], $itemid);
        }
        
        $this->_updateAuthorid($itemid);

    }

    function event_PreUpdateItem(&$data) {
        global $manager;
        $itemid= intval($data['itemid']);
        $blogid= $data['blog']->blogid;
        if (!$blogid || $this->getBlogOption($blogid, 'UseUranai') != 'yes') {
            return;
        }

        $itemid= intval($data['itemid']);
        $input = $this->_getInput();

//        print_r($input);
        for ($i = 0; $i < 12; $i ++) {
            $this->_store($input[$i], $itemid);
        }

        $this->_updateAuthorid($itemid);
        return;
    }

    function event_PostDeleteItem($data) {
        $itemid= intval($data['itemid']);
        $query= "DELETE FROM " . sql_table('plugin_uranai')
            . " WHERE itemid='$itemid'";
        sql_query($query);
    }

    function doSkinVar() {
        global $blogid, $itemid;
        $params = func_get_args();
        $skinType = array_shift($params);
        $VarType = array_shift($params);
        switch($VarType) {
        case 'detail':
            $zodiacid = intRequestVar('zodiac');
            $template = TEMPLATE::read($params[0]);
            $zodiac = explode(',', $this->lng['zodiac']);
            $zodiacjp = explode(',', $this->lng['zodiacjp']);
            $imgdir = $this->getAdminURL();
            $this->_loadItemData($itemid, 'zodiac');
            $data = $this->_getData($itemid, $zodiacid);
            $data['message'] = nl2br($data['message']);
            $data['dsczodiac'] = $zodiac[$data['zodiac']];
            $data['dsczodiacjp'] = $zodiacjp[$data['zodiac']];
            echo TEMPLATE::fill($template['ITEM'], $data);
            break;
        default:
            break;
        }

    }

    function doTemplateVar(& $item, $template, $order = null) {
        global $blog, $currentSkinName, $CONF;
        $blogid= $blog->blogid;
        if (!$blogid || $this->getBlogOption($blogid, 'UseUranai') != 'yes') {
            return;
        }
        $itemid= intval($item->itemid);
        $order = 'rank';

        $this->_loadItemData($itemid, $order);

        $template = TEMPLATE::read($template);

        $zodiac = explode(',', $this->lng['zodiac']);
        $zodiacjp = explode(',', $this->lng['zodiacjp']);
        
        $imgdir = $CONF['SkinsURL'] . $currentSkinName . '/images/';
        $link = "?blogid=$blogid&itemid=$itemid&zodiac="; 

        for ($i = 0; $i < 12; $i++) {
        	$data = $this->_getData($itemid, $i);
            $data['zodiaclink'] = $link . $data['zodiac'];
            $data['message'] = nl2br($data['message']);
            $data['imgdir'] = $imgdir;
            $data['dsczodiac'] = $zodiac[$data['zodiac']];
            $data['dsczodiacjp'] = $zodiacjp[$data['zodiac']];
            echo TEMPLATE::fill($template['ITEM'], $data);
        }


    }
    
    function doAction($actionType)
    {
        switch($actionType) {
        case 'rakutenURL':
            $luckeyitem = urlencode(mb_convert_encoding(requestVar('luckeyitem'), 'EUC-JP'));
            header('Content-Type: text/plain');
            echo 'http://esearch.rakuten.co.jp/rms/sd/esearch/vc?e=0&sv=11&sitem=' . $luckeyitem;
            exit();
            break;
        default:
        }
    }

    
    function _loadItemData($itemid, $order = null)
    {
        if (($order != 'zodiac') && ($order != 'rank')) {
            $order = $this->_order;
        }
        $itemid = intval($itemid);
        if ($itemid && !isset($this->_cache[$itemid])) {
            $query= "SELECT * FROM " . sql_table('plugin_uranai')
                . " WHERE itemid='$itemid' ORDER BY $order";
            $res = sql_query($query);
            while($res && ($row = mysql_fetch_assoc($res))) {
                $this->_cache[$itemid][] = $row;
            }
        }
    }
    
    function _getData($itemid, $num)
    {
        if (isset($this->_cache[$itemid][$num])) {
            $res = $this->_cache[$itemid][$num];
        } else {
            $res = $this->_defaultData;
        }
        return $res;
    }
    
    function _getInput()
    {
        $input = array(
            'id' =>  requestVar('plugin_uranai_id'),
            'zodiac' =>  requestVar('plugin_uranai_zodiac'),
            'message' => requestVar('plugin_uranai_message'), 
            'luckeyitem' => requestVar('plugin_uranai_luckeyitem'), 
            'rank' => requestVar('plugin_uranai_rank'),
            'glove' => requestVar('plugin_uranai_glove'), 
            'gmoney' => requestVar('plugin_uranai_gmoney'), 
            'ghealth' => requestVar('plugin_uranai_ghealth'), 
            'rakuten' => requestVar('plugin_uranai_rakuten') 
        );
        
        for ($i = 0; $i < 12; $i ++) {
            $result[$i] = $this->_defaultData;
            if (!empty($input['id'][$i])) {
                $result[$i]['id'] = intval($input['id'][$i]);
            }
            if (!empty($input['zodiac'][$i])) {
                $result[$i]['zodiac'] = intval($input['zodiac'][$i]);
            }
            if (!empty($input['message'][$i])) {
                $result[$i]['message'] = mb_strcut($input['message'][$i], 0, 512);
            }
            if (!empty($input['luckeyitem'][$i])) {
                $result[$i]['luckeyitem'] = mb_strcut($input['luckeyitem'][$i], 0, 64);
            }
            if (!empty($input['rank'][$i])) {
                $result[$i]['rank'] = intval($input['rank'][$i]);
            }
            if (!empty($input['glove'][$i])) {
                $result[$i]['glove'] = intval($input['glove'][$i]);
            }
            if (!empty($input['gmoney'][$i])) {
                $result[$i]['gmoney'] = intval($input['gmoney'][$i]);
            }
            if (!empty($input['ghealth'][$i])) {
                $result[$i]['ghealth'] = intval($input['ghealth'][$i]);
            }
            if (!empty($input['rakuten'][$i])) {
                $result[$i]['rakuten'] = mb_strcut($input['rakuten'][$i], 0, 1024);
            }
        }
        return $result;        
    }

    function _store($data, $itemid)
    {
        if (empty($data['id'])) {
            $data['id'] = 0;
            $query= 'SELECT id FROM ' . sql_table('plugin_uranai')
                . ' WHERE itemid=' . intval($itemid)
                . ' AND zodiac=' . intval($data['zodiac']);
            $res = sql_query($query);
            if ($res) {
                $row = mysql_fetch_row($res);
                if (isset($row[0])) {
                    $data['id'] = $row[0];
                }
            }
        }
        if ($data['id']) {
            $query = "UPDATE " . sql_table('plugin_uranai')
                . ' SET '
                . 'itemid='       . intval($itemid) . ', ' 
                . 'zodiac='       . intval($data['zodiac']) . ', ' 
                . 'message=\''    . addslashes ($data['message']) . '\', ' 
                . 'luckeyitem=\'' . addslashes ($data['luckeyitem']) . '\', ' 
                . 'rank='         . intval($data['rank'])  . ', '
                . 'glove='        . intval($data['glove']) . ', ' 
                . 'gmoney='       . intval($data['gmoney']) . ', ' 
                . 'ghealth='       . intval($data['ghealth']) . ', ' 
                . 'rakuten=\''    . addslashes ($data['rakuten']) . '\'' 
                . ' WHERE id=' . intval($data['id']);
            if (sql_query($query)) {
                return true;
            }
        }
        $query= 'INSERT INTO ' . sql_table('plugin_uranai')
            . ' (itemid, zodiac, message, luckeyitem, rank, glove, gmoney, ghealth, rakuten)'
            . ' VALUES(' 
            . intval($itemid) . ', ' 
            . intval($data['zodiac']) . ', ' 
            . '\'' . addslashes ($data['message']) . '\', ' 
            . '\'' . addslashes ($data['luckeyitem']) . '\', ' 
            . intval($data['rank'])  . ', '
            . intval($data['glove']) . ', ' 
            . intval($data['gmoney']) . ', ' 
            . intval($data['ghealth']) . ', ' 
            . '\''. addslashes ($data['rakuten']) . '\'' 
            . ');';
        return sql_query($query);
    }

    function _updateAuthorid($itemid)
    {
        $authorid = intRequestVar('plugin_uranai_author');
        $query = 'UPDATE ' . sql_table('item')
            . ' SET iauthor=' . $authorid
            . ' WHERE inumber=' . intval($itemid);
        sql_query($query);
    }

    function _showInputForm($itemid, $blogid, $authorid)
    {
        global $CONF;
        // load Data (with ORDER BY zodiac)
        $this->_loadItemData($itemid, 'zodiac');
        // get zodiac name Array
        $zodiac = explode(',', $this->lng['zodiac']);
        $zodiacjp = explode(',', $this->lng['zodiacjp']);
        
        $allmembers = array();
        $query = 'SELECT mnumber, mname, mrealname'
            . ' FROM ' . sql_table('member') . ', ' . sql_table('team')
            . ' WHERE tmember=mnumber and tblog=' . $blogid;
        $res = sql_query($query);
        while($res && ($row = mysql_fetch_assoc($res))) {
            $allmembers[] = $row;
        }
        

        // display
        echo "      <h3>{$this->lng['title']}</h3>\n";
        echo "      <script src=\"javascript/prototype.js\"></script>\n";
?>
              <script>
                function UranaiRakutenLink(num) {
                    var val = $F('plugin_uranai_luckeyitem' + num);
                    if (!val) {
                        alert('<?php echoh($this->lng['NoInputLuckeyItem'])?>');
                        return;
                    }
                    var url = '<?php echoh($CONF['ActionURL'])?>';
                    var pars = 'action=plugin&name=Uranai&type=rakutenURL&luckeyitem=' + val;
                    var myAjax = new Ajax.Request(
                        url, 
                        {
                            method: 'get', 
                            parameters: pars, 
                            onComplete: function(r){
                                window.open(r.responseText);
                            } 
                        }
                    );
                }
              </script>
        <table border="0">
          <tr>
            <td>
              <label for="plugin_uranai_author"><?php echoh($this->lng['name_author'])?></label>
            </td>
            <td>
              <select id="plugin_uranai_author" name="plugin_uranai_author">
<?php
            foreach ($allmembers as $elm) {
                $selected = ($authorid == $elm['mnumber'])? ' selected="selected"'
                                                  : '';
                echo "              <option value=\"${elm['mnumber']}\"$selected>${elm['mrealname']}</option>\n";
            }
?>
              </select>
            </td>
          </tr>
        </table>
        
<?php
        for ($i = 0; $i < 12; $i ++) {
            // get a data
            $data = $this->_getData($itemid, $i);
            if (!isset($data['id'])) {
                $data['id'] = '';
            }
            
?>
        <h4 style="margin:10px 0 0"><?php echoh($zodiacjp[$i])?></h4>
        <table border="0">
          <tr>
            <td>
              <label for="plugin_uranai_rank<?php echo $i?>"><?php echoh($this->lng['name_rank'])?></label>
            </td>
            <td>
              <select id="plugin_uranai_rank<?php echo $i?>" name="plugin_uranai_rank[<?php echo $i?>]">
<?php
            foreach (explode(',' ,$this->lng['rank_description']) as $key => $val) {
                $key ++;
                $selected = ($data['rank'] == $key)? ' selected="selected"'
                                                       : '';
                echo "              <option value=\"$key\"$selected>$val</option>\n"; 
            }
?>
              </select>
            </td>
          </tr>
          <tr>
            <td>
              Luck
            </td>
            <td>
              <label for="plugin_uranai_glove<?php echo $i?>"><?php echoh($this->lng['name_glove'])?></label> : 
              <select id="plugin_uranai_glove<?php echo $i?>" name="plugin_uranai_glove[<?php echo $i?>]">
              <option<?php if($data['glove'] == 1) echo ' selected="selected"'?>>1</option>
              <option<?php if($data['glove'] == 2) echo ' selected="selected"'?>>2</option>
              <option<?php if($data['glove'] == 3) echo ' selected="selected"'?>>3</option>
              <option<?php if($data['glove'] == 4) echo ' selected="selected"'?>>4</option>
              <option<?php if($data['glove'] == 5) echo ' selected="selected"'?>>5</option>
              </select>
              &nbsp;
              <label for="plugin_uranai_gmoney<?php echo $i?>"><?php echoh($this->lng['name_gmoney'])?></label> : 
              <select id="plugin_uranai_gmoney<?php echo $i?>" name="plugin_uranai_gmoney[<?php echo $i?>]">
              <option<?php if($data['gmoney'] == 1) echo ' selected="selected"'?>>1</option>
              <option<?php if($data['gmoney'] == 2) echo ' selected="selected"'?>>2</option>
              <option<?php if($data['gmoney'] == 3) echo ' selected="selected"'?>>3</option>
              <option<?php if($data['gmoney'] == 4) echo ' selected="selected"'?>>4</option>
              <option<?php if($data['gmoney'] == 5) echo ' selected="selected"'?>>5</option>
              </select>
              &nbsp;
              <label for="plugin_uranai_ghealth<?php echo $i?>"><?php echoh($this->lng['name_ghealth'])?></label> : 
              <select id="plugin_uranai_ghealth<?php echo $i?>" name="plugin_uranai_ghealth[<?php echo $i?>]">
              <option<?php if($data['ghealth'] == 1) echo ' selected="selected"'?>>1</option>
              <option<?php if($data['ghealth'] == 2) echo ' selected="selected"'?>>2</option>
              <option<?php if($data['ghealth'] == 3) echo ' selected="selected"'?>>3</option>
              <option<?php if($data['ghealth'] == 4) echo ' selected="selected"'?>>4</option>
              <option<?php if($data['ghealth'] == 5) echo ' selected="selected"'?>>5</option>
              </select>
            </td>
          </tr>
          <tr>
            <td>
              <label for="plugin_uranai_message<?php echo $i?>"><?php echoh($this->lng['name_message'])?></label>
            </td>
            <td>
              <textarea id="plugin_uranai_message<?php echo $i?>" name="plugin_uranai_message[<?php echo $i?>]" cols="80" rows="4"><?php echoh($data['message'])?></textarea>
            </td>
          </tr>
          <tr>
            <td>
              <label for="plugin_uranai_luckeyitem<?php echo $i?>"><?php echoh($this->lng['name_luckeyitem'])?></label>
            </td>
            <td>
              <input type="text" value="<?php echoh($data['luckeyitem'])?>" id="plugin_uranai_luckeyitem<?php echo $i?>" name="plugin_uranai_luckeyitem[<?php echo $i?>]" size="64" maxlength="64" />
            </td>
          </tr>
          <tr>
            <td>
              <label for="plugin_uranai_rakuten<?php echo $i?>"><?php echoh($this->lng['name_rakuten'])?></label>
            </td>
            <td>
              <input type="button" value="search" onclick="javascript:UranaiRakutenLink(<?php echo $i?>);"/><br />
              <textarea id="plugin_uranai_rakuten<?php echo $i?>" name="plugin_uranai_rakuten[<?php echo $i?>]" cols="80" rows="8"><?php echoh($data['rakuten'])?></textarea>
              <input type="hidden" name="plugin_uranai_id[<?php echo $i?>]" value="<?php echoh($data['id'])?>" />
              <input type="hidden" name="plugin_uranai_zodiac[<?php echo $i?>]" value="<?php echo $i?>" />
            </td>
          </tr>
        </table>
<?php
        }
    }
}
?>