/* Copyright 2013 Akira Ohta (akohta001@gmail.com)
    This file is part of ntch.

    The ntch is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    The ntch is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ntch.  If not, see <http://www.gnu.org/licenses/>.
    
*/
#ifndef _NT_TIMER_h_
#define _NT_TIMER_h_
#include <sys/times.h>

typedef int (*nt_timer_fn)(int id);

typedef struct tag_nt_timer_handle *nt_timer_handle;
typedef struct tag_nt_timer_handle{
	int chk_sum;
}nt_timer_handle_t;


extern BOOL nt_timer_lib_init();
extern void nt_timer_lib_finish();
extern nt_timer_handle nt_timer_ring_a_bell();
extern nt_timer_handle nt_timer_alloc(
		int id, int interval, nt_timer_fn func);
extern BOOL nt_timer_set_interval(nt_timer_handle h_timer, int interval);
extern int nt_timer_get_interval(nt_timer_handle h_timer);
extern int nt_timer_get_id(nt_timer_handle h_timer);
extern int nt_timer_add_ref(nt_timer_handle h_timer);
extern int nt_timer_release_ref(nt_timer_handle h_timer);


#endif /* _NT_TIMER_h_ */
