/* Copyright 2014 Akira Ohta (akohta001@gmail.com)
    This file is part of ntch.

    The ntch is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    The ntch is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ntch.  If not, see <http://www.gnu.org/licenses/>.
    
*/
#ifndef _NG_WORD_T_H_
#define _NG_WORD_T_H_

#include "utils/nt_std_t.h"
#include "utils/nt_mutex.h"
#ifdef NT_CLOUD
#include "cloud/nt_cloud.h"
#endif

#define NG_ITEM_NONE 0
#define NG_ITEM_MSG  1
#define NG_ITEM_NAME 2
#define NG_ITEM_ID   4
#define NG_ITEM_ALL  7


typedef struct tag_nt_ng_word_handle{
	int chk_sum;
} nt_ng_word_handle_t, *nt_ng_word_handle;

extern int nt_ng_word_add_ref(nt_ng_word_handle handle);
extern int nt_ng_word_release_ref(nt_ng_word_handle handle);

extern nt_mutex_handle nt_ng_get_mutex(nt_ng_word_handle handle);
extern nt_mutex_handle nt_ng_word_get_mutex(nt_ng_word_handle handle);
extern nt_mutex_handle nt_ng_name_get_mutex(nt_ng_word_handle handle);
extern nt_mutex_handle nt_ng_id_get_mutex(nt_ng_word_handle handle);

extern nt_ng_word_handle nt_ng_word_load(
#ifdef NT_CLOUD
		nt_cloud_handle h_cloud,
#endif
		const char *ng_word_file_name,
		const char *ng_name_file_name,
		const char *ng_id_file_name
		);
extern BOOL nt_ng_word_save(nt_ng_word_handle handle,
		const char *ng_word_file_name,
		const char *ng_name_file_name,
		const char *ng_id_file_name
		);

#ifdef NT_CLOUD
extern BOOL nt_ng_word_upload_cloud(
		nt_cloud_handle h_cloud, nt_ng_word_handle h_ng_word);
extern BOOL nt_ng_word_add_ng_word(nt_cloud_handle h_cloud,
		nt_ng_word_handle handle, const char *ng_word);
extern BOOL nt_ng_word_add_ng_name(nt_cloud_handle h_cloud,
		nt_ng_word_handle handle, const char *ng_name);
extern BOOL nt_ng_word_add_ng_id(nt_cloud_handle h_cloud,
		nt_ng_word_handle handle, const char *ng_id);
extern BOOL nt_ng_word_set_words(
		nt_ng_word_handle handle, nt_link_tp text_list,
		nt_cloud_handle h_cloud);
extern BOOL nt_ng_word_set_names(
		nt_ng_word_handle handle, nt_link_tp text_list,
		nt_cloud_handle h_cloud);
extern BOOL nt_ng_word_set_ids(
		nt_ng_word_handle handle, nt_link_tp text_list,
		nt_cloud_handle h_cloud);

#else
extern BOOL nt_ng_word_add_ng_word(
		nt_ng_word_handle handle, const char *ng_word);
extern BOOL nt_ng_word_add_ng_name(
		nt_ng_word_handle handle, const char *ng_name);
extern BOOL nt_ng_word_add_ng_id(
		nt_ng_word_handle handle, const char *ng_id);
extern BOOL nt_ng_word_set_words(nt_ng_word_handle handle, nt_link_tp text_list);
extern BOOL nt_ng_word_set_names(nt_ng_word_handle handle, nt_link_tp text_list);
extern BOOL nt_ng_word_set_ids(nt_ng_word_handle handle, nt_link_tp text_list);

#endif
extern int ng_word_match(nt_ng_word_handle handle,
		int item_type, const wchar_t *source, 
		wchar_t *match, size_t match_buf_len);
extern nt_link_tp nt_ng_word_get_words(nt_ng_word_handle handle);
extern nt_link_tp nt_ng_word_get_names(nt_ng_word_handle handle);
extern nt_link_tp nt_ng_word_get_ids(nt_ng_word_handle handle);


#endif /* _NG_WORD_T_H_ */

