/* Copyright 2013,2014 Akira Ohta (akohta001@gmail.com)
    This file is part of ntch.

    The ntch is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    The ntch is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ntch.  If not, see <http://www.gnu.org/licenses/>.
    
*/
#ifndef _ENV_H_
#define _ENV_H_

#include "config.h"

extern char LOG_PATH[];
extern char USR_PATH[];
extern char USR_COOKIE_PATH[];
extern char USR_LOG_DB_PATH[];
extern char USR_FAVORITE_BOARD_FILE_PATH[];
extern char USR_FAVORITE_GRP_FILE_PATH[];
extern char USR_FAVORITE_THREAD_FILE_PATH[];
extern char USR_NG_WORD_FILE_PATH[];
extern char USR_NG_NAME_FILE_PATH[];
extern char USR_NG_ID_FILE_PATH[];

extern char *RFC2898_SALT;
extern int  RFC2898_ITERATION;
extern char *AES256_PASS;
extern char *NCE_AUTH_URL;
extern char *NCE_ID;
extern char *NCE_PASS;
extern char CA_FILE_PATH[];

extern int FORCE_REFRESH;
extern int THREAD_SORT_TYPE; 
extern int INIT_DISP_STATE; 
extern int NT_MAINLOOP_POLLING_INTERVAL;
extern int NT_PTHREAD_POOL_SIZE;
extern int NT_PTHREAD_POOL_QUEUE_SIZE;
extern int NT_AUTO_UPDATE_INTERVAL;
extern int NT_AUTO_SCROLL_INTERVAL;

extern int APP_MODE;


extern char EDITOR_CMD[]; 
extern char *MARU_ID;
extern char *MARU_PW;

#define NT_APP_MODE_SERVER 1
#define NT_APP_MODE_CLIENT 2

#define NT_THREAD_SORT_BY_NUMBER 1
#define NT_THREAD_SORT_BY_UNREAD 2
#define NT_THREAD_SORT_BY_READ 3

#define NT_INTI_DISP_BOARDMENU 1
#define NT_INTI_DISP_FAVORITE  2
#define NT_INTI_DISP_HISTORY   3

#define NT_KEY_NONE (0)
#define NT_KEY_UP 'k'
#define NT_KEY_DOWN 'j'
#define NT_KEY_LEFT 'h'
#define NT_KEY_RIGHT 'l'
#define NT_KEY_PAGEUP 'b'
#define NT_KEY_PAGEDOWN 'f'
#define NT_KEY_SELECT ' '
#define NT_KEY_QUIT 'q'
#define NT_KEY_CLOSE 'c'
#define NT_KEY_ERASE 'z'
#define NT_KEY_ADD 'a'
#define NT_KEY_DEL 'd'
#define NT_KEY_BOTTOM 'g'
#define NT_KEY_REFRESH 'r'
#define NT_KEY_COMMAND1 ':' 
#define NT_KEY_COMMAND2 '/' 
#define NT_KEY_COMMAND3 '?'
#define NT_KEY_CMD_BASE (65536)
#define NT_KEY_CMD_BOARD_UPDATE (65536 + 1)
#define NT_KEY_CMD_AUTO_SCROLL (65536 + 2)
#define NT_KEY_CMD_FAVORITE_UPDATE (65536 + 3)
#define NT_KEY_CMD_NGWORD_UPDATE (65536 + 4)

#define NT_COMMAND1_WRITE_MSG_1 "write"
#define NT_COMMAND1_WRITE_MSG_2 "w"
#define NT_COMMAND1_JMP_NEW_1 "new"
#define NT_COMMAND1_JMP_NEW_2 "n"
#define NT_COMMAND1_SORT_1 "sort"
#define NT_COMMAND1_SORT_2 "s"
#define NT_COMMAND1_SORT_NUMBER_1 "number"
#define NT_COMMAND1_SORT_NUMBER_2 "n"
#define NT_COMMAND1_SORT_READ_1 "read" 
#define NT_COMMAND1_SORT_READ_2 "r" 
#define NT_COMMAND1_SORT_UNREAD_1 "unread"
#define NT_COMMAND1_SORT_UNREAD_2 "u"
#define NT_COMMAND1_DEL_THREAD_LOG_1 "del"
#define NT_COMMAND1_DEL_THREAD_LOG_2 "d"
#define NT_COMMAND1_TREE_1 "tree"
#define NT_COMMAND1_TREE_2 "t"
#define NT_COMMAND1_ID_1 "id"
#define NT_COMMAND1_ID_2 "i"
#define NT_COMMAND1_SEARCH_1 "search"
#define NT_COMMAND1_SEARCH_2 "se"
#define NT_COMMAND1_FAVORITE_1 "favorite"
#define NT_COMMAND1_FAVORITE_2 "f"
#define NT_COMMAND1_HISTORY_1 "history"
#define NT_COMMAND1_HISTORY_2 "h"
#define NT_COMMAND1_AUTOSCROLL_1 "autoscroll"
#define NT_COMMAND1_AUTOSCROLL_2 "a"
#define NT_COMMAND1_TIMER "timer"
#define NT_COMMAND1_UPLOAD_1 "upload"
#define NT_COMMAND1_UPLOAD_BOARD1 "board"
#define NT_COMMAND1_UPLOAD_BOARD2 "b"
#define NT_COMMAND1_UPLOAD_THREAD1 "thread"
#define NT_COMMAND1_UPLOAD_THREAD2 "t"
#define NT_COMMAND1_EDIT_FAVORITE_1 "edit"
#define NT_COMMAND1_EDIT_FAVORITE_2 "e"
#define NT_COMMAND1_EDIT_FAVORITE_BOARD1 "board"
#define NT_COMMAND1_EDIT_FAVORITE_BOARD2 "b"
#define NT_COMMAND1_EDIT_FAVORITE_THREAD1 "thread"
#define NT_COMMAND1_EDIT_FAVORITE_THREAD2 "t"
#define NT_COMMAND1_UPLOAD_NG_FILE1 "ng"
#define NT_COMMAND1_UPLOAD_NG_FILE2 "n"
#define NT_COMMAND1_LIMIT_1 "limit"
#define NT_COMMAND1_LIMIT_2 "l"
#define NT_COMMAND1_NG_WORD_1 "ngword"
#define NT_COMMAND1_NG_WORD_2 "ngwd"
#define NT_COMMAND1_NG_NAME_1 "ngname"
#define NT_COMMAND1_NG_NAME_2 "ngnm"
#define NT_COMMAND1_NG_ID_1 "ngid"
#define NT_COMMAND1_OPEN_LINK_1 "link"
#define NT_COMMAND1_OPEN_LINK_2 "l"
#define NT_COMMAND1_REPLACE_RES_TEXT_1 "replace"
#define NT_COMMAND1_REPLACE_RES_TEXT_2 "r"

extern int set_option(int argc, char* argv[]);

extern void nt_env_free();

#endif /*  _ENV_H_ */
