#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <wchar.h>
#include <iconv.h>
#include <errno.h>

#include    "utils/nt_std_t.h"


BOOL nt_conv_sjis2wc(iconv_t icd,
	const char *src, wchar_t *data, size_t data_len)
{
	char *p_src, *p_dst;
	size_t n_src, n_dst, sz;
	p_src = (char*)src;
	p_dst = (char*)data;
	n_src = strlen(src) * sizeof(char);
	n_dst = data_len;
	while(0 < n_src){
		sz = iconv(icd, &p_src, &n_src, &p_dst, &n_dst);
		if(sz == -1){
			perror("e");
			return FALSE;
		}
	}
	*((wchar_t*)p_dst) = L'\0';
	return TRUE;
}

BOOL nt_conv_wc2sjis(iconv_t icd,
	const wchar_t *src, char *data, size_t data_len)
{
	char *p_src, *p_dst;
	size_t n_src, n_dst, sz;
	p_src = (char*)src;
	p_dst = data;
	n_src = wcslen(src) * sizeof(wchar_t);
	n_dst = data_len;
	while(0 < n_src){
		sz = iconv(icd, &p_src, &n_src, &p_dst, &n_dst);
		if(sz == -1){
			perror("e");
			return FALSE;
		}
	}
	*p_dst = '\0';
	return TRUE;
}

BOOL nt_conv_local2sjis(iconv_t icd,
	const char *src, char *data, size_t data_len)
{
	char	*p_src, *p_dst;
	size_t  n_src,  n_dst, sz;
	p_src = (char*)src;
	p_dst = data;
	n_src = strlen(p_src);
	n_dst = data_len;
	while(0 < n_src){
		sz = iconv(icd, &p_src, &n_src, &p_dst, &n_dst);
		if(((size_t)-1) == sz){
			return FALSE;
		}
	}
	*p_dst = '\0';
	return TRUE;
}
