#include <stdlib.h>
#include <assert.h>
#include <ncursesw/ncurses.h>


#include "utils/nt_std_t.h"
#include "ui/disp_win.h"


nt_window_tp nt_disp_win_alloc(WINDOW *parent,
		int lines, int cols, int org_y, int org_x, 
		const char *cmd_param)
{
	WINDOW *win;
	nt_window_tp winp;

	assert(parent);

	win = subwin(parent, lines, cols, org_y, org_x);
	if(!win)
		return NULL;
	winp = malloc(sizeof(nt_window_t));
	if(!winp)
		return NULL;
	winp->wp = win;
	winp->lines = lines;
	winp->cols = cols;
	winp->org_x = org_x;
	winp->org_y = org_y;
	winp->data = 0;
	winp->cmd_param = cmd_param;
	winp->status_msg = NULL;
	return winp;
}


void nt_disp_win_free(nt_window_tp winp)
{
	assert(winp->wp);
	assert(winp);

	if(winp->wp)
		delwin(winp->wp);
	free(winp);
}


BOOL nt_disp_win_move(WINDOW *parent, nt_window_tp winp,
		int lines, int cols, int org_y, int org_x)
{
	if(winp->org_y != org_y || winp->org_x != org_x){
		delwin(winp->wp);
		winp->wp = subwin(parent, lines, cols, org_y, org_x);
		if(!winp->wp)
			return FALSE;
		winp->lines = lines;
		winp->cols = cols;
		winp->org_x = org_x;
		winp->org_y = org_y;
	}else if(winp->lines != lines || winp->cols != cols){
		winp->lines = lines;
		winp->cols = cols;
	}
	return TRUE;
}

